/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.dynamic.DynamicStateManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;

public class DefaultDynamicStateManager
implements DynamicStateManager {
    @Override
    public ExecutionEntity resolveActiveExecution(String executionId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(executionId);
        if (execution == null) {
            throw new FlowableException("Execution could not be found with id " + executionId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        return execution;
    }

    @Override
    public ExecutionEntity resolveActiveExecution(String processInstanceId, String activityId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        if (processExecution == null) {
            throw new FlowableException("Execution could not be found with id " + processInstanceId);
        }
        if (!processExecution.isProcessInstanceType()) {
            throw new FlowableException("Execution is not a process instance type execution for id " + processInstanceId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processExecution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        ExecutionEntity execution = this.getActiveExecution(activityId, processExecution, commandContext);
        return execution;
    }

    @Override
    public void moveExecutionState(ExecutionEntity execution, String fromActivityId, String toActivityId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
        FlowElement cancelActivityElement = bpmnModel.getFlowElement(fromActivityId);
        FlowElement startActivityElement = bpmnModel.getFlowElement(toActivityId);
        if (startActivityElement == null) {
            throw new FlowableException("Activity could not be found in process definition for id " + toActivityId);
        }
        ExecutionEntity continueParentExecution = this.deleteParentExecutions(execution, cancelActivityElement, startActivityElement, commandContext);
        if (!execution.isDeleted()) {
            executionEntityManager.deleteExecutionAndRelatedData(execution, "Change activity to " + toActivityId);
        }
        ArrayList<SubProcess> subProcessesToCreate = new ArrayList<SubProcess>();
        this.resolveSubProcesExecutionsToCreate(cancelActivityElement, startActivityElement, subProcessesToCreate);
        ExecutionEntity lastSubProcessChildExecution = null;
        for (SubProcess subProcess : subProcessesToCreate) {
            FlowElement startElement = this.getStartElement(subProcess);
            if (startElement == null) {
                throw new FlowableException("No initial activity found for subprocess " + subProcess.getId());
            }
            ExecutionEntity newChildExecution = executionEntityManager.createChildExecution(continueParentExecution);
            newChildExecution.setCurrentFlowElement((FlowElement)subProcess);
            newChildExecution.setScope(true);
            CommandContextUtil.getHistoryManager(commandContext).recordActivityStart(newChildExecution);
            ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
            processInstanceHelper.processAvailableEventSubProcesses(newChildExecution, (FlowElementsContainer)subProcess, commandContext);
            ExecutionEntity startSubProcessExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(newChildExecution);
            startSubProcessExecution.setCurrentFlowElement(startElement);
            lastSubProcessChildExecution = startSubProcessExecution;
        }
        ExecutionEntity newChildExecution = null;
        newChildExecution = lastSubProcessChildExecution != null ? lastSubProcessChildExecution : executionEntityManager.createChildExecution(continueParentExecution);
        newChildExecution.setCurrentFlowElement(startActivityElement);
        CommandContextUtil.getAgenda().planContinueProcessOperation(newChildExecution);
    }

    protected ExecutionEntity getActiveExecution(String activityId, ExecutionEntity processExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity activeExecutionEntity = null;
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processExecution.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            if (!childExecution.getCurrentActivityId().equals(activityId)) continue;
            activeExecutionEntity = childExecution;
        }
        if (activeExecutionEntity == null) {
            throw new FlowableException("Active execution could not be found with activity id " + activityId);
        }
        return activeExecutionEntity;
    }

    protected ExecutionEntity deleteParentExecutions(ExecutionEntity execution, FlowElement cancelActivityElement, FlowElement startActivityElement, CommandContext commandContext) {
        ExecutionEntity toDeleteParentExecution;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity continueParentExecution = execution.getParent();
        if (cancelActivityElement.getSubProcess() != null && (toDeleteParentExecution = this.resolveParentExecutionToDelete(execution, cancelActivityElement, startActivityElement)) != null) {
            continueParentExecution = toDeleteParentExecution.getParent();
            executionEntityManager.deleteChildExecutions(toDeleteParentExecution, "Change activity to " + startActivityElement.getId(), true);
            executionEntityManager.deleteExecutionAndRelatedData(toDeleteParentExecution, "Change activity to " + startActivityElement.getId());
        }
        return continueParentExecution;
    }

    protected void resolveSubProcesExecutionsToCreate(FlowElement cancelActivityElement, FlowElement searchElement, List<SubProcess> subProcesses) {
        if (searchElement.getSubProcess() != null) {
            if (cancelActivityElement.getSubProcess() == null) {
                subProcesses.add(0, cancelActivityElement.getSubProcess());
            } else {
                boolean foundSubProcessId = false;
                FlowElement childElement = cancelActivityElement;
                while (childElement.getSubProcess() != null) {
                    if (childElement.getSubProcess().getId().equals(searchElement.getSubProcess().getId())) {
                        foundSubProcessId = true;
                        break;
                    }
                    childElement = childElement.getSubProcess();
                }
                if (!foundSubProcessId) {
                    subProcesses.add(0, cancelActivityElement.getSubProcess());
                }
            }
            this.resolveSubProcesExecutionsToCreate(cancelActivityElement, (FlowElement)searchElement.getSubProcess(), subProcesses);
        }
    }

    protected ExecutionEntity resolveParentExecutionToDelete(ExecutionEntity execution, FlowElement cancelActivityElement, FlowElement startActivityElement) {
        ExecutionEntity parentExecution = execution.getParent();
        if (parentExecution.isProcessInstanceType()) {
            return null;
        }
        if (!(cancelActivityElement.getSubProcess() == null || startActivityElement.getSubProcess() != null && startActivityElement.getSubProcess().getId().equals(parentExecution.getActivityId()))) {
            ExecutionEntity subProcessParentExecution = this.resolveParentExecutionToDelete(parentExecution, (FlowElement)cancelActivityElement.getSubProcess(), startActivityElement);
            if (subProcessParentExecution != null) {
                return subProcessParentExecution;
            }
            return parentExecution;
        }
        return null;
    }

    protected FlowElement getStartElement(SubProcess subProcess) {
        if (CollectionUtil.isNotEmpty((Collection)subProcess.getFlowElements())) {
            for (FlowElement subElement : subProcess.getFlowElements()) {
                StartEvent startEvent;
                if (!(subElement instanceof StartEvent) || !CollectionUtil.isEmpty((Collection)(startEvent = (StartEvent)subElement).getEventDefinitions())) continue;
                return startEvent;
            }
        }
        return null;
    }
}

