/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableWrongDbException;
import org.flowable.engine.common.impl.FlowableVersions;
import org.flowable.engine.common.impl.db.AbstractSqlScriptBasedDbSchemaManager;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.engine.impl.persistence.entity.PropertyEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDbSchemaManager.class);
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"6.2.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.2.1.0", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        LOGGER.debug("flowable db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        String selectSchemaVersionStatement = dbSqlSession.getDbSqlSessionFactory().mapStatement("org.flowable.engine.impl.persistence.entity.PropertyEntityImpl.selectDbSchemaVersion");
        return (String)dbSqlSession.getSqlSession().selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        this.getCommonDbSchemaManager().dbSchemaCreate();
        this.getIdentityLinkDbSchemaManager().dbSchemaCreate();
        this.getTaskDbSchemaManager().dbSchemaCreate();
        this.getVariableDbSchemaManager().dbSchemaCreate();
        this.getJobDbSchemaManager().dbSchemaCreate();
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"6.2.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.2.1.0", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        try {
            this.executeMandatorySchemaResource("drop", "engine");
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
                this.executeMandatorySchemaResource("drop", "history");
            }
        }
        catch (Exception e) {
            LOGGER.info("Error dropping engine tables", (Throwable)e);
        }
        try {
            this.getJobDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping job tables", (Throwable)e);
        }
        try {
            this.getVariableDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getTaskDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping task tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping common tables", (Throwable)e);
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
    }

    public String dbSchemaUpdate() {
        PropertyEntity dbVersionProperty = null;
        String dbVersion = null;
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        int version6120Index = FlowableVersions.getFlowableVersionIndexForDbVersion((String)"6.1.2.0");
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        boolean isEngineTablePresent = this.isEngineTablePresent();
        if (isEngineTablePresent) {
            dbVersionProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntityImpl.class, "schema.version");
            dbVersion = dbVersionProperty.getValue();
            matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion((String)dbVersion);
            isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
        }
        boolean isHistoryTablePresent = this.isHistoryTablePresent();
        if (isUpgradeNeeded && matchingVersionIndex < version6120Index) {
            this.dbSchemaUpgradeUntil6120("engine", matchingVersionIndex);
            if (isHistoryTablePresent) {
                this.dbSchemaUpgradeUntil6120("history", matchingVersionIndex);
            }
        }
        this.getCommonDbSchemaManager().dbSchemaUpdate();
        this.getIdentityLinkDbSchemaManager().dbSchemaUpdate();
        this.getTaskDbSchemaManager().dbSchemaUpdate();
        this.getVariableDbSchemaManager().dbSchemaUpdate();
        this.getJobDbSchemaManager().dbSchemaUpdate();
        if (isUpgradeNeeded) {
            PropertyEntity dbHistoryProperty;
            dbVersionProperty.setValue("6.2.1.0");
            if ("5.0".equals(dbVersion)) {
                dbHistoryProperty = (PropertyEntity)CommandContextUtil.getPropertyEntityManager().create();
                dbHistoryProperty.setName("schema.history");
                dbHistoryProperty.setValue("create(5.0)");
                dbSqlSession.insert((Entity)dbHistoryProperty);
            } else {
                dbHistoryProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntity.class, "schema.history");
            }
            String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "6.2.1.0" + ")";
            dbHistoryProperty.setValue(dbHistoryValue);
            if (version6120Index > matchingVersionIndex) {
                this.dbSchemaUpgrade("engine", version6120Index);
            } else {
                this.dbSchemaUpgrade("engine", matchingVersionIndex);
            }
            feedback = "upgraded Flowable from " + dbVersion + " to " + "6.2.1.0";
        } else if (!isEngineTablePresent) {
            this.dbSchemaCreateEngine();
        }
        if (isHistoryTablePresent) {
            if (isUpgradeNeeded) {
                if (version6120Index > matchingVersionIndex) {
                    this.dbSchemaUpgrade("history", version6120Index);
                } else {
                    this.dbSchemaUpgrade("history", matchingVersionIndex);
                }
            }
        } else if (dbSqlSession.getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        return feedback;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("6.2.1.0".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("6.2.1.0");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new FlowableException("Version of flowable database (" + versionInDatabase + ") is more recent than the engine (" + "6.2.1.0" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            LOGGER.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"6.2.1.0");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        LOGGER.debug("Executing performSchemaOperationsProcessEngineBuild with setting {}", (Object)databaseSchemaUpdate);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    protected DbSchemaManager getCommonDbSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getCommonDbSchemaManager();
    }

    protected DbSchemaManager getIdentityLinkDbSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getIdentityLinkDbSchemaManager();
    }

    protected DbSchemaManager getVariableDbSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getVariableDbSchemaManager();
    }

    protected DbSchemaManager getTaskDbSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getTaskDbSchemaManager();
    }

    protected DbSchemaManager getJobDbSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getJobDbSchemaManager();
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/db/";
    }
}

