/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.dynamic.DynamicStateManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.runtime.ChangeActivityStateBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ChangeActivityStateCmd
implements Command<Void> {
    protected final String processInstanceId;
    protected final String executionId;
    protected final String cancelActivityId;
    protected final String startActivityId;

    public ChangeActivityStateCmd(ChangeActivityStateBuilderImpl changeActivityStateBuilder) {
        this.processInstanceId = changeActivityStateBuilder.getProcessInstanceId();
        this.executionId = changeActivityStateBuilder.getExecutionId();
        this.cancelActivityId = changeActivityStateBuilder.getCancelActivityId();
        this.startActivityId = changeActivityStateBuilder.getStartActivityId();
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null && this.executionId == null) {
            throw new FlowableIllegalArgumentException("Process instance id or execution id is required");
        }
        DynamicStateManager dynamicStateManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDynamicStateManager();
        String fromActivityId = null;
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = dynamicStateManager.resolveActiveExecution(this.executionId, commandContext);
            fromActivityId = execution.getCurrentFlowElement().getId();
        } else {
            execution = dynamicStateManager.resolveActiveExecution(this.processInstanceId, this.cancelActivityId, commandContext);
            fromActivityId = this.cancelActivityId;
        }
        dynamicStateManager.moveExecutionState(execution, fromActivityId, this.startActivityId, commandContext);
        return null;
    }
}

