/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskParseHandler
extends AbstractActivityBpmnParseHandler<ServiceTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ServiceTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ServiceTask serviceTask) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if (serviceTask.getType().equalsIgnoreCase("mail")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("mule")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("camel")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("shell")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createShellActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("dmn")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createDmnActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("http")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createHttpActivityBehavior(serviceTask));
            } else {
                LOGGER.warn("Invalid type: '{}' for service task {}", (Object)serviceTask.getType(), (Object)serviceTask.getId());
            }
        } else if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createClassDelegateServiceTask(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(serviceTask, bpmnParse.getBpmnModel());
            serviceTask.setBehavior((Object)webServiceActivityBehavior);
        } else {
            LOGGER.warn("One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on service task {}", (Object)serviceTask.getId());
        }
    }
}

