/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.utils;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.elasticsearch.geo.geometry.Circle;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryCollection;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.MultiLine;
import org.elasticsearch.geo.geometry.MultiPoint;
import org.elasticsearch.geo.geometry.MultiPolygon;
import org.elasticsearch.geo.geometry.Point;
import org.elasticsearch.geo.geometry.Polygon;
import org.elasticsearch.geo.geometry.Rectangle;
import org.elasticsearch.geo.utils.GeometryValidator;

public class WellKnownText {
    public static final String EMPTY = "EMPTY";
    public static final String SPACE = " ";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String NAN = "NaN";
    private final String NUMBER = "<NUMBER>";
    private final String EOF = "END-OF-STREAM";
    private final String EOL = "END-OF-LINE";
    private final boolean coerce;
    private final GeometryValidator validator;

    public WellKnownText(boolean coerce, GeometryValidator validator) {
        this.coerce = coerce;
        this.validator = validator;
    }

    public String toWKT(Geometry geometry) {
        StringBuilder builder = new StringBuilder();
        this.toWKT(geometry, builder);
        return builder.toString();
    }

    public void toWKT(Geometry geometry, final StringBuilder sb) {
        sb.append(WellKnownText.getWKTName(geometry));
        sb.append(SPACE);
        if (geometry.isEmpty()) {
            sb.append(EMPTY);
        } else {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

                @Override
                public Void visit(Circle circle) {
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(circle.getLon(), circle.getLat(), Double.NaN);
                    sb.append(WellKnownText.SPACE);
                    sb.append(circle.getRadiusMeters());
                    if (circle.hasAlt()) {
                        sb.append(WellKnownText.SPACE);
                        sb.append(circle.getAlt());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(GeometryCollection<?> collection) {
                    if (collection.size() == 0) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        WellKnownText.this.toWKT((Geometry)collection.get(0), sb);
                        for (int i = 1; i < collection.size(); ++i) {
                            sb.append(WellKnownText.COMMA);
                            WellKnownText.this.toWKT((Geometry)collection.get(i), sb);
                        }
                        sb.append(WellKnownText.RPAREN);
                    }
                    return null;
                }

                @Override
                public Void visit(Line line) {
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(line.getLon(0), line.getLat(0), line.getAlt(0));
                    for (int i = 1; i < line.length(); ++i) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        this.visitPoint(line.getLon(i), line.getLat(i), line.getAlt(i));
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(LinearRing ring) {
                    throw new IllegalArgumentException("Linear ring is not supported by WKT");
                }

                @Override
                public Void visit(MultiLine multiLine) {
                    this.visitCollection(multiLine);
                    return null;
                }

                @Override
                public Void visit(MultiPoint multiPoint) {
                    if (multiPoint.isEmpty()) {
                        sb.append(WellKnownText.EMPTY);
                        return null;
                    }
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(((Point)multiPoint.get(0)).getLon(), ((Point)multiPoint.get(0)).getLat(), ((Point)multiPoint.get(0)).getAlt());
                    for (int i = 1; i < multiPoint.size(); ++i) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        Point point = (Point)multiPoint.get(i);
                        this.visitPoint(point.getLon(), point.getLat(), point.getAlt());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(MultiPolygon multiPolygon) {
                    this.visitCollection(multiPolygon);
                    return null;
                }

                @Override
                public Void visit(Point point) {
                    if (point.isEmpty()) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        this.visitPoint(point.getLon(), point.getLat(), point.getAlt());
                        sb.append(WellKnownText.RPAREN);
                    }
                    return null;
                }

                private void visitPoint(double lon, double lat, double alt) {
                    sb.append(lon).append(WellKnownText.SPACE).append(lat);
                    if (!Double.isNaN(alt)) {
                        sb.append(WellKnownText.SPACE).append(alt);
                    }
                }

                private void visitCollection(GeometryCollection<?> collection) {
                    if (collection.size() == 0) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        collection.get(0).visit(this);
                        for (int i = 1; i < collection.size(); ++i) {
                            sb.append(WellKnownText.COMMA);
                            collection.get(i).visit(this);
                        }
                        sb.append(WellKnownText.RPAREN);
                    }
                }

                @Override
                public Void visit(Polygon polygon) {
                    sb.append(WellKnownText.LPAREN);
                    this.visit((Line)polygon.getPolygon());
                    int numberOfHoles = polygon.getNumberOfHoles();
                    for (int i = 0; i < numberOfHoles; ++i) {
                        sb.append(", ");
                        this.visit((Line)polygon.getHole(i));
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(Rectangle rectangle) {
                    sb.append(WellKnownText.LPAREN);
                    sb.append(rectangle.getMinLon());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxLon());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxLat());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMinLat());
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry fromWKT(String wkt) throws IOException, ParseException {
        try (StringReader reader = new StringReader(wkt);){
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            tokenizer.whitespaceChars(13, 13);
            tokenizer.whitespaceChars(10, 10);
            tokenizer.commentChar(35);
            Geometry geometry = this.parseGeometry(tokenizer);
            this.validator.validate(geometry);
            Geometry geometry2 = geometry;
            return geometry2;
        }
    }

    private Geometry parseGeometry(StreamTokenizer stream) throws IOException, ParseException {
        String type;
        switch (type = this.nextWord(stream).toLowerCase(Locale.ROOT)) {
            case "point": {
                return this.parsePoint(stream);
            }
            case "multipoint": {
                return this.parseMultiPoint(stream);
            }
            case "linestring": {
                return this.parseLine(stream);
            }
            case "multilinestring": {
                return this.parseMultiLine(stream);
            }
            case "polygon": {
                return this.parsePolygon(stream);
            }
            case "multipolygon": {
                return this.parseMultiPolygon(stream);
            }
            case "bbox": {
                return this.parseBBox(stream);
            }
            case "geometrycollection": {
                return this.parseGeometryCollection(stream);
            }
            case "circle": {
                return this.parseCircle(stream);
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + type);
    }

    private GeometryCollection<Geometry> parseGeometryCollection(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return GeometryCollection.EMPTY;
        }
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        shapes.add(this.parseGeometry(stream));
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            shapes.add(this.parseGeometry(stream));
        }
        return new GeometryCollection<Geometry>(shapes);
    }

    private Point parsePoint(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Point.EMPTY;
        }
        double lon = this.nextNumber(stream);
        double lat = this.nextNumber(stream);
        Point pt = this.isNumberNext(stream) ? new Point(lat, lon, this.nextNumber(stream)) : new Point(lat, lon);
        this.nextCloser(stream);
        return pt;
    }

    private void parseCoordinates(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        this.parseCoordinate(stream, lats, lons, alts);
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            this.parseCoordinate(stream, lats, lons, alts);
        }
    }

    private void parseCoordinate(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        lons.add(this.nextNumber(stream));
        lats.add(this.nextNumber(stream));
        if (this.isNumberNext(stream)) {
            alts.add(this.nextNumber(stream));
        }
        if (!alts.isEmpty() && alts.size() != lons.size()) {
            throw new ParseException("coordinate dimensions do not match: " + this.tokenString(stream), stream.lineno());
        }
    }

    private MultiPoint parseMultiPoint(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiPoint.EMPTY;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        ArrayList<Point> points = new ArrayList<Point>();
        this.parseCoordinates(stream, lats, lons, alts);
        for (int i = 0; i < lats.size(); ++i) {
            if (alts.isEmpty()) {
                points.add(new Point(lats.get(i), lons.get(i)));
                continue;
            }
            points.add(new Point(lats.get(i), lons.get(i), alts.get(i)));
        }
        return new MultiPoint(Collections.unmodifiableList(points));
    }

    private Line parseLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return Line.EMPTY;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons, alts);
        if (alts.isEmpty()) {
            return new Line(this.toArray(lats), this.toArray(lons));
        }
        return new Line(this.toArray(lats), this.toArray(lons), this.toArray(alts));
    }

    private MultiLine parseMultiLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiLine.EMPTY;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(this.parseLine(stream));
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            lines.add(this.parseLine(stream));
        }
        return new MultiLine(Collections.unmodifiableList(lines));
    }

    private LinearRing parsePolygonHole(StreamTokenizer stream) throws IOException, ParseException {
        this.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons, alts);
        this.closeLinearRingIfCoerced(lats, lons, alts);
        if (alts.isEmpty()) {
            return new LinearRing(this.toArray(lats), this.toArray(lons));
        }
        return new LinearRing(this.toArray(lats), this.toArray(lons), this.toArray(alts));
    }

    private Polygon parsePolygon(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Polygon.EMPTY;
        }
        this.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons, alts);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            holes.add(this.parsePolygonHole(stream));
        }
        this.closeLinearRingIfCoerced(lats, lons, alts);
        LinearRing shell = alts.isEmpty() ? new LinearRing(this.toArray(lats), this.toArray(lons)) : new LinearRing(this.toArray(lats), this.toArray(lons), this.toArray(alts));
        if (holes.isEmpty()) {
            return new Polygon(shell);
        }
        return new Polygon(shell, Collections.unmodifiableList(holes));
    }

    private void closeLinearRingIfCoerced(ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) {
        if (this.coerce && !lats.isEmpty() && !lons.isEmpty()) {
            int last = lats.size() - 1;
            if (!lats.get(0).equals(lats.get(last)) || !lons.get(0).equals(lons.get(last)) || !alts.isEmpty() && !alts.get(0).equals(alts.get(last))) {
                lons.add(lons.get(0));
                lats.add(lats.get(0));
                if (!alts.isEmpty()) {
                    alts.add(alts.get(0));
                }
            }
        }
    }

    private MultiPolygon parseMultiPolygon(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiPolygon.EMPTY;
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        polygons.add(this.parsePolygon(stream));
        while (this.nextCloserOrComma(stream).equals(COMMA)) {
            polygons.add(this.parsePolygon(stream));
        }
        return new MultiPolygon(Collections.unmodifiableList(polygons));
    }

    private Rectangle parseBBox(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Rectangle.EMPTY;
        }
        double minLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLat = this.nextNumber(stream);
        this.nextComma(stream);
        double minLat = this.nextNumber(stream);
        this.nextCloser(stream);
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    private Circle parseCircle(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Circle.EMPTY;
        }
        double lon = this.nextNumber(stream);
        double lat = this.nextNumber(stream);
        double radius = this.nextNumber(stream);
        double alt = Double.NaN;
        if (this.isNumberNext(stream)) {
            alt = this.nextNumber(stream);
        }
        Circle circle = new Circle(lat, lon, alt, radius);
        this.nextCloser(stream);
        return circle;
    }

    private String nextWord(StreamTokenizer stream) throws ParseException, IOException {
        switch (stream.nextToken()) {
            case -3: {
                String word = stream.sval;
                return word.equalsIgnoreCase(EMPTY) ? EMPTY : word;
            }
            case 40: {
                return LPAREN;
            }
            case 41: {
                return RPAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw new ParseException("expected word but found: " + this.tokenString(stream), stream.lineno());
    }

    private double nextNumber(StreamTokenizer stream) throws IOException, ParseException {
        if (stream.nextToken() == -3) {
            if (stream.sval.equalsIgnoreCase(NAN)) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(stream.sval);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid number found: " + stream.sval, stream.lineno());
            }
        }
        throw new ParseException("expected number but found: " + this.tokenString(stream), stream.lineno());
    }

    private String tokenString(StreamTokenizer stream) {
        switch (stream.ttype) {
            case -3: {
                return stream.sval;
            }
            case -1: {
                return "END-OF-STREAM";
            }
            case 10: {
                return "END-OF-LINE";
            }
            case -2: {
                return "<NUMBER>";
            }
        }
        return "'" + (char)stream.ttype + "'";
    }

    private boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ParseException {
        String next = this.nextWord(stream);
        if (next.equals(EMPTY) || next.equals(LPAREN)) {
            return next;
        }
        throw new ParseException("expected EMPTY or ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextCloser(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(RPAREN)) {
            return RPAREN;
        }
        throw new ParseException("expected ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextComma(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(COMMA)) {
            return COMMA;
        }
        throw new ParseException("expected , but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextOpener(StreamTokenizer stream) throws IOException, ParseException {
        if (this.nextWord(stream).equals(LPAREN)) {
            return LPAREN;
        }
        throw new ParseException("expected ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private String nextCloserOrComma(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextWord(stream);
        if (token.equals(COMMA) || token.equals(RPAREN)) {
            return token;
        }
        throw new ParseException("expected , or ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private static String getWKTName(Geometry geometry) {
        return geometry.visit(new GeometryVisitor<String, RuntimeException>(){

            @Override
            public String visit(Circle circle) {
                return "circle";
            }

            @Override
            public String visit(GeometryCollection<?> collection) {
                return "geometrycollection";
            }

            @Override
            public String visit(Line line) {
                return "linestring";
            }

            @Override
            public String visit(LinearRing ring) {
                throw new UnsupportedOperationException("line ring cannot be serialized using WKT");
            }

            @Override
            public String visit(MultiLine multiLine) {
                return "multilinestring";
            }

            @Override
            public String visit(MultiPoint multiPoint) {
                return "multipoint";
            }

            @Override
            public String visit(MultiPolygon multiPolygon) {
                return "multipolygon";
            }

            @Override
            public String visit(Point point) {
                return "point";
            }

            @Override
            public String visit(Polygon polygon) {
                return "polygon";
            }

            @Override
            public String visit(Rectangle rectangle) {
                return "bbox";
            }
        });
    }

    private double[] toArray(ArrayList<Double> doubles) {
        return doubles.stream().mapToDouble(i -> i).toArray();
    }
}

