/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD00;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD00;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketConnectionD00
extends AbstractConnection
implements WebSocketConnection,
WebSocket.FrameConnection {
    private static final Logger LOG = Log.getLogger(WebSocketConnectionD00.class);
    public static final byte LENGTH_FRAME = -128;
    public static final byte SENTINEL_FRAME = 0;
    private final WebSocketParser _parser;
    private final WebSocketGenerator _generator;
    private final WebSocket _websocket;
    private final String _protocol;
    private String _key1;
    private String _key2;
    private ByteArrayBuffer _hixieBytes;

    public WebSocketConnectionD00(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol) throws IOException {
        super(endpoint, timestamp);
        this._endp.setMaxIdleTime(maxIdleTime);
        this._websocket = websocket;
        this._protocol = protocol;
        this._generator = new WebSocketGeneratorD00(buffers, this._endp);
        this._parser = new WebSocketParserD00(buffers, endpoint, new FrameHandlerD00(this._websocket));
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this;
    }

    public void setHixieKeys(String key1, String key2) {
        this._key1 = key1;
        this._key2 = key2;
        this._hixieBytes = new IndirectNIOBuffer(16);
    }

    public Connection handle() throws IOException {
        try {
            if (this._hixieBytes != null) {
                Buffer buffer = this._parser.getBuffer();
                if (buffer != null && buffer.length() > 0) {
                    int l = buffer.length();
                    if (l > 8 - this._hixieBytes.length()) {
                        l = 8 - this._hixieBytes.length();
                    }
                    this._hixieBytes.put(buffer.peek(buffer.getIndex(), l));
                    buffer.skip(l);
                }
                while (this._endp.isOpen()) {
                    if (this._hixieBytes.length() == 8) {
                        this.doTheHixieHixieShake();
                        this._endp.flush((Buffer)this._hixieBytes);
                        this._hixieBytes = null;
                        this._endp.flush();
                        break;
                    }
                    int filled = this._endp.fill((Buffer)this._hixieBytes);
                    if (filled < 0) {
                        this._endp.flush();
                        this._endp.close();
                        break;
                    }
                    if (filled != 0) continue;
                    WebSocketConnectionD00 webSocketConnectionD00 = this;
                    return webSocketConnectionD00;
                }
                if (this._websocket instanceof WebSocket.OnFrame) {
                    ((WebSocket.OnFrame)this._websocket).onHandshake(this);
                }
                this._websocket.onOpen(this);
                WebSocketConnectionD00 filled = this;
                return filled;
            }
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                progress = flushed > 0 || filled > 0;
                this._endp.flush();
                if (!(this._endp instanceof AsyncEndPoint) || !((AsyncEndPoint)this._endp).hasProgressed()) continue;
                progress = true;
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            try {
                if (this._endp.isOpen()) {
                    this._endp.close();
                }
            }
            catch (IOException e2) {
                LOG.ignore((Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                if (this._endp.isInputShutdown() && this._generator.isBufferEmpty()) {
                    this._endp.close();
                } else {
                    this.checkWriteable();
                }
                this.checkWriteable();
            }
        }
        return this;
    }

    public void onInputShutdown() throws IOException {
    }

    private void doTheHixieHixieShake() {
        byte[] result = WebSocketConnectionD00.doTheHixieHixieShake(WebSocketConnectionD00.hixieCrypt(this._key1), WebSocketConnectionD00.hixieCrypt(this._key2), this._hixieBytes.asArray());
        this._hixieBytes.clear();
        this._hixieBytes.put(result);
    }

    @Override
    public boolean isOpen() {
        return this._endp != null && this._endp.isOpen();
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public boolean isSuspended() {
        return false;
    }

    public void onClose() {
        this._websocket.onClose(1000, "");
    }

    @Override
    public void sendMessage(String content) throws IOException {
        byte[] data = content.getBytes("UTF-8");
        this._generator.addFrame((byte)0, (byte)0, data, 0, data.length);
        this._generator.flush();
        this.checkWriteable();
    }

    @Override
    public void sendMessage(byte[] data, int offset, int length) throws IOException {
        this._generator.addFrame((byte)0, (byte)-128, data, offset, length);
        this._generator.flush();
        this.checkWriteable();
    }

    public boolean isMore(byte flags) {
        return (flags & 8) != 0;
    }

    @Override
    public void sendControl(byte code, byte[] content, int offset, int length) throws IOException {
    }

    @Override
    public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._generator.addFrame((byte)0, opcode, content, offset, length);
        this._generator.flush();
        this.checkWriteable();
    }

    @Override
    public void close(int code, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.close();
    }

    @Override
    public void close() {
        try {
            this._generator.flush();
            this._endp.close();
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    static long hixieCrypt(String key) {
        long number = 0L;
        int spaces = 0;
        for (char c : key.toCharArray()) {
            if (Character.isDigit(c)) {
                number = number * 10L + (long)(c - 48);
                continue;
            }
            if (c != ' ') continue;
            ++spaces;
        }
        return number / (long)spaces;
    }

    public static byte[] doTheHixieHixieShake(long key1, long key2, byte[] key3) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] fodder = new byte[16];
            fodder[0] = (byte)(0xFFL & key1 >> 24);
            fodder[1] = (byte)(0xFFL & key1 >> 16);
            fodder[2] = (byte)(0xFFL & key1 >> 8);
            fodder[3] = (byte)(0xFFL & key1);
            fodder[4] = (byte)(0xFFL & key2 >> 24);
            fodder[5] = (byte)(0xFFL & key2 >> 16);
            fodder[6] = (byte)(0xFFL & key2 >> 8);
            fodder[7] = (byte)(0xFFL & key2);
            System.arraycopy(key3, 0, fodder, 8, 8);
            md.update(fodder);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setMaxTextMessageSize(int size) {
    }

    @Override
    public void setMaxIdleTime(int ms) {
        try {
            this._endp.setMaxIdleTime(ms);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Override
    public void setMaxBinaryMessageSize(int size) {
    }

    @Override
    public int getMaxTextMessageSize() {
        return -1;
    }

    @Override
    public int getMaxIdleTime() {
        return this._endp.getMaxIdleTime();
    }

    @Override
    public int getMaxBinaryMessageSize() {
        return -1;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    protected void onFrameHandshake() {
        if (this._websocket instanceof WebSocket.OnFrame) {
            ((WebSocket.OnFrame)this._websocket).onHandshake(this);
        }
    }

    protected void onWebsocketOpen() {
        this._websocket.onOpen(this);
    }

    @Override
    public boolean isMessageComplete(byte flags) {
        return true;
    }

    @Override
    public byte binaryOpcode() {
        return -128;
    }

    @Override
    public byte textOpcode() {
        return 0;
    }

    @Override
    public boolean isControl(byte opcode) {
        return false;
    }

    @Override
    public boolean isText(byte opcode) {
        return (opcode & 0xFFFFFF80) == 0;
    }

    @Override
    public boolean isBinary(byte opcode) {
        return (opcode & 0xFFFFFF80) != 0;
    }

    @Override
    public boolean isContinuation(byte opcode) {
        return false;
    }

    @Override
    public boolean isClose(byte opcode) {
        return false;
    }

    @Override
    public boolean isPing(byte opcode) {
        return false;
    }

    @Override
    public boolean isPong(byte opcode) {
        return false;
    }

    @Override
    public List<Extension> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    public byte continuationOpcode() {
        return 0;
    }

    @Override
    public byte finMask() {
        return 0;
    }

    @Override
    public void setAllowFrameFragmentation(boolean allowFragmentation) {
    }

    @Override
    public boolean isAllowFrameFragmentation() {
        return false;
    }

    static class FrameHandlerD00
    implements WebSocketParser.FrameHandler {
        final WebSocket _websocket;

        FrameHandlerD00(WebSocket websocket) {
            this._websocket = websocket;
        }

        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            try {
                byte[] array = buffer.array();
                if (opcode == 0) {
                    if (this._websocket instanceof WebSocket.OnTextMessage) {
                        ((WebSocket.OnTextMessage)this._websocket).onMessage(buffer.toString("UTF-8"));
                    }
                } else if (this._websocket instanceof WebSocket.OnBinaryMessage) {
                    ((WebSocket.OnBinaryMessage)this._websocket).onMessage(array, buffer.getIndex(), buffer.length());
                }
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
        }

        public void close(int code, String message) {
        }
    }
}

