/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.SpinLock;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final SpinLock _lock = new SpinLock();
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private Async _async;
    private boolean _initial;
    private boolean _asyncReadPossible;
    private boolean _asyncReadUnready;
    private boolean _asyncWrite;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._async = null;
        this._initial = true;
    }

    public State getState() {
        try (SpinLock.Lock lock = this._lock.lock();){
            State state = this._state;
            return state;
        }
    }

    public void addListener(AsyncListener listener) {
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    public void setTimeout(long ms) {
        try (SpinLock.Lock lock = this._lock.lock();){
            this._timeoutMs = ms;
        }
    }

    public long getTimeout() {
        try (SpinLock.Lock lock = this._lock.lock();){
            long l = this._timeoutMs;
            return l;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (SpinLock.Lock lock = this._lock.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (SpinLock.Lock lock = this._lock.lock();){
            Object[] objectArray = new Object[7];
            objectArray[0] = this.getClass().getSimpleName();
            objectArray[1] = this.hashCode();
            objectArray[2] = this._state;
            objectArray[3] = this._async;
            objectArray[4] = this._initial;
            objectArray[5] = this._asyncReadPossible ? (this._asyncReadUnready ? "PU" : "P!U") : (this._asyncReadUnready ? "!PU" : "!P!U");
            objectArray[6] = this._asyncWrite;
            String string = String.format("%s@%x{s=%s a=%s i=%b r=%s w=%b}", objectArray);
            return string;
        }
    }

    public String getStatusString() {
        try (SpinLock.Lock lock = this._lock.lock();){
            String string = String.format("s=%s i=%b a=%s", new Object[]{this._state, this._initial, this._async});
            return string;
        }
    }

    protected Action handling() {
        if (this.DEBUG) {
            LOG.debug("{} handling {}", new Object[]{this, this._state});
        }
        try (SpinLock.Lock lock = this._lock.lock();){
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    Action action = Action.REQUEST_DISPATCH;
                    return action;
                }
                case COMPLETING: {
                    Action action = Action.COMPLETE;
                    return action;
                }
                case COMPLETED: {
                    Action action = Action.WAIT;
                    return action;
                }
                case ASYNC_WOKEN: {
                    if (this._asyncReadPossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncReadUnready = false;
                        Action action = Action.READ_CALLBACK;
                        return action;
                    }
                    if (this._asyncWrite) {
                        this._state = State.ASYNC_IO;
                        this._asyncWrite = false;
                        Action action = Action.WRITE_CALLBACK;
                        return action;
                    }
                    if (this._async != null) {
                        Async async = this._async;
                        switch (async) {
                            case COMPLETE: {
                                this._state = State.COMPLETING;
                                Action x2 = Action.COMPLETE;
                                return x2;
                            }
                            case DISPATCH: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action x2 = Action.ASYNC_DISPATCH;
                                return x2;
                            }
                            case EXPIRING: {
                                break;
                            }
                            case EXPIRED: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action x2 = Action.ASYNC_EXPIRED;
                                return x2;
                            }
                            case STARTED: {
                                Action x2 = Action.WAIT;
                                return x2;
                            }
                        }
                    }
                    Action action = Action.WAIT;
                    return action;
                }
            }
            Action action = Action.WAIT;
            return action;
        }
    }

    public void startAsync(AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._state != State.DISPATCHED || this._async != null) {
                throw new IllegalStateException(this.getStatusString());
            }
            this._async = Async.STARTED;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            for (AsyncListener listener : lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    protected void error(Throwable th) {
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._event != null) {
                this._event.setThrowable(th);
            }
        }
    }

    protected Action unhandle() {
        Action action;
        AsyncContextEvent schedule_event = null;
        boolean read_interested = false;
        if (this.DEBUG) {
            LOG.debug("{} unhandle {}", new Object[]{this, this._state});
        }
        try (SpinLock.Lock lock = this._lock.lock();){
            switch (this._state) {
                case DISPATCHED: 
                case ASYNC_IO: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            if (this._async != null) {
                this._initial = false;
                switch (this._async) {
                    case COMPLETE: {
                        this._state = State.COMPLETING;
                        this._async = null;
                        action = Action.COMPLETE;
                        break;
                    }
                    case DISPATCH: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ASYNC_DISPATCH;
                        break;
                    }
                    case EXPIRED: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ASYNC_EXPIRED;
                        break;
                    }
                    case STARTED: {
                        if (this._asyncReadUnready && this._asyncReadPossible) {
                            this._state = State.ASYNC_IO;
                            this._asyncReadUnready = false;
                            action = Action.READ_CALLBACK;
                            break;
                        }
                        if (this._asyncWrite) {
                            this._asyncWrite = false;
                            this._state = State.ASYNC_IO;
                            action = Action.WRITE_CALLBACK;
                            break;
                        }
                        schedule_event = this._event;
                        read_interested = this._asyncReadUnready;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    case EXPIRING: {
                        schedule_event = this._event;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    default: {
                        this._state = State.COMPLETING;
                        action = Action.COMPLETE;
                        break;
                    }
                }
            } else {
                this._state = State.COMPLETING;
                action = Action.COMPLETE;
            }
        }
        if (schedule_event != null) {
            this.scheduleTimeout(schedule_event);
        }
        if (read_interested) {
            this._channel.asyncReadFillInterested();
        }
        return action;
    }

    /*
     * Unable to fully structure code
     */
    public void dispatch(ServletContext context, String path) {
        lock = this._lock.lock();
        var5_4 = null;
        try {
            if (this._async != Async.STARTED && this._async != Async.EXPIRING) {
                throw new IllegalStateException("AsyncContext#dispath " + this.getStatusString());
            }
            this._async = Async.DISPATCH;
            if (context != null) {
                this._event.setDispatchContext(context);
            }
            if (path != null) {
                this._event.setDispatchPath(path);
            }
            switch (1.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 5: 
                case 6: {
                    dispatch = false;
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 7: {
                    this._state = State.ASYNC_WOKEN;
                    dispatch = true;
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    dispatch = false;
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                default: {
                    HttpChannelState.LOG.warn("async dispatched when complete {}", new Object[]{this});
                    dispatch = false;
                    break;
                }
            }
        }
        catch (Throwable var6_7) {
            var5_4 = var6_7;
            throw var6_7;
        }
        finally {
            if (lock != null) {
                if (var5_4 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable x2) {
                        var5_4.addSuppressed(x2);
                    }
                } else {
                    lock.close();
                }
            }
        }
        this.cancelTimeout();
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    protected void expired() {
        List<AsyncListener> aListeners;
        AsyncContextEvent event;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._async != Async.STARTED) {
                return;
            }
            this._async = Async.EXPIRING;
            event = this._event;
            aListeners = this._asyncListeners;
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onTimeout((AsyncEvent)event);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                    event.setThrowable(e);
                    this._channel.getRequest().setAttribute("javax.servlet.error.exception", e);
                    break;
                }
            }
        }
        boolean dispatch = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._async == Async.EXPIRING) {
                this._async = Async.EXPIRED;
                if (this._state == State.ASYNC_WAIT) {
                    this._state = State.ASYNC_WOKEN;
                    dispatch = true;
                }
            }
        }
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    public void complete() {
        boolean handle = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._async != Async.STARTED && this._async != Async.EXPIRING) {
                throw new IllegalStateException(this.getStatusString());
            }
            this._async = Async.COMPLETE;
            if (this._state == State.ASYNC_WAIT) {
                handle = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        this.cancelTimeout();
        if (handle) {
            ContextHandler handler = this.getContextHandler();
            if (handler != null) {
                handler.handle(this._channel);
            } else {
                this._channel.handle();
            }
        }
    }

    public void errorComplete() {
        try (SpinLock.Lock lock = this._lock.lock();){
            this._async = Async.COMPLETE;
            this._event.setDispatchContext(null);
            this._event.setDispatchPath(null);
        }
        this.cancelTimeout();
    }

    /*
     * Unable to fully structure code
     */
    protected void completed() {
        lock = this._lock.lock();
        var4_2 = null;
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 2: {
                    this._state = State.COMPLETED;
                    aListeners = this._asyncListeners;
                    event = this._event;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        catch (Throwable x2) {
            var4_2 = x2;
            throw x2;
        }
        finally {
            if (lock != null) {
                if (var4_2 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    lock.close();
                }
            }
        }
        if (event != null) {
            if (aListeners != null) {
                if (event.getThrowable() != null) {
                    event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)event.getThrowable());
                    event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)event.getThrowable().getMessage());
                }
                for (AsyncListener listener : aListeners) {
                    try {
                        if (event.getThrowable() != null) {
                            listener.onError((AsyncEvent)event);
                            continue;
                        }
                        listener.onComplete((AsyncEvent)event);
                    }
                    catch (Exception e) {
                        HttpChannelState.LOG.warn((Throwable)e);
                    }
                }
            }
            event.completed();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (SpinLock.Lock lock = this._lock.lock();){
            switch (this._state) {
                case DISPATCHED: 
                case ASYNC_IO: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case UPGRADED: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (SpinLock.Lock lock = this._lock.lock();){
            switch (this._state) {
                case IDLE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout(AsyncContextEvent event) {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            event.setTimeoutTask(scheduler.schedule((Runnable)event, this._timeoutMs, TimeUnit.MILLISECONDS));
        }
    }

    protected void cancelTimeout() {
        AsyncContextEvent event;
        try (SpinLock.Lock lock = this._lock.lock();){
            event = this._event;
        }
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._async == Async.EXPIRED;
            return bl;
        }
    }

    public boolean isInitial() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._state == State.ASYNC_WAIT || this._state == State.DISPATCHED && this._async == Async.STARTED;
            return bl;
        }
    }

    boolean isCompleting() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._state == State.COMPLETING;
            return bl;
        }
    }

    boolean isCompleted() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._state == State.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (SpinLock.Lock lock = this._lock.lock();){
            if (this._state == State.DISPATCHED) {
                boolean bl = this._async != null;
                return bl;
            }
            boolean bl = this._async == Async.STARTED || this._async == Async.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = !this._initial || this._async != null;
            return bl;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        ContextHandler.Context context;
        AsyncContextEvent event;
        try (SpinLock.Lock lock = this._lock.lock();){
            event = this._event;
        }
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        AsyncContextEvent event;
        try (SpinLock.Lock lock = this._lock.lock();){
            event = this._event;
        }
        if (event != null && event.getSuppliedResponse() != null) {
            return event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public void onReadUnready() {
        boolean interested = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            if (!this._asyncReadUnready) {
                this._asyncReadUnready = true;
                this._asyncReadPossible = false;
                if (this._state == State.ASYNC_WAIT) {
                    interested = true;
                }
            }
        }
        if (interested) {
            this._channel.asyncReadFillInterested();
        }
    }

    public boolean onReadPossible() {
        boolean woken = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT && this._asyncReadUnready) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean onReadReady() {
        boolean woken = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            this._asyncReadUnready = true;
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT) {
                woken = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return woken;
    }

    public boolean isReadPossible() {
        try (SpinLock.Lock lock = this._lock.lock();){
            boolean bl = this._asyncReadPossible;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean handle = false;
        try (SpinLock.Lock lock = this._lock.lock();){
            this._asyncWrite = true;
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                handle = true;
            }
        }
        return handle;
    }

    public static enum Async {
        STARTED,
        DISPATCH,
        COMPLETE,
        EXPIRING,
        EXPIRED;

    }

    public static enum Action {
        REQUEST_DISPATCH,
        ASYNC_DISPATCH,
        ASYNC_EXPIRED,
        WRITE_CALLBACK,
        READ_CALLBACK,
        WAIT,
        COMPLETE;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNC_WAIT,
        ASYNC_WOKEN,
        ASYNC_IO,
        COMPLETING,
        COMPLETED,
        UPGRADED;

    }
}

