/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension;

import java.lang.reflect.Method;
import org.easymock.classextension.IMocksControl;
import org.easymock.classextension.internal.ClassExtensionHelper;
import org.easymock.classextension.internal.MocksClassControl;
import org.easymock.internal.MocksControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMock
extends org.easymock.EasyMock {
    public static <T> T createStrictMock(Class<T> toMock) {
        return (T)EasyMock.createStrictControl().createMock(toMock);
    }

    public static <T> T createStrictMock(Class<T> toMock, Method[] mockedMethods) {
        return EasyMock.createStrictControl().createMock(toMock, mockedMethods);
    }

    public static <T> T createMock(Class<T> toMock) {
        return (T)EasyMock.createControl().createMock(toMock);
    }

    public static <T> T createMock(Class<T> toMock, Method[] mockedMethods) {
        return EasyMock.createControl().createMock(toMock, mockedMethods);
    }

    public static <T> T createNiceMock(Class<T> toMock) {
        return (T)EasyMock.createNiceControl().createMock(toMock);
    }

    public static <T> T createNiceMock(Class<T> toMock, Method[] mockedMethods) {
        return EasyMock.createNiceControl().createMock(toMock, mockedMethods);
    }

    public static IMocksControl createStrictControl() {
        return new MocksClassControl(MocksControl.MockType.STRICT);
    }

    public static IMocksControl createControl() {
        return new MocksClassControl(MocksControl.MockType.DEFAULT);
    }

    public static IMocksControl createNiceControl() {
        return new MocksClassControl(MocksControl.MockType.NICE);
    }

    public static void replay(Object ... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).replay();
        }
    }

    public static void reset(Object ... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).reset();
        }
    }

    public static void verify(Object ... mocks) {
        for (Object mock : mocks) {
            ClassExtensionHelper.getControl(mock).verify();
        }
    }

    public static void checkOrder(Object mock, boolean value) {
        ClassExtensionHelper.getControl(mock).checkOrder(value);
    }
}

