/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.Invocation;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.And;
import org.easymock.internal.matchers.Not;
import org.easymock.internal.matchers.Or;

public final class LastControl {
    private static final String NO_MATCHERS_FOUND = "no matchers found.";
    private static final ThreadLocal<MocksControl> threadToControl = new ThreadLocal();
    private static final ThreadLocal<List<Invocation>> threadToCurrentInvocation = new ThreadLocal();
    private static final ThreadLocal<List<IArgumentMatcher>> threadToArgumentMatcherStack = new ThreadLocal();

    private LastControl() {
    }

    public static void reportLastControl(MocksControl control) {
        if (control != null) {
            threadToControl.set(control);
        } else {
            threadToControl.remove();
        }
    }

    public static MocksControl lastControl() {
        return threadToControl.get();
    }

    public static void reportMatcher(IArgumentMatcher matcher) {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        if (stack == null) {
            stack = new ArrayList<IArgumentMatcher>(5);
            threadToArgumentMatcherStack.set(stack);
        }
        stack.add(matcher);
    }

    public static List<IArgumentMatcher> pullMatchers() {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        if (stack == null) {
            return null;
        }
        threadToArgumentMatcherStack.remove();
        return new ArrayList<IArgumentMatcher>(stack);
    }

    public static void reportAnd(int count) {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, NO_MATCHERS_FOUND);
        stack.add(new And(LastControl.popLastArgumentMatchers(count)));
    }

    public static void reportNot() {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, NO_MATCHERS_FOUND);
        stack.add(new Not(LastControl.popLastArgumentMatchers(1).get(0)));
    }

    private static List<IArgumentMatcher> popLastArgumentMatchers(int count) {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, NO_MATCHERS_FOUND);
        LastControl.assertState(stack.size() >= count, "" + count + " matchers expected, " + stack.size() + " recorded.");
        LinkedList<IArgumentMatcher> result = new LinkedList<IArgumentMatcher>();
        result.addAll(stack.subList(stack.size() - count, stack.size()));
        for (int i = 0; i < count; ++i) {
            stack.remove(stack.size() - 1);
        }
        return result;
    }

    private static void assertState(boolean toAssert, String message) {
        if (!toAssert) {
            threadToArgumentMatcherStack.remove();
            throw new IllegalStateException(message);
        }
    }

    public static void reportOr(int count) {
        List<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, NO_MATCHERS_FOUND);
        stack.add(new Or(LastControl.popLastArgumentMatchers(count)));
    }

    public static Invocation getCurrentInvocation() {
        List<Invocation> stack = threadToCurrentInvocation.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    public static void pushCurrentInvocation(Invocation invocation) {
        List<Invocation> stack = threadToCurrentInvocation.get();
        if (stack == null) {
            stack = new ArrayList<Invocation>(2);
            threadToCurrentInvocation.set(stack);
        }
        stack.add(invocation);
    }

    public static void popCurrentInvocation() {
        List<Invocation> stack = threadToCurrentInvocation.get();
        stack.remove(stack.size() - 1);
    }
}

