/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.MockType;
import org.easymock.cglib.proxy.Enhancer;
import org.easymock.cglib.proxy.Factory;
import org.easymock.internal.ClassProxyFactory;
import org.easymock.internal.Injector;
import org.easymock.internal.MockBuilder;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.ReflectionUtils;

public class EasyMockSupport {
    protected final List<IMocksControl> controls = new ArrayList<IMocksControl>(5);

    public <T> T mock(Class<T> toMock) {
        return this.createControl().createMock(toMock);
    }

    public <T> T mock(String name, Class<T> toMock) {
        return this.createControl().createMock(name, toMock);
    }

    public <T> T mock(MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(toMock);
    }

    public <T> T mock(String name, MockType type, Class<T> toMock) {
        return this.createControl(type).createMock(name, toMock);
    }

    public <T> T strictMock(Class<T> toMock) {
        return this.createStrictControl().createMock(toMock);
    }

    public <T> T strictMock(String name, Class<T> toMock) {
        return this.createStrictControl().createMock(name, toMock);
    }

    public <T> T niceMock(Class<T> toMock) {
        return this.createNiceControl().createMock(toMock);
    }

    public <T> T niceMock(String name, Class<T> toMock) {
        return this.createNiceControl().createMock(name, toMock);
    }

    public <T> IMockBuilder<T> partialMockBuilder(Class<T> toMock) {
        return new MockBuilder<T>(toMock, this);
    }

    public <T> T createMock(MockType type, Class<T> toMock) {
        return this.mock(type, toMock);
    }

    public <T> T createMock(String name, MockType type, Class<T> toMock) {
        return this.mock(name, type, toMock);
    }

    public <T> T createStrictMock(Class<T> toMock) {
        return this.strictMock(toMock);
    }

    public <T> T createStrictMock(String name, Class<T> toMock) {
        return this.strictMock(name, toMock);
    }

    public <T> T createMock(Class<T> toMock) {
        return this.mock(toMock);
    }

    public <T> T createMock(String name, Class<T> toMock) {
        return this.mock(name, toMock);
    }

    public <T> T createNiceMock(Class<T> toMock) {
        return this.niceMock(toMock);
    }

    public <T> T createNiceMock(String name, Class<T> toMock) {
        return this.niceMock(name, toMock);
    }

    public IMocksControl createStrictControl() {
        IMocksControl ctrl = EasyMock.createStrictControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public <T> IMockBuilder<T> createMockBuilder(Class<T> toMock) {
        return this.partialMockBuilder(toMock);
    }

    public IMocksControl createControl(MockType type) {
        IMocksControl ctrl = EasyMock.createControl(type);
        this.controls.add(ctrl);
        return ctrl;
    }

    public IMocksControl createControl() {
        return this.createControl(MockType.DEFAULT);
    }

    public IMocksControl createNiceControl() {
        IMocksControl ctrl = EasyMock.createNiceControl();
        this.controls.add(ctrl);
        return ctrl;
    }

    public void replayAll() {
        for (IMocksControl c : this.controls) {
            c.replay();
        }
    }

    public void resetAll() {
        for (IMocksControl c : this.controls) {
            c.reset();
        }
    }

    public void verifyAll() {
        for (IMocksControl c : this.controls) {
            c.verify();
        }
    }

    public void verifyAllRecordings() {
        for (IMocksControl c : this.controls) {
            c.verifyRecording();
        }
    }

    public void verifyAllUnexpectedCalls() {
        for (IMocksControl c : this.controls) {
            c.verifyUnexpectedCalls();
        }
    }

    public void resetAllToNice() {
        for (IMocksControl c : this.controls) {
            c.resetToNice();
        }
    }

    public void resetAllToDefault() {
        for (IMocksControl c : this.controls) {
            c.resetToDefault();
        }
    }

    public void resetAllToStrict() {
        for (IMocksControl c : this.controls) {
            c.resetToStrict();
        }
    }

    public static void injectMocks(Object obj) {
        Injector.injectMocks(obj);
    }

    public static <T, R extends T> Class<R> getMockedClass(T possibleMock) {
        if (possibleMock == null) {
            return null;
        }
        if (Proxy.isProxyClass(possibleMock.getClass())) {
            if (!(Proxy.getInvocationHandler(possibleMock) instanceof ObjectMethodsFilter)) {
                return null;
            }
        } else if (ReflectionUtils.isClassAvailable("org.easymock.cglib.proxy.Enhancer")) {
            if (!ObjectMockingHelper.isAClassMock(possibleMock)) {
                return null;
            }
        } else {
            return null;
        }
        return MocksControl.getMockedClass(possibleMock);
    }

    private static class ObjectMockingHelper {
        private ObjectMockingHelper() {
        }

        public static boolean isAClassMock(Object possibleMock) {
            if (!Enhancer.isEnhanced(possibleMock.getClass())) {
                return false;
            }
            if (!(possibleMock instanceof Factory)) {
                return false;
            }
            return ((Factory)possibleMock).getCallback(0) instanceof ClassProxyFactory.MockMethodInterceptor;
        }
    }
}

