/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;

public class ReactiveFromNodeLeftTuple
extends FromNodeLeftTuple {
    private Map<Object, ReactiveObjectUtil.ModificationType> modificationTypeMap = new HashMap<Object, ReactiveObjectUtil.ModificationType>();
    private Object[] objects;
    private int hash;
    private int peerIndex;

    public ReactiveFromNodeLeftTuple() {
    }

    public ReactiveFromNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        this.objects = new Object[leftTuple.getIndex() + 2];
        System.arraycopy(leftTuple.toObjects(), 0, this.objects, 0, leftTuple.getIndex() + 1);
        this.objects[leftTuple.getIndex() + 1] = rightTuple.getFactHandle().getObject();
        this.hash = Arrays.hashCode(this.objects);
    }

    public ReactiveFromNodeLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
        this.objects = new Object[leftTuple.getIndex() + 2];
        System.arraycopy(leftTuple.toObjects(), 0, this.objects, 0, leftTuple.getIndex() + 1);
        this.objects[leftTuple.getIndex() + 1] = factHandle.getObject();
        this.hash = Arrays.hashCode(this.objects);
    }

    public ReactiveFromNodeLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
        this.objects = new Object[]{factHandle.getObject()};
        this.hash = Arrays.hashCode(this.objects);
    }

    @Override
    public void initPeer(BaseLeftTuple original, LeftTupleSink sink) {
        super.initPeer(original, sink);
        ReactiveFromNodeLeftTuple reactiveTuple = (ReactiveFromNodeLeftTuple)original;
        this.objects = reactiveTuple.objects;
        this.peerIndex = reactiveTuple.peerIndex + 1;
        this.hash = Arrays.hashCode(this.objects) + this.peerIndex;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReactiveFromNodeLeftTuple && Arrays.equals(this.objects, ((ReactiveFromNodeLeftTuple)other).objects) && this.peerIndex == ((ReactiveFromNodeLeftTuple)other).peerIndex;
    }

    public boolean updateModificationState(Object object, ReactiveObjectUtil.ModificationType newState) {
        ReactiveObjectUtil.ModificationType modificationType = this.modificationTypeMap.computeIfAbsent(object, k -> ReactiveObjectUtil.ModificationType.NONE);
        switch (modificationType) {
            case NONE: {
                modificationType = newState;
                this.modificationTypeMap.put(object, modificationType);
                return true;
            }
            case ADD: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                modificationType = ReactiveObjectUtil.ModificationType.NONE;
                break;
            }
            case MODIFY: {
                if (newState != ReactiveObjectUtil.ModificationType.REMOVE) break;
                modificationType = ReactiveObjectUtil.ModificationType.REMOVE;
            }
        }
        this.modificationTypeMap.put(object, modificationType);
        return false;
    }

    public ReactiveObjectUtil.ModificationType resetModificationState(Object object) {
        return this.modificationTypeMap.remove(object);
    }
}

