/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class SumAccumulateFunction
extends AbstractAccumulateFunction<SumData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public SumData createContext() {
        return new SumData();
    }

    public void init(SumData data) {
        data.total = 0.0;
    }

    public void accumulate(SumData data, Object value) {
        data.total += ((Number)value).doubleValue();
    }

    public void reverse(SumData data, Object value) {
        data.total -= ((Number)value).doubleValue();
    }

    public Object getResult(SumData data) {
        return data.total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Double.class;
    }

    protected static class SumData
    implements Externalizable {
        public double total = 0.0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.total);
        }
    }
}

