/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SessionClock;
import org.drools.time.TimerService;
import org.drools.time.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKTimerService
implements TimerService,
SessionClock {
    protected ScheduledThreadPoolExecutor scheduler;

    public JDKTimerService() {
        this(1);
    }

    public JDKTimerService(int size) {
        this.scheduler = new ScheduledThreadPoolExecutor(size);
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        JDKJobHandle jobHandle = new JDKJobHandle();
        Date date = trigger.nextFireTime();
        if (date != null) {
            Callable<Void> callableJob = this.createCallableJob(job, ctx, trigger, jobHandle, this.scheduler);
            ScheduledFuture future = JDKTimerService.schedule(date, callableJob, this.scheduler);
            jobHandle.setFuture(future);
            return jobHandle;
        }
        return null;
    }

    protected Callable<Void> createCallableJob(Job job, JobContext ctx, Trigger trigger, JDKJobHandle handle, ScheduledThreadPoolExecutor scheduler) {
        return new JDKCallableJob(job, ctx, trigger, handle, this.scheduler);
    }

    @Override
    public boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        return this.scheduler.remove((Runnable)((Object)((JDKJobHandle)jobHandle).getFuture()));
    }

    private static ScheduledFuture schedule(Date date, Callable<Void> callableJob, ScheduledThreadPoolExecutor scheduler) {
        long then = date.getTime();
        long now = System.currentTimeMillis();
        ScheduledFuture<Void> future = null;
        future = then >= now ? scheduler.schedule(callableJob, then - now, TimeUnit.MILLISECONDS) : scheduler.schedule(callableJob, 0L, TimeUnit.MILLISECONDS);
        return future;
    }

    @Override
    public long getTimeToNextJob() {
        return 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JDKJobHandle
    implements JobHandle {
        private static final long serialVersionUID = 510L;
        private AtomicBoolean cancel = new AtomicBoolean(false);
        private ScheduledFuture<Void> future;

        @Override
        public void setCancel(boolean cancel) {
            this.cancel.set(cancel);
        }

        @Override
        public boolean isCancel() {
            return this.cancel.get();
        }

        public ScheduledFuture<Void> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<Void> future) {
            this.future = future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JDKCallableJob
    implements Callable<Void> {
        private final Job job;
        private final Trigger trigger;
        private final JobContext ctx;
        private final ScheduledThreadPoolExecutor scheduler;
        private final JDKJobHandle handle;

        public JDKCallableJob(Job job, JobContext ctx, Trigger trigger, JDKJobHandle handle, ScheduledThreadPoolExecutor scheduler) {
            this.job = job;
            this.ctx = ctx;
            this.trigger = trigger;
            this.handle = handle;
            this.scheduler = scheduler;
        }

        @Override
        public Void call() throws Exception {
            if (this.handle.isCancel()) {
                return null;
            }
            this.job.execute(this.ctx);
            if (this.handle.isCancel()) {
                return null;
            }
            Date date = this.trigger.nextFireTime();
            if (date != null) {
                ScheduledFuture future = JDKTimerService.schedule(date, this, this.scheduler);
                this.handle.setFuture(future);
            }
            return null;
        }
    }
}

