/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.SessionConfiguration;
import org.drools.agent.KnowledgeAgent;
import org.drools.base.MapGlobalResolver;
import org.drools.command.Command;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.event.AgendaEventSupport;
import org.drools.event.ProcessEventSupport;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.runtime.Environment;
import org.drools.runtime.Globals;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.process.InternalProcessRuntime;
import org.drools.runtime.rule.AgendaFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessKnowledgeSessionImpl
implements StatelessKnowledgeSession {
    private InternalRuleBase ruleBase;
    private KnowledgeAgent kagent;
    private AgendaFilter agendaFilter;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    public Map<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper> mappedWorkingMemoryListeners;
    public Map<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper> mappedAgendaListeners;
    public AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    public WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    public ProcessEventSupport processEventSupport = new ProcessEventSupport();
    private boolean initialized;
    private KnowledgeSessionConfiguration conf;
    private Environment environment;

    public StatelessKnowledgeSessionImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatelessKnowledgeSessionImpl(InternalRuleBase ruleBase, KnowledgeAgent kagent, KnowledgeSessionConfiguration conf) {
        this.ruleBase = ruleBase;
        this.kagent = kagent;
        this.conf = conf != null ? conf : SessionConfiguration.getDefaultInstance();
        this.environment = EnvironmentFactory.newEnvironment();
        if (this.ruleBase != null) {
            this.ruleBase.lock();
            try {
                if (ruleBase.getConfiguration().isSequential()) {
                    this.ruleBase.getReteooBuilder().order();
                }
            }
            finally {
                this.ruleBase.unlock();
            }
        }
    }

    public InternalRuleBase getRuleBase() {
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        return this.ruleBase;
    }

    public KnowledgeAgent getKnowledgeAgent() {
        return this.kagent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSession newWorkingMemory() {
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        this.ruleBase.readLock();
        try {
            InternalProcessRuntime processRuntime;
            ReteooWorkingMemory wm = new ReteooWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, (SessionConfiguration)this.conf, this.environment);
            StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl(wm, new KnowledgeBaseImpl(this.ruleBase));
            ((Globals)wm.getGlobalResolver()).setDelegate((Globals)this.sessionGlobals);
            wm.setKnowledgeRuntime(ksession);
            if (!this.initialized) {
                for (EventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
                    this.agendaEventSupport.addEventListener(listener);
                }
                for (EventListener listener : wm.getWorkingMemoryEventSupport().getEventListeners()) {
                    this.workingMemoryEventSupport.addEventListener(listener);
                }
                processRuntime = wm.getProcessRuntime();
                if (processRuntime != null) {
                    for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                        this.processEventSupport.addEventListener(listener);
                    }
                }
                this.initialized = true;
            }
            wm.setAgendaEventSupport(this.agendaEventSupport);
            wm.setWorkingMemoryEventSupport(this.workingMemoryEventSupport);
            processRuntime = wm.getProcessRuntime();
            if (processRuntime != null) {
                processRuntime.setProcessEventSupport(this.processEventSupport);
            }
            InternalFactHandle handle = wm.getFactHandleFactory().newFactHandle(InitialFactImpl.getInstance(), wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, InitialFactImpl.getInstance()), wm, wm);
            wm.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(handle, false, true, null, null));
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = ksession;
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    public void addEventListener(AgendaEventListener listener) {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper wrapper = new StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper(listener);
        this.mappedAgendaListeners.put(listener, wrapper);
        this.agendaEventSupport.addEventListener(wrapper);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        return Collections.unmodifiableCollection(this.mappedAgendaListeners.keySet());
    }

    public void removeEventListener(AgendaEventListener listener) {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper wrapper = this.mappedAgendaListeners.remove(listener);
        this.agendaEventSupport.removeEventListener(wrapper);
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper wrapper = new StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper(listener);
        this.mappedWorkingMemoryListeners.put(listener, wrapper);
        this.workingMemoryEventSupport.addEventListener(wrapper);
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper wrapper = this.mappedWorkingMemoryListeners.remove(listener);
        this.workingMemoryEventSupport.removeEventListener(wrapper);
    }

    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        return Collections.unmodifiableCollection(this.mappedWorkingMemoryListeners.keySet());
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener(listener);
    }

    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        KnowledgeCommandContext context = new KnowledgeCommandContext(new ContextImpl("ksession", null), null, null, ksession, null);
        try {
            ((StatefulKnowledgeSessionImpl)ksession).session.startBatchExecution(new ExecutionResultImpl());
            Object o = ((GenericCommand)command).execute(context);
            boolean autoFireAllRules = true;
            if (command instanceof FireAllRulesCommand) {
                autoFireAllRules = false;
            } else if (command instanceof BatchExecutionCommandImpl) {
                for (GenericCommand<?> nestedCmd : ((BatchExecutionCommandImpl)command).getCommands()) {
                    if (!(nestedCmd instanceof FireAllRulesCommand)) continue;
                    autoFireAllRules = false;
                    break;
                }
            }
            if (autoFireAllRules) {
                ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommandImpl) {
                ExecutionResultImpl result;
                ExecutionResultImpl executionResultImpl = result = ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult();
                return (T)executionResultImpl;
            }
            Object t = o;
            return t;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)ksession).session.endBatchExecution();
        }
    }

    public void execute(Object object) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        ksession.insert(object);
        ksession.fireAllRules();
    }

    public void execute(Iterable objects) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        for (Object object : objects) {
            ksession.insert(object);
        }
        ksession.fireAllRules();
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

