/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMClassMethod;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.datanucleus.enhancer.asm.JdoMethodAdapter;
import org.datanucleus.enhancer.asm.JdoPropertyGetterAdapter;
import org.datanucleus.enhancer.asm.JdoPropertySetterAdapter;
import org.datanucleus.enhancer.asm.method.CheckRead;
import org.datanucleus.enhancer.asm.method.CheckWrite;
import org.datanucleus.enhancer.asm.method.DefaultConstructor;
import org.datanucleus.enhancer.asm.method.InitClass;
import org.datanucleus.enhancer.asm.method.MediateRead;
import org.datanucleus.enhancer.asm.method.MediateWrite;
import org.datanucleus.enhancer.asm.method.NormalGet;
import org.datanucleus.enhancer.asm.method.NormalSet;
import org.datanucleus.enhancer.asm.method.WriteObject;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JdoClassAdapter
extends ClassAdapter {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ASMClassEnhancer enhancer;
    protected boolean hasDefaultConstructor = false;
    protected boolean hasSerialVersionUID = false;
    protected boolean hasJdoDetachedState = false;
    protected boolean hasWriteObject = false;
    protected boolean hasStaticInitialisation = false;

    public JdoClassAdapter(ClassVisitor cv, ASMClassEnhancer enhancer) {
        super(cv);
        this.enhancer = enhancer;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            boolean alreadyPersistenceCapable = false;
            boolean alreadyDetachable = false;
            boolean needsPersistenceCapable = false;
            boolean needsDetachable = false;
            int numInterfaces = 0;
            if (interfaces != null && interfaces.length > 0) {
                numInterfaces = interfaces.length;
                for (int i = 0; i < interfaces.length; ++i) {
                    if (interfaces[i].equals(ASMUtils.ACN_Detachable)) {
                        alreadyDetachable = true;
                    }
                    if (!interfaces[i].equals(ASMUtils.ACN_PersistenceCapable)) continue;
                    alreadyPersistenceCapable = true;
                }
            }
            if (!alreadyDetachable && this.enhancer.getClassMetaData().isDetachable()) {
                ++numInterfaces;
                needsDetachable = true;
            }
            if (!alreadyPersistenceCapable) {
                ++numInterfaces;
                needsPersistenceCapable = true;
            }
            String[] intfs = interfaces;
            if (needsDetachable || needsPersistenceCapable) {
                intfs = new String[numInterfaces];
                int position = 0;
                if (interfaces != null && interfaces.length > 0) {
                    for (int i = 0; i < interfaces.length; ++i) {
                        intfs[position++] = interfaces[i];
                    }
                }
                if (needsDetachable) {
                    intfs[position++] = ASMUtils.ACN_Detachable;
                    if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                        DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddInterface", (Object)Detachable.class.getName()));
                    }
                }
                if (needsPersistenceCapable) {
                    intfs[position++] = ASMUtils.ACN_PersistenceCapable;
                    if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                        DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddInterface", (Object)PersistenceCapable.class.getName()));
                    }
                }
            }
            this.cv.visit(version, access, name, signature, superName, intfs);
        } else {
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("serialVersionUID")) {
            this.hasSerialVersionUID = true;
        } else if (name.equals("jdoDetachedState")) {
            this.hasJdoDetachedState = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        AbstractMemberMetaData mmd;
        MethodVisitor mv;
        if (name.equals("<init>") && desc != null && desc.equals("()V")) {
            this.hasDefaultConstructor = true;
        }
        if (name.equals("writeObject") && desc != null && desc.equals("(Ljava/io/ObjectOutputStream;)V")) {
            this.hasWriteObject = true;
        }
        if (name.equals("<clinit>") && desc != null && desc.equals("()V")) {
            this.hasStaticInitialisation = true;
        }
        if ((mv = this.cv.visitMethod(access, name, desc, signature, exceptions)) == null) {
            return null;
        }
        if (name.equals("jdoPreClear") || name.equals("jdoPostLoad")) {
            return mv;
        }
        if (name.equals("readObject") && (desc.equals("(Ljava/io/ObjectOutputStream;)V") || desc.equals("(Ljava/io/ObjectInputStream;)V"))) {
            return mv;
        }
        String propGetterName = ClassUtils.getFieldNameForJavaBeanGetter((String)name);
        String propSetterName = ClassUtils.getFieldNameForJavaBeanSetter((String)name);
        if (propGetterName != null) {
            AbstractMemberMetaData mmd2 = this.enhancer.getClassMetaData().getMetaDataForMember(propGetterName);
            if (mmd2 != null && mmd2 instanceof PropertyMetaData && mmd2.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                return new JdoPropertyGetterAdapter(mv, this.enhancer, name, desc, mmd2, this.cv);
            }
        } else if (propSetterName != null && (mmd = this.enhancer.getClassMetaData().getMetaDataForMember(propSetterName)) != null && mmd instanceof PropertyMetaData && mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
            return new JdoPropertySetterAdapter(mv, this.enhancer, name, desc, mmd, this.cv);
        }
        return new JdoMethodAdapter(mv, this.enhancer, name, desc);
    }

    /*
     * WARNING - void declaration
     */
    public void visitEnd() {
        ClassMetaData cmd = this.enhancer.getClassMetaData();
        if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            List<ClassField> fields = this.enhancer.getFieldsList();
            for (ClassField field : fields) {
                if (field.getName().equals("jdoDetachedState") && this.hasJdoDetachedState) continue;
                if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                    DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddField", (Object)(((Class)field.getType()).getName() + " " + field.getName())));
                }
                this.cv.visitField(field.getAccess(), field.getName(), Type.getDescriptor((Class)((Class)field.getType())), null, null);
            }
            if (!this.hasStaticInitialisation) {
                InitClass method = InitClass.getInstance(this.enhancer);
                method.initialise(this.cv);
                method.execute();
                method.close();
            }
            if (!this.hasDefaultConstructor && this.enhancer.hasOption("generate-default-constructor")) {
                DefaultConstructor ctr = DefaultConstructor.getInstance(this.enhancer);
                ctr.initialise(this.cv);
                ctr.execute();
                ctr.close();
            }
            List<ClassMethod> methods = this.enhancer.getMethodsList();
            for (ASMClassMethod aSMClassMethod : methods) {
                aSMClassMethod.initialise(this.cv);
                aSMClassMethod.execute();
                aSMClassMethod.close();
            }
            if (Serializable.class.isAssignableFrom(this.enhancer.cls)) {
                if (!this.hasSerialVersionUID) {
                    void var6_9;
                    Object var6_7 = null;
                    try {
                        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return new Long(ObjectStreamClass.lookup(JdoClassAdapter.this.enhancer.getClassEnhanced()).getSerialVersionUID());
                            }
                        });
                    }
                    catch (Throwable e) {
                        DataNucleusEnhancer.LOGGER.warn((Object)StringUtils.getStringFromStackTrace((Throwable)e));
                    }
                    ClassField cf = new ClassField(this.enhancer, "serialVersionUID", 26, Long.TYPE, var6_9);
                    if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                        DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddField", (Object)(((Class)cf.getType()).getName() + " " + cf.getName())));
                    }
                    this.cv.visitField(cf.getAccess(), cf.getName(), Type.getDescriptor((Class)((Class)cf.getType())), null, cf.getInitialValue());
                }
                if (!this.hasWriteObject) {
                    WriteObject writeObject = WriteObject.getInstance(this.enhancer);
                    writeObject.initialise(this.cv);
                    ((ClassMethod)writeObject).execute();
                    writeObject.close();
                }
            }
            AbstractMemberMetaData[] abstractMemberMetaDataArray = cmd.getManagedMembers();
            for (int i = 0; i < abstractMemberMetaDataArray.length; ++i) {
                if (abstractMemberMetaDataArray[i].getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
                byte jdoFlag = abstractMemberMetaDataArray[i].getPersistenceFlags();
                ASMClassMethod getMethod = null;
                ASMClassMethod setMethod = null;
                if (!(abstractMemberMetaDataArray[i] instanceof PropertyMetaData)) {
                    getMethod = (jdoFlag & 2) == 2 ? new MediateRead(this.enhancer, abstractMemberMetaDataArray[i]) : ((jdoFlag & 1) == 1 ? new CheckRead(this.enhancer, abstractMemberMetaDataArray[i]) : new NormalGet(this.enhancer, abstractMemberMetaDataArray[i]));
                    setMethod = (jdoFlag & 8) == 8 ? new MediateWrite(this.enhancer, abstractMemberMetaDataArray[i]) : ((jdoFlag & 4) == 4 ? new CheckWrite(this.enhancer, abstractMemberMetaDataArray[i]) : new NormalSet(this.enhancer, abstractMemberMetaDataArray[i]));
                }
                if (getMethod != null) {
                    getMethod.initialise(this.cv);
                    getMethod.execute();
                    getMethod.close();
                }
                if (setMethod == null) continue;
                setMethod.initialise(this.cv);
                setMethod.execute();
                setMethod.close();
            }
        }
        this.cv.visitEnd();
    }
}

