/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.thirdparty;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

class GAEClientConnection
implements ManagedClientConnection {
    private ClientConnectionManager connManager;
    private HttpRoute route;
    private Object state;
    private boolean reusable;
    private HTTPRequest request;
    private HTTPResponse response;
    private boolean closed;
    private static URLFetchService urlFS = URLFetchServiceFactory.getURLFetchService();

    public GAEClientConnection(ClientConnectionManager cm, HttpRoute route, Object state) {
        this.connManager = cm;
        this.route = route;
        this.state = state;
        this.closed = true;
    }

    public boolean isSecure() {
        return this.route.isSecure();
    }

    public HttpRoute getRoute() {
        return this.route;
    }

    public SSLSession getSSLSession() {
        return null;
    }

    public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
        this.close();
        this.route = route;
    }

    public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
        throw new IOException("tunnelTarget() not supported");
    }

    public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
        throw new IOException("tunnelProxy() not supported");
    }

    public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
        throw new IOException("layerProtocol() not supported");
    }

    public void markReusable() {
        this.reusable = true;
    }

    public void unmarkReusable() {
        this.reusable = false;
    }

    public boolean isMarkedReusable() {
        return this.reusable;
    }

    public void setState(Object state) {
        this.state = state;
    }

    public Object getState() {
        return this.state;
    }

    public void setIdleDuration(long duration, TimeUnit unit) {
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        return this.response != null;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        try {
            HttpHost host = this.route.getTargetHost();
            URI uri = new URI(host.getSchemeName() + "://" + host.getHostName() + (host.getPort() == -1 ? "" : ":" + host.getPort()) + request.getRequestLine().getUri());
            this.request = new HTTPRequest(uri.toURL(), HTTPMethod.valueOf((String)request.getRequestLine().getMethod()), FetchOptions.Builder.disallowTruncate().doNotFollowRedirects());
        }
        catch (URISyntaxException ex) {
            throw new IOException("Malformed request URI: " + ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Unsupported HTTP method: " + ex.getMessage(), ex);
        }
        for (Header h : request.getAllHeaders()) {
            this.request.addHeader(new HTTPHeader(h.getName(), h.getValue()));
        }
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (request.getEntity() != null) {
            request.getEntity().writeTo((OutputStream)baos);
        }
        this.request.setPayload(baos.toByteArray());
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        if (this.response == null) {
            this.flush();
        }
        BasicHttpResponse response = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), this.response.getResponseCode(), null);
        for (HTTPHeader h : this.response.getHeaders()) {
            response.addHeader(h.getName(), h.getValue());
        }
        return response;
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (this.response == null) {
            throw new IOException("receiveResponseEntity() called on closed connection");
        }
        ByteArrayEntity bae = new ByteArrayEntity(this.response.getContent());
        bae.setContentType(response.getFirstHeader("Content-Type"));
        response.setEntity((HttpEntity)bae);
        response = null;
    }

    public void flush() throws IOException {
        if (this.request != null) {
            try {
                this.response = urlFS.fetch(this.request);
                this.request = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
        } else {
            this.response = null;
        }
    }

    public void close() throws IOException {
        this.request = null;
        this.response = null;
        this.closed = true;
    }

    public boolean isOpen() {
        return this.request != null || this.response != null;
    }

    public boolean isStale() {
        return !this.isOpen() && !this.closed;
    }

    public void setSocketTimeout(int timeout) {
    }

    public int getSocketTimeout() {
        return -1;
    }

    public void shutdown() throws IOException {
        this.close();
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public InetAddress getRemoteAddress() {
        return null;
    }

    public int getRemotePort() {
        HttpHost host = this.route.getTargetHost();
        return this.connManager.getSchemeRegistry().getScheme(host).resolvePort(host.getPort());
    }

    public void releaseConnection() throws IOException {
        this.connManager.releaseConnection((ManagedClientConnection)this, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public void abortConnection() throws IOException {
        this.unmarkReusable();
        this.shutdown();
    }
}

