/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.net.URI;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.uri.ShouldHaveAuthority;
import org.assertj.core.error.uri.ShouldHaveFragment;
import org.assertj.core.error.uri.ShouldHaveHost;
import org.assertj.core.error.uri.ShouldHavePath;
import org.assertj.core.error.uri.ShouldHavePort;
import org.assertj.core.error.uri.ShouldHaveQuery;
import org.assertj.core.error.uri.ShouldHaveScheme;
import org.assertj.core.error.uri.ShouldHaveUserInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Uris {
    private static final Uris INSTANCE = new Uris();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Uris instance() {
        return INSTANCE;
    }

    Uris() {
    }

    public void assertHasScheme(AssertionInfo info, URI actual, String scheme) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getScheme(), scheme)) {
            throw this.failures.failure(info, ShouldHaveScheme.shouldHaveScheme(actual, scheme));
        }
    }

    public void assertHasPath(AssertionInfo info, URI actual, String path) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getPath(), path)) {
            throw this.failures.failure(info, ShouldHavePath.shouldHavePath(actual, path));
        }
    }

    public void assertHasPort(AssertionInfo info, URI actual, Integer expected) {
        Comparables.assertNotNull(info, actual);
        if (actual.getPort() != expected.intValue()) {
            throw this.failures.failure(info, ShouldHavePort.shouldHavePort(actual, (int)expected));
        }
    }

    public void assertHasHost(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getHost(), expected)) {
            throw this.failures.failure(info, ShouldHaveHost.shouldHaveHost(actual, expected));
        }
    }

    public void assertHasAuthority(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getAuthority(), expected)) {
            throw this.failures.failure(info, ShouldHaveAuthority.shouldHaveAuthority(actual, expected));
        }
    }

    public void assertHasFragment(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getFragment(), expected)) {
            throw this.failures.failure(info, ShouldHaveFragment.shouldHaveFragment(actual, expected));
        }
    }

    public void assertHasQuery(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getQuery(), expected)) {
            throw this.failures.failure(info, ShouldHaveQuery.shouldHaveQuery(actual, expected));
        }
    }

    public void assertHasUserInfo(AssertionInfo info, URI actual, String expected) {
        Comparables.assertNotNull(info, actual);
        if (!Objects.areEqual(actual.getUserInfo(), expected)) {
            throw this.failures.failure(info, ShouldHaveUserInfo.shouldHaveUserInfo(actual, expected));
        }
    }
}

