/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.atom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.model.atom.AtomEntry;
import org.apache.wink.common.model.synd.SyndContent;
import org.apache.wink.common.model.synd.SyndEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/atom+xml", "application/json", "application/javascript"})
@Produces(value={"application/atom+xml", "application/json", "application/javascript"})
public class AtomEntrySyndEntryProvider
implements MessageBodyReader<SyndEntry>,
MessageBodyWriter<SyndEntry> {
    @Context
    private Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == SyndEntry.class;
    }

    public SyndEntry readFrom(Class<SyndEntry> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyReader reader = this.providers.getMessageBodyReader(AtomEntry.class, genericType, annotations, mediaType);
        AtomEntry entry = (AtomEntry)reader.readFrom(AtomEntry.class, genericType, annotations, mediaType, httpHeaders, entityStream);
        SyndEntry returnVal = entry.toSynd(new SyndEntry());
        SyndContent content = returnVal.getContent();
        if (content != null) {
            content.setProviders(RuntimeContextTLS.getRuntimeContext().getAttribute(Providers.class));
        }
        return returnVal;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(AtomEntry.class, genericType, annotations, mediaType);
        return type.isAssignableFrom(SyndEntry.class) && writer != null;
    }

    public void writeTo(SyndEntry t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        AtomEntry entry = new AtomEntry(t);
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(AtomEntry.class, genericType, annotations, mediaType);
        writer.writeTo((Object)entry, AtomEntry.class, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public long getSize(SyndEntry t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

