/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.generate;

import commonj.sdo.helper.XSDHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sdo.generate.JavaGenerator;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.XSDHelperImpl;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;

public class XSD2JavaGenerator
extends JavaGenerator {
    protected String schemaNamespace = null;
    protected String namespaceInfo = null;
    protected String generateBuiltIn = null;
    protected static GeneratedPackages generatedPackages = null;
    protected boolean allNamespaces = false;

    public static void main(String[] args) {
        try {
            XSD2JavaGenerator generator = new XSD2JavaGenerator();
            generator.processArguments(args);
            generator.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            XSD2JavaGenerator.printUsage();
        }
    }

    protected int handleArgument(String[] args, int index) {
        if (args[index].equalsIgnoreCase("-schemaNamespace")) {
            this.schemaNamespace = args[++index];
            if ("all".equalsIgnoreCase(this.schemaNamespace)) {
                this.schemaNamespace = null;
                this.allNamespaces = true;
            }
        } else if (args[index].equalsIgnoreCase("-generateBuiltIn")) {
            this.generateBuiltIn = args[++index];
        } else if (args[index].equalsIgnoreCase("-namespaceInfo")) {
            this.namespaceInfo = args[++index];
        } else {
            return super.handleArgument(args, index);
        }
        return index + 1;
    }

    protected void run(String[] args) {
        String xsdFileName = args[this.inputIndex];
        EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)packageRegistry);
        String packageURI = XSD2JavaGenerator.getSchemaNamespace(xsdFileName);
        Hashtable packageInfoTable = XSD2JavaGenerator.createPackageInfoTable(packageURI, this.schemaNamespace, this.javaPackage, this.prefix, this.namespaceInfo);
        XSD2JavaGenerator.generateFromXMLSchema(xsdFileName, (EPackage.Registry)packageRegistry, (ExtendedMetaData)extendedMetaData, this.targetDirectory, packageInfoTable, this.genOptions, this.generateBuiltIn, this.allNamespaces);
    }

    public static void generateFromXMLSchema(String xsdFileName, String namespace, String targetDirectory, String javaPackage, String prefix, int genOptions) {
        boolean allNamespaces = false;
        if ("all".equalsIgnoreCase(namespace)) {
            namespace = null;
            allNamespaces = true;
        }
        EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)packageRegistry);
        String packageURI = XSD2JavaGenerator.getSchemaNamespace(xsdFileName);
        Hashtable packageInfoTable = XSD2JavaGenerator.createPackageInfoTable(packageURI, namespace, javaPackage, prefix, null);
        XSD2JavaGenerator.generateFromXMLSchema(xsdFileName, (EPackage.Registry)packageRegistry, (ExtendedMetaData)extendedMetaData, targetDirectory, packageInfoTable, genOptions, null, allNamespaces);
    }

    protected static GenModel generateFromXMLSchema(String xsdFileName, EPackage.Registry packageRegistry, ExtendedMetaData extendedMetaData, String targetDirectory, Hashtable packageInfoTable, int genOptions, String regenerateBuiltIn, boolean allNamespaces) {
        GenModel genModel = null;
        HelperContextImpl hc = new HelperContextImpl(extendedMetaData, false);
        XSDHelper xsdHelper = hc.getXSDHelper();
        ((XSDHelperImpl)xsdHelper).setRedefineBuiltIn(regenerateBuiltIn);
        try {
            File inputFile = new File(xsdFileName).getAbsoluteFile();
            FileInputStream inputStream = new FileInputStream(inputFile);
            xsdHelper.define((InputStream)inputStream, inputFile.toURI().toString());
            targetDirectory = targetDirectory == null ? new File(xsdFileName).getCanonicalFile().getParent() : new File(targetDirectory).getCanonicalPath();
            if (!packageRegistry.values().isEmpty()) {
                genModel = XSD2JavaGenerator.generatePackages(packageRegistry.values(), targetDirectory, packageInfoTable, genOptions, allNamespaces);
            } else {
                System.err.println("Input schema file " + xsdFileName + " defined no metadata.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return genModel;
    }

    public static String getSchemaNamespace(String xsdFileName) {
        File inputFile;
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        Resource model = resourceSet.getResource(URI.createURI((String)(inputFile = new File(xsdFileName).getAbsoluteFile()).toURI().toString()), true);
        XSDSchema schema = (XSDSchema)model.getContents().get(0);
        String targetNS = schema.getTargetNamespace();
        if (targetNS == null) {
            targetNS = schema.getSchemaLocation();
        }
        return targetNS;
    }

    protected static void printUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [ -targetDirectory <target-root-directory> ]");
        System.out.println("  [ -javaPackage <java-package-name> ]");
        System.out.println("  [ -prefix <prefix-string> ]");
        System.out.println("  [ -schemaNamespace <namespace-uri> ]");
        System.out.println("  [ -namespaceInfo <namespaces-file> ]");
        System.out.println("  [ -noInterfaces ]");
        System.out.println("  [ -noContainment ]");
        System.out.println("  [ -noNotification ]");
        System.out.println("  [ -noUnsettable ]");
        System.out.println("  <xsd-file> | <wsdl-file>");
        System.out.println("");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("  generate somedir/somefile.xsd");
    }

    public void generateFromXMLSchema(String[] args) {
        try {
            this.processArguments(args);
            EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
            BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)packageRegistry);
            String xsdFileName = args[this.inputIndex];
            String packageURI = XSD2JavaGenerator.getSchemaNamespace(xsdFileName);
            Hashtable packageInfoTable = XSD2JavaGenerator.createPackageInfoTable(packageURI, this.schemaNamespace, this.javaPackage, this.prefix, this.namespaceInfo);
            GenModel genModel = XSD2JavaGenerator.generateFromXMLSchema(xsdFileName, (EPackage.Registry)packageRegistry, (ExtendedMetaData)extendedMetaData, this.targetDirectory, packageInfoTable, this.genOptions, this.generateBuiltIn, this.allNamespaces);
            generatedPackages = new GeneratedPackages(genModel, (ExtendedMetaData)extendedMetaData);
        }
        catch (IllegalArgumentException e) {
            XSD2JavaGenerator.printUsage();
        }
    }

    private static Hashtable createPackageInfoTable(String packageURI, String schemaNamespace, String javaPackage, String prefix, String namespaceInfo) {
        Hashtable<String, JavaGenerator.PackageInfo> packageInfoTable = new Hashtable<String, JavaGenerator.PackageInfo>();
        if (namespaceInfo != null) {
            try {
                FileReader inputFile = new FileReader(namespaceInfo);
                BufferedReader bufRead = new BufferedReader(inputFile);
                String line = bufRead.readLine();
                while (line != null) {
                    if (line.length() > 0) {
                        String[] options = line.split(";");
                        if (options.length > 1) {
                            if (options.length > 2) {
                                packageInfoTable.put(options[0], new JavaGenerator.PackageInfo(options[1], options[2], options[0], null));
                            } else {
                                packageInfoTable.put(options[0], new JavaGenerator.PackageInfo(options[1], null, options[0], null));
                            }
                        } else {
                            packageInfoTable.put(options[0], new JavaGenerator.PackageInfo(null, null, options[0], null));
                        }
                    }
                    line = bufRead.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (schemaNamespace != null) {
            packageInfoTable.put(schemaNamespace, new JavaGenerator.PackageInfo(javaPackage, prefix, schemaNamespace, null));
        } else if (packageURI != null) {
            packageInfoTable.put(packageURI, new JavaGenerator.PackageInfo(javaPackage, prefix, null, null));
        }
        return packageInfoTable;
    }

    public List getGeneratedPackageInfo() {
        if (generatedPackages != null) {
            return generatedPackages.getPackageList();
        }
        return null;
    }

    public class GeneratedPackage {
        private String namespace;
        private Hashtable classes = new Hashtable();

        public String getNamespace() {
            return this.namespace;
        }

        public List getClasses() {
            return new ArrayList(this.classes.values());
        }

        GeneratedPackage(GenPackage genPackage, ExtendedMetaData extendedMetaData, Hashtable eclassGenClassMap) {
            EPackage ePackage = genPackage.getEcorePackage();
            this.namespace = extendedMetaData.getNamespace(ePackage);
            EList genClasses = genPackage.getGenClasses();
            Iterator iterClass = genClasses.iterator();
            while (iterClass.hasNext()) {
                GenClass genClass = (GenClass)iterClass.next();
                if (!"DocumentRoot".equals(genClass.getEcoreClass().getName())) continue;
                EList features = genClass.getGenFeatures();
                Iterator iterFeatures = features.iterator();
                while (iterFeatures.hasNext()) {
                    GenFeature feature = (GenFeature)iterFeatures.next();
                    this.addGlobalElement(feature.getEcoreFeature(), extendedMetaData, eclassGenClassMap);
                }
            }
        }

        private void addGlobalElement(EStructuralFeature eFeature, ExtendedMetaData extendedMetaData, Hashtable eclassGenClassMap) {
            String name = eFeature.getName();
            String classname = "";
            boolean anonymous = false;
            ArrayList<String> propertyClassNames = null;
            EClassifier eClassifier = eFeature.getEType();
            if (eClassifier instanceof EClass) {
                EClass eClass = (EClass)eClassifier;
                GenClass genEClass = (GenClass)eclassGenClassMap.get(eClassifier);
                if (genEClass != null) {
                    classname = genEClass.getGenPackage().getInterfacePackageName() + '.' + genEClass.getInterfaceName();
                    anonymous = extendedMetaData.isAnonymous((EClassifier)eClass);
                    propertyClassNames = new ArrayList<String>();
                    EList properties = eClass.getEStructuralFeatures();
                    Iterator iterProperties = properties.iterator();
                    while (iterProperties.hasNext()) {
                        EStructuralFeature property = (EStructuralFeature)iterProperties.next();
                        EClassifier propertyType = property.getEType();
                        if (propertyType instanceof EClass) {
                            GenClass propertyGenClass = (GenClass)eclassGenClassMap.get(propertyType);
                            if (propertyGenClass == null) continue;
                            String propertyClassName = propertyGenClass.getGenPackage().getInterfacePackageName() + '.' + propertyGenClass.getInterfaceName();
                            propertyClassNames.add(propertyClassName);
                            continue;
                        }
                        if (!(propertyType instanceof EClassifier)) continue;
                        String propertyClassName = propertyType.getInstanceClass().getName();
                        propertyClassNames.add(propertyClassName);
                    }
                }
            } else {
                classname = eClassifier.getInstanceClass().getName();
            }
            this.classes.put(name, new PackageClassInfo(name, classname, anonymous, propertyClassNames));
        }

        public class PackageClassInfo {
            private String name;
            private String className = null;
            private boolean anonymous = false;
            private List properties = null;

            PackageClassInfo(String name, String className, boolean anonymous, List properties) {
                this.name = name;
                this.className = className;
                this.anonymous = anonymous;
                this.properties = properties;
            }

            public String getName() {
                return this.name;
            }

            public String getClassName() {
                return this.className;
            }

            public boolean getAnonymous() {
                return this.anonymous;
            }

            public List getProperties() {
                return this.properties;
            }
        }
    }

    protected class GeneratedPackages {
        private List genPackages = null;

        GeneratedPackages(GenModel genModel, ExtendedMetaData extendedMetaData) {
            GenPackage genPackage;
            EList packages = genModel.getGenPackages();
            Hashtable<EClass, GenClass> genClasses = new Hashtable<EClass, GenClass>();
            Iterator iter = packages.iterator();
            while (iter.hasNext()) {
                genPackage = (GenPackage)iter.next();
                EList classes = genPackage.getGenClasses();
                Iterator classIter = classes.iterator();
                while (classIter.hasNext()) {
                    GenClass genClass = (GenClass)classIter.next();
                    genClasses.put(genClass.getEcoreClass(), genClass);
                }
            }
            this.genPackages = new ArrayList();
            iter = packages.iterator();
            while (iter.hasNext()) {
                genPackage = (GenPackage)iter.next();
                this.genPackages.add(new GeneratedPackage(genPackage, extendedMetaData, genClasses));
            }
        }

        List getPackageList() {
            return this.genPackages;
        }
    }
}

