/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.spi;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import commonj.sdo.impl.HelperProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tuscany.sdo.api.SDOHelper;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.api.XMLStreamHelper;
import org.apache.tuscany.sdo.lib.SDOObjectInputStream;
import org.apache.tuscany.sdo.lib.SDOObjectOutputStream;

public abstract class HelperProviderBase
extends HelperProvider {
    protected CopyHelper copyHelper;
    protected DataFactory dataFactory;
    protected DataHelper dataHelper;
    protected EqualityHelper equalityHelper;
    protected TypeHelper typeHelper;
    protected XMLHelper xmlHelper;
    protected XSDHelper xsdHelper;
    protected SDOHelper sdoHelper;
    protected XMLStreamHelper xmlStreamHelper;

    protected abstract HelperContext createDefaultHelpers();

    public HelperProviderBase() {
        defaultContext = this.createDefaultHelpers();
    }

    public SDOHelper sdoHelper() {
        return this.sdoHelper;
    }

    public CopyHelper copyHelper() {
        return this.copyHelper;
    }

    public DataFactory dataFactory() {
        return this.dataFactory;
    }

    public DataHelper dataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper equalityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper typeHelper() {
        return this.typeHelper;
    }

    public XMLHelper xmlHelper() {
        return this.xmlHelper;
    }

    public XMLStreamHelper xmlStreamHelper() {
        return this.xmlStreamHelper;
    }

    public XSDHelper xsdHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable resolvable() {
        return new ResolvableImpl();
    }

    public ExternalizableDelegator.Resolvable resolvable(Object target) {
        return new ResolvableImpl(target);
    }

    protected class ResolvableImpl
    implements ExternalizableDelegator.Resolvable {
        protected Object target;

        public ResolvableImpl(Object target) {
            this.target = target;
        }

        public ResolvableImpl() {
            this.target = null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            if (!(this.target instanceof DataObject)) {
                throw new NotSerializableException();
            }
            this.writeDataObject((DataObject)this.target, out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.target = this.readDataObject(in);
        }

        public Object readResolve() throws ObjectStreamException {
            return this.target;
        }

        protected void writeDataObject(DataObject dataObject, ObjectOutput objectOutput) throws IOException {
            DataGraph dataGraph = dataObject.getDataGraph();
            if (dataGraph != null) {
                objectOutput.writeByte(0);
                objectOutput.writeUTF(SDOUtil.getXPath(dataObject));
                objectOutput.writeObject(dataGraph);
            } else if (dataObject.getContainer() != null) {
                objectOutput.writeByte(0);
                objectOutput.writeUTF(SDOUtil.getXPath(dataObject));
                objectOutput.writeObject(dataObject.getRootObject());
            } else {
                objectOutput.writeByte(1);
                ByteArrayOutputStream compressedByteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressedByteArrayOutputStream);
                XMLHelper xmlHelperLocal = HelperProviderBase.this.xmlHelper;
                if (objectOutput instanceof SDOObjectOutputStream) {
                    xmlHelperLocal = ((SDOObjectOutputStream)objectOutput).getHelperContext().getXMLHelper();
                }
                xmlHelperLocal.save(dataObject, "commonj.sdo", "dataObject", (OutputStream)gzipOutputStream);
                gzipOutputStream.close();
                byte[] byteArray = compressedByteArrayOutputStream.toByteArray();
                objectOutput.writeInt(byteArray.length);
                objectOutput.write(byteArray);
            }
        }

        protected DataObject readDataObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            boolean isRoot;
            boolean bl = isRoot = objectInput.readByte() == 1;
            if (isRoot) {
                int bytesRead;
                int length = objectInput.readInt();
                byte[] compressedBytes = new byte[length];
                for (int index = 0; index < length && (bytesRead = objectInput.read(compressedBytes, index, length - index)) != -1; index += bytesRead) {
                }
                GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(compressedBytes));
                XMLHelper xmlHelperLocal = HelperProviderBase.this.xmlHelper;
                if (objectInput instanceof SDOObjectInputStream) {
                    xmlHelperLocal = ((SDOObjectInputStream)objectInput).getHelperContext().getXMLHelper();
                }
                XMLDocument doc = xmlHelperLocal.load((InputStream)gzipInputStream);
                gzipInputStream.close();
                return doc.getRootObject();
            }
            String xpath = objectInput.readUTF();
            Object object = objectInput.readObject();
            DataObject root = object instanceof DataGraph ? ((DataGraph)object).getRootObject() : (DataObject)object;
            return xpath.equals("") ? root : root.getDataObject(xpath);
        }
    }
}

