/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.model.internal.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.FactoryBase;
import org.apache.tuscany.sdo.model.internal.InternalFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class InternalFactoryImpl
extends FactoryBase
implements InternalFactory {
    public static final String NAMESPACE_URI = "http://www.apache.org/tuscany/commonj.sdo.internal";
    public static final String NAMESPACE_PREFIX = "internal";
    public static final String PATTERN_VERSION = "1.2";
    public static final int BASE64_BYTES = 1;
    public static final int QNAME = 2;
    protected Type base64BytesType = null;
    protected Type qNameType = null;
    private static InternalFactoryImpl instance = null;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    public InternalFactoryImpl() {
        super(NAMESPACE_URI, NAMESPACE_PREFIX, "org.apache.tuscany.sdo.model.internal");
    }

    public void register(HelperContext scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope can not be null");
        }
        TypeHelperImpl th = (TypeHelperImpl)scope.getTypeHelper();
        th.getExtendedMetaData().putPackage(NAMESPACE_URI, (EPackage)this);
    }

    public DataObject create(int typeNumber) {
        switch (typeNumber) {
            default: 
        }
        return super.create(typeNumber);
    }

    public Object createFromString(int typeNumber, String initialValue) {
        switch (typeNumber) {
            case 1: {
                return this.createBase64BytesFromString(initialValue);
            }
            case 2: {
                return this.createQNameFromString(initialValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public String convertToString(int typeNumber, Object instanceValue) {
        switch (typeNumber) {
            case 1: {
                return this.convertBase64BytesToString(instanceValue);
            }
            case 2: {
                return this.convertQNameToString(instanceValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public Type getBase64Bytes() {
        return this.base64BytesType;
    }

    public Type getQName() {
        return this.qNameType;
    }

    public static InternalFactoryImpl init() {
        if (instance != null) {
            return instance;
        }
        instance = new InternalFactoryImpl();
        instance.createMetaData();
        instance.initializeMetaData();
        return instance;
    }

    public void createMetaData() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.base64BytesType = this.createType(true, 1);
        this.qNameType = this.createType(true, 2);
    }

    public void initializeMetaData() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        Object property = null;
        this.initializeType(this.base64BytesType, [B.class, "Base64Bytes", true, false);
        this.setInstanceProperty(this.base64BytesType, "commonj.sdo/java", "instanceClass", "byte[]");
        this.initializeType(this.qNameType, String.class, "QName", true, false);
        this.setInstanceProperty(this.qNameType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.createXSDMetaData();
    }

    protected void createXSDMetaData() {
        super.initXSD();
        Object property = null;
        this.addXSDMapping(this.base64BytesType, new String[]{"name", "Base64Bytes"});
        this.addXSDMapping(this.qNameType, new String[]{"name", "QName"});
    }

    public byte[] createBase64BytesFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createBase64Binary(initialValue);
    }

    public String convertBase64BytesToString(Object instanceValue) {
        if (instanceValue instanceof byte[]) {
            return XMLTypeFactory.eINSTANCE.convertBase64Binary((byte[])instanceValue);
        }
        return XMLTypeFactory.eINSTANCE.convertBase64Binary(instanceValue.toString().getBytes());
    }

    public String createQNameFromString(String initialValue) {
        return (String)super.createFromString(2, initialValue);
    }

    public String convertQNameToString(Object instanceValue) {
        return super.convertToString(2, instanceValue);
    }
}

