/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.impl;

import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.SDOPackage;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.Type;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.util.BasicSequence;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class ClassImpl
extends EClassImpl
implements commonj.sdo.Type,
Type {
    private static final long serialVersionUID = 1L;
    private static final Property UNINITIALIZED_PROPERTY = SDOFactory.eINSTANCE.createAttribute();
    private Property changeSummaryPropertyCache = UNINITIALIZED_PROPERTY;
    private static final EStructuralFeature UNINITIALIZED_SEQUENCE_FEATURE = (EAttribute)SDOFactory.eINSTANCE.createAttribute();
    protected static final EStructuralFeature VIRTUAL_SEQUENCE_FEATURE = (EAttribute)SDOFactory.eINSTANCE.createAttribute();
    private EStructuralFeature sequenceFeature = UNINITIALIZED_SEQUENCE_FEATURE;
    protected List aliasNames = null;
    protected List declaredProperties = null;
    protected List extendedProperties = null;
    protected List allProperties = null;
    protected List allExtendedProperties = null;
    protected EList allFeaturesCache = null;
    protected Map propertyNameToPropertyMap;

    protected ClassImpl() {
    }

    protected EClass eStaticClass() {
        return SDOPackage.eINSTANCE.getClass_();
    }

    public String getURI() {
        return this.getEPackage().getNsURI();
    }

    public boolean isDataType() {
        return false;
    }

    public boolean isOpen() {
        List properties = this.getExtendedProperties();
        if (properties != Collections.EMPTY_LIST) {
            int count = properties.size();
            for (int i = 0; i < count; ++i) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)properties.get(i);
                if (!this.isOpenFeatureMap(eStructuralFeature)) continue;
                return true;
            }
        }
        Iterator iterator = this.getBaseTypes().iterator();
        while (iterator.hasNext()) {
            commonj.sdo.Type baseType = (commonj.sdo.Type)iterator.next();
            if (!baseType.isOpen()) continue;
            return true;
        }
        return false;
    }

    public EStructuralFeature getSequenceFeature() {
        if (this.sequenceFeature == UNINITIALIZED_SEQUENCE_FEATURE) {
            EStructuralFeature sequenceFeatureCandidate = null;
            boolean hasNonDerivedFeatures = false;
            Iterator iterator = this.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if (eStructuralFeature.isDerived()) continue;
                if (sequenceFeatureCandidate == null && this.isSequenceFeatureMap(eStructuralFeature)) {
                    sequenceFeatureCandidate = eStructuralFeature;
                    continue;
                }
                if (!this.isElementFeature(eStructuralFeature) || DataObjectUtil.isInternalProperty(eStructuralFeature)) continue;
                hasNonDerivedFeatures = true;
            }
            this.sequenceFeature = sequenceFeatureCandidate != null && hasNonDerivedFeatures ? VIRTUAL_SEQUENCE_FEATURE : sequenceFeatureCandidate;
        }
        return this.sequenceFeature;
    }

    protected boolean isSequenceFeatureMap(EStructuralFeature eStructuralFeature) {
        switch (ExtendedMetaData.INSTANCE.getFeatureKind(eStructuralFeature)) {
            case 5: {
                return eStructuralFeature.getUpperBound() != 1;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected boolean isElementFeature(EStructuralFeature eStructuralFeature) {
        switch (ExtendedMetaData.INSTANCE.getFeatureKind(eStructuralFeature)) {
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    public List getVirtualSequenceProperties() {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        Iterator iterator = this.getEAllStructuralFeatures().iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (eStructuralFeature.isDerived() || !this.isElementFeature(eStructuralFeature)) continue;
            result.add(eStructuralFeature);
        }
        return result;
    }

    public void setSequenceFeature(EAttribute sequenceFeature) {
        this.getEStructuralFeatures().add((Object)sequenceFeature);
        this.sequenceFeature = sequenceFeature;
    }

    public boolean isSequenced() {
        return this.getSequenceFeature() != null;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = DataObjectUtil.getAliasNames((EClassifier)this);
        }
        return this.aliasNames;
    }

    public List getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.initPropertyLists();
        }
        return this.declaredProperties;
    }

    public List getExtendedProperties() {
        if (this.extendedProperties == null) {
            this.initPropertyLists();
        }
        return this.extendedProperties;
    }

    protected List getTypeFeatures() {
        return this.getEStructuralFeatures();
    }

    protected void initPropertyLists() {
        ArrayList<EStructuralFeature> declaredProperties = new ArrayList<EStructuralFeature>();
        ArrayList<EStructuralFeature> extendedProperties = Collections.EMPTY_LIST;
        Iterator i = this.getTypeFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            boolean isExtendedProperty = DataObjectUtil.isInternalProperty(eStructuralFeature);
            if (isExtendedProperty) {
                if (extendedProperties == Collections.EMPTY_LIST) {
                    extendedProperties = new ArrayList<EStructuralFeature>();
                }
                extendedProperties.add(eStructuralFeature);
                continue;
            }
            declaredProperties.add(eStructuralFeature);
        }
        this.declaredProperties = declaredProperties;
        this.extendedProperties = extendedProperties;
    }

    public EList getEStructuralFeatures() {
        if (this.eStructuralFeatures == null) {
            this.eStructuralFeatures = new EObjectContainmentWithInverseEList(EStructuralFeature.class, (InternalEObject)this, 19, 16){

                protected void didChange() {
                    ClassImpl.this.extendedProperties = null;
                    ClassImpl.this.declaredProperties = null;
                }
            };
        }
        return this.eStructuralFeatures;
    }

    public List getProperties() {
        EList allFeatures = this.getEAllStructuralFeatures();
        if (allFeatures != this.allFeaturesCache) {
            this.allFeaturesCache = allFeatures;
            this.allExtendedProperties = null;
            this.allProperties = null;
        }
        if (this.allProperties == null) {
            UniqueEList allProperties = new UniqueEList();
            Iterator iterator = this.getBaseTypes().iterator();
            while (iterator.hasNext()) {
                commonj.sdo.Type baseType = (commonj.sdo.Type)iterator.next();
                allProperties.addAll(baseType.getProperties());
            }
            allProperties.addAll(this.getDeclaredProperties());
            this.allProperties = allProperties;
        }
        return this.allProperties;
    }

    public List getAllExtendedProperties() {
        EList allFeatures = this.getEAllStructuralFeatures();
        if (allFeatures != this.allFeaturesCache) {
            this.allFeaturesCache = allFeatures;
            this.allExtendedProperties = null;
            this.allProperties = null;
        }
        if (this.allExtendedProperties == null) {
            UniqueEList allExtendedProperties = new UniqueEList();
            Iterator iterator = this.getBaseTypes().iterator();
            while (iterator.hasNext()) {
                commonj.sdo.Type baseType = (commonj.sdo.Type)iterator.next();
                allExtendedProperties.addAll(((ClassImpl)baseType).getAllExtendedProperties());
            }
            allExtendedProperties.addAll(this.getExtendedProperties());
            this.allExtendedProperties = allExtendedProperties;
        }
        return this.allExtendedProperties;
    }

    protected boolean isOpenFeatureMap(EStructuralFeature eStructuralFeature) {
        switch (ExtendedMetaData.INSTANCE.getFeatureKind(eStructuralFeature)) {
            case 5: {
                return eStructuralFeature != ExtendedMetaData.INSTANCE.getMixedFeature((EClass)this);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void addOpenProperties(EObject dataObject, Collection propertyList) {
        Iterator iterator = this.getBaseTypes().iterator();
        while (iterator.hasNext()) {
            ClassImpl baseType = (ClassImpl)iterator.next();
            baseType.addOpenProperties(dataObject, propertyList);
        }
        Iterator iter = this.getExtendedProperties().iterator();
        while (iter.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iter.next();
            if (!this.isOpenFeatureMap(eStructuralFeature)) continue;
            List features = (List)dataObject.eGet(eStructuralFeature);
            int size = features.size();
            for (int j = 0; j < size; ++j) {
                FeatureMap.Entry entry = (FeatureMap.Entry)features.get(j);
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                Property property = BasicSequence.getFeatureProperty(entryFeature);
                if (property == null) continue;
                propertyList.add(entryFeature);
            }
        }
    }

    public Property getOpenProperty(EObject dataObject, String featureName) {
        Iterator iterator = this.getBaseTypes().iterator();
        while (iterator.hasNext()) {
            ClassImpl baseType = (ClassImpl)iterator.next();
            Property result = baseType.getOpenProperty(dataObject, featureName);
            if (result == null) continue;
            return result;
        }
        HashSet<EStructuralFeature> openFeatureSet = new HashSet<EStructuralFeature>();
        Iterator iter = this.getExtendedProperties().iterator();
        while (iter.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iter.next();
            if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) continue;
            List features = (List)dataObject.eGet(eStructuralFeature);
            int size = features.size();
            for (int j = 0; j < size; ++j) {
                Property property;
                FeatureMap.Entry entry = (FeatureMap.Entry)features.get(j);
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                if (!openFeatureSet.add(entryFeature) || (property = BasicSequence.getFeatureProperty(entryFeature)) == null) continue;
                if (property.getName().equals(featureName)) {
                    return (Property)entryFeature;
                }
                List aliasNames = property.getAliasNames();
                int aliasCount = aliasNames.size();
                while (aliasCount > 0) {
                    if (!aliasNames.get(--aliasCount).equals(featureName)) continue;
                    return (Property)entryFeature;
                }
            }
        }
        return null;
    }

    public List getBaseTypes() {
        return this.getESuperTypes();
    }

    private void initAliasNames() {
        HashMap<String, Property> result = new HashMap<String, Property>();
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            result.put(property.getName(), property);
            List aliasNames = property.getAliasNames();
            int count = aliasNames.size();
            while (count > 0) {
                result.put((String)aliasNames.get(--count), property);
            }
        }
        this.propertyNameToPropertyMap = result;
    }

    public Property getProperty(String propertyName) {
        Property property;
        if (this.propertyNameToPropertyMap == null) {
            this.initAliasNames();
        }
        if ((property = (Property)this.propertyNameToPropertyMap.get(propertyName)) == null && !this.isOpen()) {
            this.initAliasNames();
            property = (Property)this.propertyNameToPropertyMap.get(propertyName);
        }
        return property;
    }

    public List getInstanceProperties() {
        return DataObjectUtil.getMetaObjectInstanceProperties((EModelElement)this);
    }

    public Object get(Property property) {
        return DataObjectUtil.getMetaObjectInstanceProperty((EModelElement)this, property);
    }

    public List getBaseType() {
        return this.getBaseTypes();
    }

    public List getProperty() {
        return this.getProperties();
    }

    public List getAliasName() {
        return this.getAliasNames();
    }

    public void unsetAbstract() {
        this.eUnset((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_Abstract());
    }

    public boolean isSetAbstract() {
        return this.eIsSet((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_Abstract());
    }

    public Sequence getAny() {
        throw new UnsupportedOperationException();
    }

    public Sequence getAnyAttribute() {
        throw new UnsupportedOperationException();
    }

    public void setDataType(boolean value) {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public void unsetDataType() {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public boolean isSetDataType() {
        return false;
    }

    public void setOpen(boolean value) {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public void unsetOpen() {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public boolean isSetOpen() {
        return this.isOpen();
    }

    public void setSequenced(boolean value) {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public void unsetSequenced() {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public boolean isSetSequenced() {
        return this.isSequenced();
    }

    public void unsetName() {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public boolean isSetName() {
        return true;
    }

    public void unsetUri() {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public boolean isSetUri() {
        return true;
    }

    public void setUri(String value) {
        throw new UnsupportedOperationException("Type is frozen and cannot be modified");
    }

    public String getUri() {
        return this.getURI();
    }

    public Property getChangeSummaryProperty() {
        if (this.changeSummaryPropertyCache == UNINITIALIZED_PROPERTY) {
            this.changeSummaryPropertyCache = null;
            commonj.sdo.Type csType = ((ModelFactoryImpl)ModelFactory.INSTANCE).getChangeSummaryType();
            Iterator props = this.getProperties().iterator();
            while (props.hasNext()) {
                Property p = (Property)props.next();
                if (csType != p.getType()) continue;
                this.changeSummaryPropertyCache = p;
                break;
            }
        }
        return this.changeSummaryPropertyCache;
    }
}

