/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.SDOExtendedMetaData;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.helper.BaseSDOXSDEcoreBuilder;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.AttributeImpl;
import org.apache.tuscany.sdo.impl.SDOFactoryImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.ecore.EcoreSchemaBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SDOXSDEcoreBuilder
extends BaseSDOXSDEcoreBuilder {
    protected boolean replaceConflictingTypes = false;
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDSchemaLocator;

    public SDOXSDEcoreBuilder(ExtendedMetaData extendedMetaData, boolean replaceConflictingTypes) {
        super(extendedMetaData);
        this.ecoreFactory = new SDOFactoryImpl.SDOEcoreFactory();
        this.replaceConflictingTypes = replaceConflictingTypes;
        this.populateTypeToTypeObjectMap((EPackage)ModelFactory.INSTANCE);
    }

    protected boolean useSortedAttributes() {
        return false;
    }

    protected static String lookupPrefix(Node element, String namespaceURI) {
        Node parent;
        String prefix = element.getPrefix();
        if (prefix != null && namespaceURI != null && namespaceURI.equals(element.getNamespaceURI())) {
            return prefix;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int index = attributes.getLength();
            while (index != 0) {
                Node attribute;
                if (!"http://www.w3.org/2000/xmlns/".equals((attribute = attributes.item(--index)).getNamespaceURI()) || !attribute.getNodeValue().equals(namespaceURI) || !"xmlns".equals(attribute.getPrefix())) continue;
                return attribute.getLocalName();
            }
        }
        while ((parent = element.getParentNode()) != null) {
            if (parent.getNodeType() == 1) {
                return SDOXSDEcoreBuilder.lookupPrefix(parent, namespaceURI);
            }
            element = parent;
        }
        return null;
    }

    public EPackage getEPackage(XSDNamedComponent xsdNamedComponent) {
        XSDSchema containingXSDSchema = xsdNamedComponent.getSchema();
        String targetNamespace = containingXSDSchema == null ? xsdNamedComponent.getTargetNamespace() : containingXSDSchema.getTargetNamespace();
        EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(targetNamespace);
        if (ePackage != null) {
            return ePackage;
        }
        ePackage = super.getEPackage(xsdNamedComponent);
        String nsPrefix = SDOXSDEcoreBuilder.lookupPrefix(xsdNamedComponent.getElement(), targetNamespace);
        if (nsPrefix != null) {
            ePackage.setNsPrefix(nsPrefix);
        }
        return ePackage;
    }

    public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        EClassifier eClassifier = null;
        if (xsdTypeDefinition != null) {
            EPackage pkg;
            if (this.rootSchema.getSchemaForSchemaNamespace().equals(xsdTypeDefinition.getTargetNamespace())) {
                eClassifier = this.getBuiltInEClassifier(xsdTypeDefinition.getURI(), xsdTypeDefinition.getName());
            } else if (xsdTypeDefinition.getContainer() == null && (pkg = this.extendedMetaData.getPackage(xsdTypeDefinition.getTargetNamespace())) != null) {
                eClassifier = pkg.getEClassifier(xsdTypeDefinition.getName());
            }
        }
        if (eClassifier == null) {
            eClassifier = super.getEClassifier(xsdTypeDefinition);
        }
        return eClassifier;
    }

    public EDataType getEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        EDataType eClassifier = null;
        eClassifier = xsdSimpleTypeDefinition != null && this.rootSchema.getSchemaForSchemaNamespace().equals(xsdSimpleTypeDefinition.getTargetNamespace()) ? (EDataType)this.getBuiltInEClassifier(xsdSimpleTypeDefinition.getURI(), xsdSimpleTypeDefinition.getName()) : super.getEDataType(xsdSimpleTypeDefinition);
        return eClassifier;
    }

    protected ResourceSet createResourceSet() {
        ResourceSet result = super.createResourceSet();
        result.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XSDResourceFactoryImpl());
        result.getAdapterFactories().add((Object)new XSDSchemaAdapterFactoryImpl());
        result.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl(HelperContextImpl.getBuiltInModelRegistry()));
        return result;
    }

    protected EClassifier getBuiltInEClassifier(String namespace, String name) {
        EClassifier eClassifier = null;
        eClassifier = "base64Binary".equals(name) ? (EClassifier)AttributeImpl.INTERNAL_BASE64_BYTES : ("QName".equals(name) ? (EClassifier)AttributeImpl.INTERNAL_QNAME : (EClassifier)SDOUtil.getXSDSDOType((String)name));
        if (eClassifier == null) {
            eClassifier = super.getBuiltInEClassifier(namespace, name);
        }
        return eClassifier;
    }

    private void updateReferences(EObject oldEObject, EObject newEObject) {
        Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)oldEObject, this.targetNamespaceToEPackageMap.values());
        Iterator iter = usages.iterator();
        while (iter.hasNext()) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iter.next();
            EObject referencingEObject = setting.getEObject();
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (!eStructuralFeature.isChangeable()) continue;
            if (eStructuralFeature.isMany()) {
                List refList = (List)referencingEObject.eGet(eStructuralFeature);
                int refIndex = refList.indexOf(oldEObject);
                if (refIndex == -1) continue;
                refList.set(refIndex, newEObject);
                continue;
            }
            referencingEObject.eSet(eStructuralFeature, (Object)newEObject);
        }
    }

    private XSDTypeDefinition getXSDTypeDefinition(EClassifier eClassifier) {
        XSDTypeDefinition xsdTypeDefinition = null;
        Iterator i = this.xsdComponentToEModelElementMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (eClassifier != e.getValue()) continue;
            xsdTypeDefinition = (XSDTypeDefinition)e.getKey();
            break;
        }
        return xsdTypeDefinition;
    }

    private boolean sameType(XSDTypeDefinition t1, XSDTypeDefinition t2) {
        XSDTypeDefinition n2;
        XSDTypeDefinition n1 = t1;
        for (n2 = t2; n1 != null && n2 != null && n1.eClass() == n2.eClass(); n1 = n1.getContainer(), n2 = n2.getContainer()) {
            if (!(n1 instanceof XSDNamedComponent)) continue;
            String s1 = ((XSDNamedComponent)n1).getName();
            String s2 = ((XSDNamedComponent)n2).getName();
            if (s1 == null ? s1 != s2 : !s1.equals(s2)) break;
        }
        return n1 == null && n2 == null;
    }

    protected void removeDuplicateEClassifier(EClassifier eClassifier, XSDTypeDefinition xsdTypeDefinition) {
        EClassifier nextEClassifier;
        EPackage ePackage = eClassifier.getEPackage();
        EList eClassifiers = ePackage.getEClassifiers();
        String name = eClassifier.getName();
        int size = eClassifiers.size();
        int index = eClassifiers.indexOf(eClassifier);
        while (++index < size && name.equals((nextEClassifier = (EClassifier)eClassifiers.get(index)).getName())) {
            XSDTypeDefinition nextXSDTypeDefinition;
            if (!this.extendedMetaData.getName(eClassifier).equals(this.extendedMetaData.getName(nextEClassifier)) || !this.sameType(nextXSDTypeDefinition = this.getXSDTypeDefinition(nextEClassifier), xsdTypeDefinition)) continue;
            eClassifiers.remove(index);
            this.updateReferences((EObject)nextEClassifier, (EObject)eClassifier);
            break;
        }
    }

    protected void removeDuplicateDocumentRootFeature(EClass eClass, EStructuralFeature eStructuralFeature) {
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        int last = eStructuralFeatures.size() - 1;
        String name = this.extendedMetaData.getName(eStructuralFeature);
        for (int index = 0; index < last; ++index) {
            EStructuralFeature otherEStructuralFeature = (EStructuralFeature)eStructuralFeatures.get(index);
            if (!name.equals(this.extendedMetaData.getName(otherEStructuralFeature)) || otherEStructuralFeature.eClass() != eStructuralFeature.eClass()) continue;
            eStructuralFeatures.remove(index);
            this.updateReferences((EObject)otherEStructuralFeature, (EObject)eStructuralFeature);
            break;
        }
    }

    public EClass computeEClass(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        String aliasNames;
        EClassifier eclassifier;
        if (xsdComplexTypeDefinition == null) {
            return super.computeEClass(xsdComplexTypeDefinition);
        }
        EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(xsdComplexTypeDefinition.getTargetNamespace());
        if (ePackage != null && TypeHelperImpl.getBuiltInModels().contains(ePackage) && (eclassifier = ePackage.getEClassifier(xsdComplexTypeDefinition.getName())) != null) {
            return (EClass)eclassifier;
        }
        EClass eClass = super.computeEClass(xsdComplexTypeDefinition);
        if (this.replaceConflictingTypes) {
            this.removeDuplicateEClassifier((EClassifier)eClass, (XSDTypeDefinition)xsdComplexTypeDefinition);
        }
        if ((aliasNames = this.getEcoreAttribute(xsdComplexTypeDefinition.getElement(), "aliasName")) != null) {
            SDOExtendedMetaData.INSTANCE.setAliasNames((EModelElement)eClass, aliasNames);
        }
        return eClass;
    }

    protected EClassifier computeEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        EClassifier eclassifier;
        if (xsdTypeDefinition == null) {
            return super.computeEClassifier(xsdTypeDefinition);
        }
        EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(xsdTypeDefinition.getTargetNamespace());
        if (ePackage != null && TypeHelperImpl.getBuiltInModels().contains(ePackage) && (eclassifier = ePackage.getEClassifier(xsdTypeDefinition.getName())) != null) {
            return eclassifier;
        }
        eclassifier = super.computeEClassifier(xsdTypeDefinition);
        EClassifier etype = (EClassifier)this.typeToTypeObjectMap.get(eclassifier);
        String aliasNames = this.getEcoreAttribute(xsdTypeDefinition.getElement(), "aliasName");
        if (aliasNames != null) {
            SDOExtendedMetaData.INSTANCE.setAliasNames((EModelElement)eclassifier, aliasNames);
            if (etype != null) {
                SDOExtendedMetaData.INSTANCE.setAliasNames((EModelElement)etype, aliasNames);
            }
        }
        return eclassifier;
    }

    protected EDataType computeEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        String aliasNames;
        EClassifier eclassifier;
        if (xsdSimpleTypeDefinition == null) {
            return super.computeEDataType(xsdSimpleTypeDefinition);
        }
        EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(xsdSimpleTypeDefinition.getTargetNamespace());
        if (ePackage != null && TypeHelperImpl.getBuiltInModels().contains(ePackage) && (eclassifier = ePackage.getEClassifier(xsdSimpleTypeDefinition.getName())) != null) {
            return (EDataType)eclassifier;
        }
        EDataType eDataType = super.computeEDataType(xsdSimpleTypeDefinition);
        if (this.replaceConflictingTypes) {
            this.removeDuplicateEClassifier((EClassifier)eDataType, (XSDTypeDefinition)xsdSimpleTypeDefinition);
        }
        if ((aliasNames = this.getEcoreAttribute(xsdSimpleTypeDefinition.getElement(), "aliasName")) != null) {
            SDOExtendedMetaData.INSTANCE.setAliasNames((EModelElement)eDataType, aliasNames);
        }
        return eDataType;
    }

    protected EEnum computeEEnum(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        return null;
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        String aliasNames;
        XSDTerm xsdTerm;
        EStructuralFeature feature = super.createFeature(eClass, name, type, xsdComponent, minOccurs, maxOccurs);
        if (xsdComponent instanceof XSDParticle && (xsdTerm = ((XSDParticle)xsdComponent).getTerm()) instanceof XSDElementDeclaration && ((XSDElementDeclaration)xsdTerm).isNillable()) {
            EcoreUtil.setAnnotation((EModelElement)feature, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"nillable", (String)"true");
        }
        if (feature instanceof EReference) {
            XSDTerm xsdTerm2;
            EReference eReference = (EReference)feature;
            if (xsdComponent != null && xsdComponent instanceof XSDParticle && (xsdTerm2 = ((XSDParticle)xsdComponent).getTerm()) instanceof XSDElementDeclaration) {
                XSDTypeDefinition elementTypeDefinition = this.getEffectiveTypeDefinition(xsdComponent, (XSDFeature)((XSDElementDeclaration)xsdTerm2));
                EClassifier eClassifier = this.getEClassifier(elementTypeDefinition);
                if (elementTypeDefinition instanceof XSDSimpleTypeDefinition && eClassifier instanceof EClass) {
                    eReference.setContainment(true);
                }
            }
        }
        feature.setName(name);
        if (this.replaceConflictingTypes && "".equals(this.extendedMetaData.getName((EClassifier)eClass))) {
            this.removeDuplicateDocumentRootFeature(eClass, feature);
        }
        if (xsdComponent != null && (aliasNames = this.getEcoreAttribute(xsdComponent.getElement(), "aliasName")) != null) {
            SDOExtendedMetaData.INSTANCE.setAliasNames((EModelElement)feature, aliasNames);
        }
        return feature;
    }

    protected String getInstanceClassName(XSDTypeDefinition typeDefinition, EDataType baseEDataType) {
        String name = this.getEcoreAttribute((XSDConcreteComponent)typeDefinition, "extendedInstanceClass");
        return name != null ? name : super.getInstanceClassName(typeDefinition, baseEDataType);
    }

    protected String getEcoreAttribute(Element element, String attribute) {
        String sdoAttribute = null;
        if ("name".equals(attribute)) {
            sdoAttribute = "name";
        } else if ("opposite".equals(attribute)) {
            sdoAttribute = "oppositeProperty";
        } else if ("mixed".equals(attribute)) {
            sdoAttribute = "sequence";
        } else if ("string".equals(attribute)) {
            sdoAttribute = "string";
        } else if ("changeable".equals(attribute)) {
            sdoAttribute = "readOnly";
        } else if ("aliasName".equals(attribute)) {
            sdoAttribute = "aliasName";
        }
        if (sdoAttribute != null) {
            String value;
            String string = value = element != null && element.hasAttributeNS("commonj.sdo/xml", sdoAttribute) ? element.getAttributeNS("commonj.sdo/xml", sdoAttribute) : null;
            if ("changeable".equals(attribute)) {
                if ("true".equals(value)) {
                    value = "false";
                } else if ("false".equals(value)) {
                    value = "true";
                }
            }
            return value;
        }
        if ("package".equals(attribute)) {
            sdoAttribute = "package";
        } else if ("instanceClass".equals(attribute)) {
            sdoAttribute = "instanceClass";
        } else if ("extendedInstanceClass".equals(attribute)) {
            sdoAttribute = "extendedInstanceClass";
        } else if ("nestedInterfaces".equals(attribute)) {
            sdoAttribute = "nestedInterfaces";
        }
        if (sdoAttribute != null) {
            return element != null && element.hasAttributeNS("commonj.sdo/java", sdoAttribute) ? element.getAttributeNS("commonj.sdo/java", sdoAttribute) : null;
        }
        return super.getEcoreAttribute(element, attribute);
    }

    protected XSDTypeDefinition getEcoreTypeQNameAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        if (xsdConcreteComponent == null) {
            return null;
        }
        String sdoAttribute = null;
        if ("reference".equals(attribute)) {
            sdoAttribute = "propertyType";
        }
        if ("dataType".equals(attribute)) {
            sdoAttribute = "dataType";
        }
        if (sdoAttribute != null) {
            Element element = xsdConcreteComponent.getElement();
            return element == null ? null : this.getEcoreTypeQNameAttribute(xsdConcreteComponent, element, "commonj.sdo/xml", sdoAttribute);
        }
        return super.getEcoreTypeQNameAttribute(xsdConcreteComponent, attribute);
    }

    protected String validName(String name, int casing, String prefix) {
        return name;
    }

    protected String validAliasName(XSDTypeDefinition xsdTypeDefinition, boolean isUpperCase) {
        return this.getAliasName((XSDNamedComponent)xsdTypeDefinition);
    }

    protected String getAliasName(XSDNamedComponent xsdNamedComponent) {
        XSDConcreteComponent container;
        String result = xsdNamedComponent.getName();
        if (result == null && (container = xsdNamedComponent.getContainer()) instanceof XSDNamedComponent) {
            result = this.getAliasName((XSDNamedComponent)container);
            if (container instanceof XSDTypeDefinition) {
                result = "_" + result;
            }
        }
        return result;
    }

    protected XSDTypeDefinition getEffectiveTypeDefinition(XSDComponent xsdComponent, XSDFeature xsdFeature) {
        if (xsdFeature == null) {
            return super.getEffectiveTypeDefinition(xsdComponent, xsdFeature);
        }
        XSDTypeDefinition typeDef = this.getEcoreTypeQNameAttribute((XSDConcreteComponent)xsdComponent, "dataType");
        String isString = this.getEcoreAttribute((XSDConcreteComponent)xsdComponent, (XSDConcreteComponent)xsdFeature, "string");
        if ("true".equalsIgnoreCase(isString)) {
            typeDef = xsdFeature.resolveSimpleTypeDefinition(this.rootSchema.getSchemaForSchemaNamespace(), "string");
        }
        if (typeDef == null) {
            typeDef = xsdFeature.getType();
        }
        return typeDef;
    }

    public String qualifiedPackageName(String namespace) {
        return SDOXSDEcoreBuilder.getDefaultPackageName(namespace);
    }

    public static String uncapNameStatic(String name) {
        int i;
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        for (i = 0; i < name.length() && name.charAt(i) != lowerName.charAt(i); ++i) {
        }
        if (i > 1 && i < name.length() && !Character.isDigit(name.charAt(i))) {
            --i;
        }
        return name.substring(0, i).toLowerCase() + name.substring(i);
    }

    protected static String validNameStatic(String name, int casing, String prefix) {
        List parsedName = SDOXSDEcoreBuilder.parseNameStatic(name, '_');
        StringBuffer result = new StringBuffer();
        Iterator i = parsedName.iterator();
        while (i.hasNext()) {
            String nameComponent = (String)i.next();
            if (nameComponent.length() <= 0) continue;
            if (result.length() > 0 || casing == 1) {
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
                continue;
            }
            result.append(nameComponent);
        }
        return result.length() == 0 ? prefix : (Character.isJavaIdentifierStart(result.charAt(0)) ? (casing == 2 ? SDOXSDEcoreBuilder.uncapNameStatic(result.toString()) : result.toString()) : prefix + result);
    }

    protected static List parseNameStatic(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuffer currentWord = new StringBuffer();
            boolean lastIsLower = false;
            int length = sourceName.length();
            for (int index = 0; index < length; ++index) {
                char curChar = sourceName.charAt(index);
                if (!Character.isJavaIdentifierPart(curChar)) {
                    curChar = separator;
                }
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar == separator) continue;
                currentWord.append(curChar);
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public static String getDefaultPackageName(String targetNamespace) {
        List parsedName;
        if (targetNamespace == null) {
            return null;
        }
        URI uri = URI.createURI((String)targetNamespace);
        if (uri.isHierarchical()) {
            String host = uri.host();
            if (host != null && host.startsWith("www.")) {
                host = host.substring(4);
            }
            parsedName = SDOXSDEcoreBuilder.parseNameStatic(host, '.');
            Collections.reverse(parsedName);
            if (!parsedName.isEmpty()) {
                parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
            }
            parsedName.addAll(SDOXSDEcoreBuilder.parseNameStatic(uri.trimFileExtension().path(), '/'));
        } else {
            String opaquePart = uri.opaquePart();
            int index = opaquePart.indexOf(":");
            if (index != -1 && "urn".equalsIgnoreCase(uri.scheme())) {
                parsedName = SDOXSDEcoreBuilder.parseNameStatic(opaquePart.substring(0, index), '-');
                if (parsedName.size() > 0 && DOMAINS.contains(parsedName.get(parsedName.size() - 1))) {
                    Collections.reverse(parsedName);
                    parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
                }
                parsedName.addAll(SDOXSDEcoreBuilder.parseNameStatic(opaquePart.substring(index + 1), '/'));
            } else {
                parsedName = SDOXSDEcoreBuilder.parseNameStatic(opaquePart, '/');
            }
        }
        StringBuffer qualifiedPackageName = new StringBuffer();
        Iterator i = parsedName.iterator();
        while (i.hasNext()) {
            String packageName = (String)i.next();
            if (packageName.length() <= 0) continue;
            if (qualifiedPackageName.length() > 0) {
                qualifiedPackageName.append('.');
            }
            qualifiedPackageName.append(SDOXSDEcoreBuilder.validNameStatic(packageName, 2, "_"));
        }
        return qualifiedPackageName.toString().toLowerCase();
    }

    private XSDSchema loadEPackage(EPackage ePackage) {
        XSDSchema ePackageXSDSchema = null;
        XSDEcoreSchemaBuilder schemaBuilder = new XSDEcoreSchemaBuilder(this.extendedMetaData);
        ePackageXSDSchema = schemaBuilder.getSchema(ePackage);
        this.xsdComponentToEModelElementMap.putAll(schemaBuilder.getXSDComponentToEModelElementMap());
        this.targetNamespaceToEPackageMap.put(ePackage.getNsURI(), ePackage);
        this.populateTypeToTypeObjectMap(ePackage);
        this.xsdSchemas.add(ePackageXSDSchema);
        return ePackageXSDSchema;
    }

    class XSDSchemaAdapterFactoryImpl
    extends AdapterFactoryImpl {
        protected SchemaLocator schemaLocator = new SchemaLocator();

        XSDSchemaAdapterFactoryImpl() {
        }

        public boolean isFactoryForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocator == null ? (class$org$eclipse$xsd$util$XSDSchemaLocator = SDOXSDEcoreBuilder.class$("org.eclipse.xsd.util.XSDSchemaLocator")) : class$org$eclipse$xsd$util$XSDSchemaLocator);
        }

        public Adapter adaptNew(Notifier target, Object type) {
            return this.schemaLocator;
        }

        class SchemaLocator
        extends XSDResourceImpl.SchemaLocator {
            SchemaLocator() {
            }

            public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocation) {
                EPackage ePackage;
                XSDSchema schema;
                if (SDOXSDEcoreBuilder.this.targetNamespaceToEPackageMap.containsKey(namespaceURI)) {
                    Iterator iter = SDOXSDEcoreBuilder.this.xsdSchemas.iterator();
                    while (iter.hasNext()) {
                        schema = (XSDSchema)iter.next();
                        String targetNamespace = schema.getTargetNamespace();
                        if (targetNamespace == null || !targetNamespace.equals(namespaceURI)) continue;
                        return schema;
                    }
                }
                if (namespaceURI != null && !namespaceURI.equals(xsdSchema.getTargetNamespace()) && (ePackage = SDOXSDEcoreBuilder.this.extendedMetaData.getPackage(namespaceURI)) != null) {
                    schema = SDOXSDEcoreBuilder.this.loadEPackage(ePackage);
                    return schema;
                }
                return super.locateSchema(xsdSchema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocation);
            }
        }
    }

    private static class XSDEcoreSchemaBuilder
    extends EcoreSchemaBuilder {
        public XSDEcoreSchemaBuilder(ExtendedMetaData extendedMetaData) {
            super(extendedMetaData);
        }

        public Map getXSDComponentToEModelElementMap() {
            return this.xsdComponentToEModelElementMap;
        }
    }
}

