/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.codegen;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.PrintWriter;
import java.util.List;
import org.apache.tuscany.sdo.SDOTypeVisitor;

public class JavaInterfaceGenerator
implements SDOTypeVisitor {
    private final PrintWriter writer;

    private static String canonicalize(String className) {
        if (className == null) {
            return "";
        }
        if (className.charAt(0) != '[') {
            return className;
        }
        boolean invalidClassName = false;
        int nestLevel = 1;
        StringBuffer sb = new StringBuffer();
        try {
            while (className.charAt(nestLevel) == '[') {
                ++nestLevel;
            }
            char typeChar = className.charAt(nestLevel);
            int end = nestLevel;
            switch (typeChar) {
                case 'L': {
                    end = className.length() - 1;
                    if (className.charAt(end) != ';') {
                        invalidClassName = true;
                        break;
                    }
                    sb.append(className.substring(nestLevel + 1, end));
                    break;
                }
                case 'Z': {
                    sb.append("boolean");
                    break;
                }
                case 'B': {
                    sb.append("byte");
                    break;
                }
                case 'C': {
                    sb.append("char");
                    break;
                }
                case 'D': {
                    sb.append("double");
                    break;
                }
                case 'F': {
                    sb.append("float");
                    break;
                }
                case 'I': {
                    sb.append("int");
                    break;
                }
                case 'J': {
                    sb.append("long");
                    break;
                }
                case 'S': {
                    sb.append("short");
                    break;
                }
                default: {
                    invalidClassName = true;
                }
            }
            if (end != className.length() - 1) {
                invalidClassName = true;
            } else {
                for (int i = 0; i < nestLevel; ++i) {
                    sb.append("[]");
                }
            }
        }
        catch (Exception e) {
            invalidClassName = true;
        }
        if (invalidClassName) {
            System.err.println("unable to canonicalize class name: " + className);
            return className;
        }
        return sb.toString();
    }

    public JavaInterfaceGenerator(PrintWriter writer) {
        this.writer = writer;
    }

    public void visitType(Type type) {
        String name = type.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            this.writer.print("package ");
            this.writer.print(name.substring(0, lastDot));
            this.writer.println(';');
            this.writer.println();
            name = name.substring(lastDot + 1);
        } else {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        this.writer.print("public interface ");
        this.writer.print(name);
        List baseTypes = type.getBaseTypes();
        for (int i = 0; i < baseTypes.size(); ++i) {
            Type baseType = (Type)baseTypes.get(i);
            if (i == 0) {
                this.writer.print(" extends ");
            } else {
                this.writer.print(", ");
            }
            this.writer.print(baseType.getInstanceClass().getName());
        }
        this.writer.println(" {");
    }

    public void visitProperty(Property property) {
        String name = property.getName();
        String propertyName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String javaType = JavaInterfaceGenerator.canonicalize(property.getType().getInstanceClass().getName());
        if (!property.isMany()) {
            this.writer.print("    ");
            this.writer.print(javaType);
            this.writer.print("boolean".equals(javaType) ? " is" : " get");
            this.writer.print(propertyName);
            this.writer.println("();");
            if (!property.isReadOnly()) {
                this.writer.print("    void set");
                this.writer.print(propertyName);
                this.writer.print('(');
                this.writer.print(javaType);
                this.writer.println(" value);");
            }
        } else {
            this.writer.print("    java.util.List get");
            this.writer.print(propertyName);
            this.writer.println("();");
        }
    }

    public void visitEnd() {
        this.writer.println('}');
        this.writer.flush();
    }
}

