/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public class XMLDocumentHelper {
    public static final QName WSDL11 = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    public static final QName WSDL20 = new QName("http://www.w3.org/ns/wsdl", "description");
    protected static final int BUFFER_SIZE = 256;

    public static String getEncoding(InputStream is) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        byte[] buffer = XMLDocumentHelper.readBuffer(is);
        return XMLDocumentHelper.getXMLEncoding(buffer);
    }

    protected static String getXMLEncoding(byte[] bytes) {
        int lastQuoteIndex;
        String javaEncoding = null;
        if (bytes.length >= 4) {
            if (bytes[0] == -2 && bytes[1] == -1 || bytes[0] == 0 && bytes[1] == 60) {
                javaEncoding = "UnicodeBig";
            } else if (bytes[0] == -1 && bytes[1] == -2 || bytes[0] == 60 && bytes[1] == 0) {
                javaEncoding = "UnicodeLittle";
            } else if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                javaEncoding = "UTF8";
            }
        }
        String header = null;
        try {
            header = javaEncoding != null ? new String(bytes, 0, bytes.length, javaEncoding) : new String(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (!header.startsWith("<?xml")) {
            return "UTF-8";
        }
        int endOfXMLPI = header.indexOf("?>");
        int encodingIndex = header.indexOf("encoding", 6);
        if (encodingIndex == -1 || encodingIndex > endOfXMLPI) {
            return "UTF-8";
        }
        int firstQuoteIndex = header.indexOf("\"", encodingIndex);
        if (firstQuoteIndex == -1 || firstQuoteIndex > endOfXMLPI) {
            firstQuoteIndex = header.indexOf("'", encodingIndex);
            lastQuoteIndex = header.indexOf("'", firstQuoteIndex + 1);
        } else {
            lastQuoteIndex = header.indexOf("\"", firstQuoteIndex + 1);
        }
        return header.substring(firstQuoteIndex + 1, lastQuoteIndex);
    }

    protected static byte[] readBuffer(InputStream is) throws IOException {
        int bytesRead;
        if (is.available() == 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[256];
        is.mark(256);
        int totalBytesRead = bytesRead = is.read(buffer, 0, 256);
        while (bytesRead != -1 && totalBytesRead < 256) {
            bytesRead = is.read(buffer, totalBytesRead, 256 - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < 256) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            smallerBuffer = buffer;
        }
        is.reset();
        return buffer;
    }

    public static InputSource getInputSource(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream is = connection.getInputStream();
        return XMLDocumentHelper.getInputSource(url, is);
    }

    public static InputSource getInputSource(URL url, InputStream is) throws IOException {
        is = new BufferedInputStream(is);
        String encoding = XMLDocumentHelper.getEncoding(is);
        InputSource inputSource = new InputSource(is);
        inputSource.setEncoding(encoding);
        inputSource.setSystemId(url.toString());
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTargetNamespace(URL doc, QName element, boolean rootOnly, String attribute, XMLInputFactory inputFactory) throws IOException, XMLStreamException {
        if (attribute == null) {
            attribute = "targetNamespace";
        }
        URLConnection connection = doc.openConnection();
        connection.setUseCaches(false);
        InputStream is = connection.getInputStream();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(is);
            int eventType = reader.getEventType();
            while (true) {
                if (eventType == 1) {
                    if (element.equals(reader.getName())) {
                        String string = reader.getAttributeValue(null, attribute);
                        return string;
                    }
                    if (rootOnly) {
                        String string = null;
                        return string;
                    }
                }
                if (!reader.hasNext()) break;
                eventType = reader.next();
            }
            String string = null;
            return string;
        }
        finally {
            is.close();
        }
    }
}

