/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.web.javascript.dojo;

import java.net.URI;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.implementation.widget.javascript.WidgetImplementationJavascriptProvider;
import org.apache.tuscany.sca.web.javascript.dojo.DojoResourceServlet;

public class DojoWidgetJavascriptProvider
implements WidgetImplementationJavascriptProvider {
    private static final Logger logger = Logger.getLogger(DojoWidgetJavascriptProvider.class.getName());
    private static final String dojoBaseUri = URI.create("/dojo").toString();
    private static final String dojoUri = URI.create("/dojo/*").toString();
    private static final String dojoxBaseUri = URI.create("/dojox").toString();
    private static final String dojoxUri = URI.create("/dojox/*").toString();
    private static final String dijitBaseUri = URI.create("/dijit").toString();
    private static final String dijitUri = URI.create("/dijit/*").toString();
    private static final String tuscanyBaseUri = URI.create("/tuscany").toString();
    private static final String tuscanyUri = URI.create("/tuscany/*").toString();
    private static int counter = 0;
    private ServletHost servletHost;

    public DojoWidgetJavascriptProvider(ExtensionPointRegistry registry) {
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)registry);
    }

    public void start() {
        DojoResourceServlet resourceServlet;
        DojoResourceServlet baseResourceServlet;
        if (this.servletHost == null) {
            throw new IllegalStateException("Can't find ServletHost reference !");
        }
        Servlet servlet = null;
        servlet = this.servletHost.getServletMapping(dojoBaseUri);
        if (servlet == null) {
            try {
                baseResourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dojoBaseUri, (Servlet)baseResourceServlet);
                resourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dojoUri, (Servlet)resourceServlet);
            }
            catch (ServletMappingException me) {
                logger.warning("Dojo already registered at :" + dojoBaseUri);
            }
        }
        if ((servlet = this.servletHost.getServletMapping(dojoxBaseUri)) == null) {
            try {
                baseResourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dojoxBaseUri, (Servlet)baseResourceServlet);
                resourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dojoxUri, (Servlet)resourceServlet);
            }
            catch (ServletMappingException me) {
                logger.warning("Dojox already registered at :" + dojoxBaseUri);
            }
        }
        if ((servlet = this.servletHost.getServletMapping(dijitBaseUri)) == null) {
            try {
                baseResourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dijitBaseUri, (Servlet)baseResourceServlet);
                resourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(dijitUri, (Servlet)resourceServlet);
            }
            catch (ServletMappingException me) {
                logger.warning("Dijit already registered at :" + dijitBaseUri);
            }
        }
        if ((servlet = this.servletHost.getServletMapping(tuscanyBaseUri)) == null) {
            try {
                baseResourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(tuscanyBaseUri, (Servlet)baseResourceServlet);
                resourceServlet = new DojoResourceServlet();
                this.servletHost.addServletMapping(tuscanyUri, (Servlet)resourceServlet);
            }
            catch (ServletMappingException me) {
                logger.warning("Tuscany dojo extensions already registered at :" + tuscanyBaseUri);
            }
        }
        logger.info("Registered Dojo and Tuscany Dojo extensions (counter=" + ++counter + ")");
    }

    public void stop() {
        Servlet servlet;
        if (counter > 0) {
            --counter;
            logger.info("Unregistering Dojo and Tuscany Dojo extensions (counter=" + counter + ")");
        }
        if ((servlet = this.servletHost.getServletMapping(dojoBaseUri)) != null && counter == 0) {
            this.servletHost.removeServletMapping(dojoBaseUri);
            this.servletHost.removeServletMapping(dojoUri);
            this.servletHost.removeServletMapping(dojoxBaseUri);
            this.servletHost.removeServletMapping(dojoxUri);
            this.servletHost.removeServletMapping(tuscanyBaseUri);
            this.servletHost.removeServletMapping(tuscanyUri);
        }
        this.servletHost = null;
    }
}

