/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;

public class JaasAuthenticationPolicyProcessor
implements StAXArtifactProcessor<JaasAuthenticationPolicy> {
    private static final QName JAAS_AUTHENTICATION_POLICY_QNAME = JaasAuthenticationPolicy.NAME;
    private static final String callbackHandler = "callbackHandler";
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    public static final QName CALLBACK_HANDLER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "callbackHandler");
    public static final QName CONFIGURATION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "configurationName");

    public QName getArtifactType() {
        return JAAS_AUTHENTICATION_POLICY_QNAME;
    }

    public JaasAuthenticationPolicyProcessor(FactoryExtensionPoint modelFactories) {
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "policy-security-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public JaasAuthenticationPolicy read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        JaasAuthenticationPolicy policy = new JaasAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    String configurationName;
                    String callbackHandlerClassName;
                    name = reader.getName();
                    if (name.equals(CALLBACK_HANDLER_QNAME) && (callbackHandlerClassName = reader.getElementText()) != null) {
                        policy.setCallbackHandlerClassName(callbackHandlerClassName.trim());
                    }
                    if (!name.equals(CONFIGURATION_QNAME) || (configurationName = reader.getElementText()) == null) break;
                    policy.setConfigurationName(configurationName.trim());
                }
            }
            if (event == 2 && JAAS_AUTHENTICATION_POLICY_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(JaasAuthenticationPolicy policy, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, JAAS_AUTHENTICATION_POLICY_QNAME.getLocalPart(), JAAS_AUTHENTICATION_POLICY_QNAME.getNamespaceURI());
        writer.writeNamespace("tuscany", SCA10_TUSCANY_NS);
        writer.writeEndElement();
    }

    public Class<JaasAuthenticationPolicy> getModelType() {
        return JaasAuthenticationPolicy.class;
    }

    public void resolve(JaasAuthenticationPolicy policy, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (policy.getCallbackHandlerClassName() != null) {
            ClassReference classReference = new ClassReference(policy.getCallbackHandlerClassName());
            Class callbackClass = (classReference = (ClassReference)resolver.resolveModel(ClassReference.class, (Object)classReference, context)).getJavaClass();
            if (callbackClass == null) {
                this.error(context.getMonitor(), "ClassNotFoundException", resolver, policy.getCallbackHandlerClassName());
            } else {
                policy.setCallbackHandlerClass(callbackClass);
                policy.setUnresolved(false);
            }
        }
    }
}

