/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;

public class BasicAuthenticationPolicyProcessor
implements StAXArtifactProcessor<BasicAuthenticationPolicy> {
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";

    public QName getArtifactType() {
        return BasicAuthenticationPolicy.BASIC_AUTHENTICATION_POLICY_QNAME;
    }

    public BasicAuthenticationPolicyProcessor(FactoryExtensionPoint modelFactories) {
    }

    public BasicAuthenticationPolicy read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        BasicAuthenticationPolicy policy = new BasicAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (name.equals(this.getArtifactType())) break;
                    if ("userName".equals(name.getLocalPart())) {
                        policy.setUserName(reader.getElementText());
                        break;
                    }
                    if (!"password".equals(name.getLocalPart())) break;
                    policy.setPassword(reader.getElementText());
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(BasicAuthenticationPolicy policy, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", SCA10_TUSCANY_NS);
        if (policy.getUserName() != null) {
            writer.writeStartElement(prefix, "userName", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getUserName());
            writer.writeEndElement();
        }
        if (policy.getPassword() != null) {
            writer.writeStartElement(prefix, "password", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getPassword());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Class<BasicAuthenticationPolicy> getModelType() {
        return BasicAuthenticationPolicy.class;
    }

    public void resolve(BasicAuthenticationPolicy arg0, ModelResolver arg1, ProcessorContext context) throws ContributionResolveException {
    }
}

