/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.extensibility.NodeActivator;
import org.apache.tuscany.sca.node.extensibility.NodeActivatorExtensionPoint;
import org.apache.tuscany.sca.node.extensibility.NodeExtension;
import org.apache.tuscany.sca.node.impl.NodeFactoryImpl;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class NodeImpl
implements Node,
NodeExtension {
    private static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    private ProxyFactory proxyFactory;
    private CompositeActivator compositeActivator;
    private CompositeContext compositeContext;
    private Composite domainComposite;
    private NodeConfiguration configuration;
    private NodeFactoryImpl nodeFactory;
    private List<Contribution> contributions;
    private NodeActivatorExtensionPoint nodeActivators;

    public NodeImpl(NodeFactoryImpl nodeFactory, NodeConfiguration configuration) {
        this.configuration = configuration;
        this.nodeFactory = nodeFactory;
        this.nodeActivators = (NodeActivatorExtensionPoint)nodeFactory.getExtensionPointRegistry().getExtensionPoint(NodeActivatorExtensionPoint.class);
    }

    public NodeImpl(NodeFactoryImpl manager, NodeConfiguration configuration, List<Contribution> contributions) {
        this.configuration = configuration;
        this.nodeFactory = manager;
        this.nodeActivators = (NodeActivatorExtensionPoint)this.nodeFactory.getExtensionPointRegistry().getExtensionPoint(NodeActivatorExtensionPoint.class);
        this.contributions = new ArrayList<Contribution>(contributions);
    }

    public String getURI() {
        return this.getConfiguration().getURI();
    }

    public String getDomainURI() {
        return this.getConfiguration().getDomainURI();
    }

    public Node start() {
        logger.log(this.nodeFactory.quietLogging ? Level.FINE : Level.INFO, "Starting node: " + this.configuration.getURI() + " domain: " + this.configuration.getDomainURI());
        try {
            this.load();
            this.proxyFactory = this.nodeFactory.proxyFactory;
            UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.nodeFactory.registry.getExtensionPoint(UtilityExtensionPoint.class);
            this.compositeActivator = (CompositeActivator)utilities.getUtility(CompositeActivator.class);
            ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance((ExtensionPointRegistry)this.nodeFactory.registry);
            DomainRegistry domainRegistry = domainRegistryFactory.getEndpointRegistry(this.configuration.getDomainRegistryURI(), this.configuration.getDomainURI());
            this.compositeContext = new CompositeContext(this.nodeFactory.registry, domainRegistry, this.domainComposite, this.configuration.getDomainURI(), this.configuration.getURI(), this.nodeFactory.getDeployer().getSystemDefinitions());
            this.compositeContext.getAttributes().putAll(this.configuration.getAttributes());
            if (!domainRegistry.isDistributed()) {
                for (Endpoint e : this.configuration.getEndpointDescriptions()) {
                    domainRegistry.addEndpoint(e);
                }
            }
            this.compositeActivator.activate(this.compositeContext, this.domainComposite);
            this.compositeActivator.start(this.compositeContext, this.domainComposite);
            for (NodeActivator activator : this.nodeActivators.getNodeActivators()) {
                activator.nodeStarted((Node)this);
            }
            return this;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Throwable {
        this.nodeFactory.init();
        this.nodeFactory.addNode(this.configuration, this);
        Monitor monitor = this.nodeFactory.monitorFactory.createMonitor();
        ProcessorContext context = new ProcessorContext(monitor);
        Monitor tcm = this.nodeFactory.monitorFactory.setContextMonitor(monitor);
        try {
            if (this.contributions == null) {
                this.contributions = this.nodeFactory.loadContributions(this.configuration, context);
            }
            if (this.domainComposite == null) {
                this.domainComposite = this.nodeFactory.configureNode(this.configuration, this.contributions, context);
            }
        }
        finally {
            this.nodeFactory.monitorFactory.setContextMonitor(tcm);
        }
    }

    public void stop() {
        logger.log(this.nodeFactory.quietLogging ? Level.FINE : Level.INFO, "Stopping node: " + this.configuration.getURI());
        try {
            DomainRegistry domainRegistry;
            if (this.compositeActivator == null) {
                return;
            }
            if (this.domainComposite != null) {
                this.compositeActivator.stop(this.compositeContext, this.domainComposite);
                this.compositeActivator.deactivate(this.domainComposite);
            }
            if (!(domainRegistry = this.compositeContext.getEndpointRegistry()).isDistributed()) {
                for (Endpoint e : this.configuration.getEndpointDescriptions()) {
                    domainRegistry.removeEndpoint(e);
                }
            }
            this.nodeFactory.removeNode(this.configuration);
            for (NodeActivator activator : this.nodeActivators.getNodeActivators()) {
                activator.nodeStopped((Node)this);
            }
            ThreadMessageContext.removeMessageContext();
        }
        catch (ActivationException e) {
            throw new IllegalStateException(e);
        }
    }

    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        return (R)this.proxyFactory.cast(target);
    }

    public <B> B getService(Class<B> businessInterface, String serviceName) {
        ServiceReference<B> serviceReference = this.getServiceReference(businessInterface, serviceName);
        if (serviceReference == null) {
            throw new ServiceRuntimeException("Service not found: " + serviceName);
        }
        return (B)serviceReference.getService();
    }

    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String name) {
        String componentName = null;
        String serviceName = null;
        if (name != null) {
            int i = name.indexOf(47);
            if (i != -1) {
                componentName = name.substring(0, i);
                serviceName = name.substring(i + 1);
            } else {
                componentName = name;
                serviceName = null;
            }
        }
        Component component = null;
        for (Component compositeComponent : this.domainComposite.getComponents()) {
            if (componentName == null) {
                for (ComponentService service : compositeComponent.getServices()) {
                    JavaInterface ji;
                    Interface intf = service.getInterfaceContract().getInterface();
                    if (!(intf instanceof JavaInterface) || (ji = (JavaInterface)intf).getJavaClass() != businessInterface) continue;
                    return ((RuntimeComponent)compositeComponent).getComponentContext().createSelfReference(businessInterface, service);
                }
            }
            if (!compositeComponent.getName().equals(componentName)) continue;
            component = compositeComponent;
            break;
        }
        if (component == null) {
            throw new ServiceUnavailableException("The service " + name + " has not been contributed to the domain");
        }
        return ((RuntimeComponent)component).getServiceReference(businessInterface, serviceName);
    }

    public NodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.nodeFactory.getExtensionPointRegistry();
    }

    public List<Endpoint> getServiceEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (this.compositeActivator != null && this.domainComposite != null) {
            for (Component component : this.domainComposite.getComponents()) {
                for (ComponentService service : component.getServices()) {
                    if (!(service instanceof RuntimeComponentService)) continue;
                    endpoints.addAll(((RuntimeComponentService)service).getEndpoints());
                }
            }
        }
        return endpoints;
    }

    public Composite getDomainComposite() {
        return this.domainComposite;
    }

    public String dumpDomainComposite() {
        StAXArtifactProcessorExtensionPoint xmlProcessors = (StAXArtifactProcessorExtensionPoint)this.getExtensionPointRegistry().getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor compositeProcessor = xmlProcessors.getProcessor(Composite.class);
        return this.writeComposite(this.getDomainComposite(), (StAXArtifactProcessor<Composite>)compositeProcessor);
    }

    private String writeComposite(Composite composite, StAXArtifactProcessor<Composite> compositeProcessor) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = (XMLOutputFactory)((FactoryExtensionPoint)this.nodeFactory.getExtensionPointRegistry().getExtensionPoint(FactoryExtensionPoint.class)).getFactory(XMLOutputFactory.class);
        try {
            XMLStreamWriter xmlStreamWriter = outputFactory.createXMLStreamWriter(bos);
            compositeProcessor.write((Object)composite, xmlStreamWriter, new ProcessorContext(this.nodeFactory.registry));
            xmlStreamWriter.flush();
        }
        catch (Exception ex) {
            return ex.toString();
        }
        String result = bos.toString();
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            result = result + "\n<!-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX -->\n" + this.writeComposite((Composite)component.getImplementation(), compositeProcessor);
        }
        return result;
    }

    public List<Contribution> getContributions() {
        return this.contributions;
    }

    public String getEndpointAddress(String serviceBindingName) {
        String bindingName;
        if (serviceBindingName == null) {
            throw new IllegalArgumentException("Service binding name cannot be null");
        }
        String[] parts = serviceBindingName.split("/");
        String componentName = parts[0];
        String serviceName = parts.length >= 2 ? parts[1] : null;
        String string = bindingName = parts.length >= 3 ? parts[2] : serviceName;
        if (this.domainComposite != null) {
            for (Component component : this.domainComposite.getComponents()) {
                if (!component.getName().equals(componentName)) continue;
                for (ComponentService service : component.getServices()) {
                    if (serviceName != null && !service.getName().equals(serviceName) || !(service instanceof RuntimeComponentService)) continue;
                    for (Endpoint ep : ((RuntimeComponentService)service).getEndpoints()) {
                        if (bindingName != null && !bindingName.equals(ep.getBinding().getName())) continue;
                        return ep.getDeployedURI();
                    }
                }
            }
        }
        return null;
    }
}

