/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.extensibility.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.extensibility.NodeActivator;
import org.apache.tuscany.sca.node.extensibility.NodeActivatorExtensionPoint;

public class DefaultNodeActivatorExtensionPoint
implements NodeActivatorExtensionPoint {
    private static final Logger logger = Logger.getLogger(DefaultNodeActivatorExtensionPoint.class.getName());
    private List<NodeActivator> activators = new ArrayList<NodeActivator>();
    private ExtensionPointRegistry registry;
    private boolean loadedActivators;

    public DefaultNodeActivatorExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public void addNodeActivator(NodeActivator activator) {
        this.activators.add(activator);
    }

    public void removeNodeActivator(NodeActivator activator) {
        this.activators.remove(activator);
    }

    public List<NodeActivator> getNodeActivators() {
        this.loadModuleActivators();
        return this.activators;
    }

    public void nodeStarted(Node node) {
        for (NodeActivator activator : this.activators) {
            activator.nodeStarted(node);
        }
    }

    public void nodeStopped(Node node) {
        for (NodeActivator activator : this.activators) {
            activator.nodeStopped(node);
        }
    }

    private synchronized void loadModuleActivators() {
        Collection activatorDeclarations;
        if (this.loadedActivators) {
            return;
        }
        try {
            activatorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(NodeActivator.class.getName(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration activatorDeclaration : activatorDeclarations) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading " + activatorDeclaration.getClassName());
            }
            NodeActivator activator = null;
            try {
                Class activatorClass = activatorDeclaration.loadClass();
                try {
                    activator = (NodeActivator)ServiceHelper.newInstance((Class)activatorClass, ExtensionPointRegistry.class, (Object)this.registry);
                }
                catch (NoSuchMethodException e) {
                    try {
                        activator = (NodeActivator)ServiceHelper.newInstance((Class)activatorClass, (Class[])new Class[]{ExtensionPointRegistry.class, Map.class}, (Object[])new Object[]{this.registry, activatorDeclaration.getAttributes()});
                    }
                    catch (NoSuchMethodException e1) {
                        activator = (NodeActivator)ServiceHelper.newInstance((Class)activatorClass);
                    }
                }
            }
            catch (Throwable e) {
                String optional = (String)activatorDeclaration.getAttributes().get("optional");
                if ("true".equalsIgnoreCase(optional)) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                throw new IllegalArgumentException(e);
            }
            this.addNodeActivator(activator);
        }
        this.loadedActivators = true;
    }
}

