/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.configuration.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.node.configuration.BindingConfiguration;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.DeploymentComposite;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfigurationFactory;

public class NodeConfigurationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NodeConfiguration> {
    private static final String SCA11_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    private static final QName NODE = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "node");
    private static final QName CONTRIBUTION = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "contribution");
    private static final QName BINDING = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "binding");
    private static final QName BASE_URI = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "baseURI");
    private static final QName DEPLOYMENT_COMPOSITE = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "deploymentComposite");
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName COMPOSITE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "composite");
    private StAXArtifactProcessor processor;
    private NodeConfigurationFactory nodeConfigurationFactory;
    private StAXHelper helper;

    public NodeConfigurationProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor processor) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.nodeConfigurationFactory = (NodeConfigurationFactory)modelFactories.getFactory(NodeConfigurationFactory.class);
        this.processor = processor;
        this.helper = StAXHelper.getInstance((ExtensionPointRegistry)registry);
    }

    public QName getArtifactType() {
        return NODE;
    }

    public Class<NodeConfiguration> getModelType() {
        return NodeConfiguration.class;
    }

    public NodeConfiguration read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        NodeConfiguration node = null;
        ContributionConfiguration contribution = null;
        DeploymentComposite composite = null;
        BindingConfiguration binding = null;
        block4: while (true) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    QName name = reader.getName();
                    if (NODE.equals(name)) {
                        node = this.nodeConfigurationFactory.createNodeConfiguration();
                        node.setURI(reader.getAttributeValue(null, "uri"));
                        node.setDomainURI(reader.getAttributeValue(null, "domain"));
                        node.setDomainRegistryURI(reader.getAttributeValue(null, "domainRegistry"));
                        break;
                    }
                    if (CONTRIBUTION.equals(name)) {
                        String dependentURIs;
                        contribution = this.nodeConfigurationFactory.createContributionConfiguration();
                        contribution.setURI(reader.getAttributeValue(null, "uri"));
                        contribution.setLocation(reader.getAttributeValue(null, "location"));
                        contribution.setMetaDataURL(reader.getAttributeValue(null, "metaDataURL"));
                        String startDeployables = reader.getAttributeValue(null, "startDeployables");
                        if (startDeployables != null) {
                            contribution.setStartDeployables(Boolean.parseBoolean(startDeployables));
                        }
                        if ((dependentURIs = reader.getAttributeValue(null, "dependentURIs")) != null) {
                            contribution.setDependentContributionURIs(Arrays.asList(dependentURIs.split(",")));
                        }
                        node.getContributions().add(contribution);
                        break;
                    }
                    if (BINDING.equals(name)) {
                        binding = this.nodeConfigurationFactory.createBindingConfiguration();
                        binding.setBindingType(this.getQName(reader, "name"));
                        String baseURIs = reader.getAttributeValue(null, "baseURIs");
                        if (baseURIs != null) {
                            StringTokenizer tokenizer = new StringTokenizer(baseURIs);
                            while (tokenizer.hasMoreTokens()) {
                                binding.getBaseURIs().add(tokenizer.nextToken());
                            }
                        }
                        node.getBindings().add(binding);
                        break;
                    }
                    if (DEPLOYMENT_COMPOSITE.equals(name)) {
                        composite = this.nodeConfigurationFactory.createDeploymentComposite();
                        composite.setLocation(reader.getAttributeValue(null, "location"));
                        if (contribution == null) break;
                        contribution.getDeploymentComposites().add(composite);
                        break;
                    }
                    if (BASE_URI.equals(name)) {
                        String baseURI = reader.getElementText();
                        if (baseURI == null || binding == null) continue block4;
                        baseURI = baseURI.trim();
                        binding.addBaseURI(baseURI);
                        continue block4;
                    }
                    if (COMPOSITE.equals(name)) {
                        StringWriter sw = new StringWriter();
                        XMLStreamWriter writer = this.helper.createXMLStreamWriter((Writer)sw);
                        this.helper.save(reader, writer);
                        composite.setContent(sw.toString());
                        break;
                    }
                    Object ext = this.processor.read(reader, context);
                    if (ext instanceof Endpoint) {
                        node.getEndpointDescriptions().add((Endpoint)ext);
                        break;
                    }
                    node.getExtensions().add(ext);
                    break;
                }
                case 2: {
                    QName name = reader.getName();
                    if (NODE.equals(name)) {
                        return node;
                    }
                    if (CONTRIBUTION.equals(name)) {
                        contribution = null;
                        break;
                    }
                    if (DEPLOYMENT_COMPOSITE.equals(name)) {
                        composite = null;
                        break;
                    }
                    if (!BINDING.equals(name)) break;
                    binding = null;
                }
            }
            if (!reader.hasNext()) break;
            reader.next();
        }
        return node;
    }

    public void resolve(NodeConfiguration node, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    public void write(NodeConfiguration node, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, NODE.getNamespaceURI(), NODE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("uri", node.getURI()), new BaseStAXArtifactProcessor.XAttr("domainRegistry", node.getDomainRegistryURI()), new BaseStAXArtifactProcessor.XAttr("domain", node.getDomainURI())});
        for (ContributionConfiguration c : node.getContributions()) {
            this.writeStart(writer, CONTRIBUTION.getNamespaceURI(), CONTRIBUTION.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("uri", c.getURI()), new BaseStAXArtifactProcessor.XAttr("location", c.getLocation())});
            for (DeploymentComposite dc : c.getDeploymentComposites()) {
                this.writeStart(writer, DEPLOYMENT_COMPOSITE.getNamespaceURI(), DEPLOYMENT_COMPOSITE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("location", dc.getLocation()), new BaseStAXArtifactProcessor.XAttr("contribution", dc.getContributionURI())});
                if (dc.getContent() != null) {
                    XMLStreamReader reader = this.helper.createXMLStreamReader((Reader)new StringReader(dc.getContent()));
                    reader.nextTag();
                    this.helper.save(reader, writer);
                    reader.close();
                }
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        for (BindingConfiguration b : node.getBindings()) {
            StringBuffer uris = new StringBuffer();
            for (String uri : b.getBaseURIs()) {
                uris.append(uri).append(' ');
            }
            if (uris.length() > 0) {
                uris.deleteCharAt(uris.length() - 1);
            } else {
                uris = null;
            }
            String baseURIs = uris == null ? null : uris.toString();
            this.writeStart(writer, BINDING.getNamespaceURI(), BINDING.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("name", b.getBindingType()), new BaseStAXArtifactProcessor.XAttr("baseURIs", baseURIs)});
            this.writeEnd(writer);
        }
        for (Object o : node.getExtensions()) {
            this.processor.write(o, writer, context);
        }
        this.writeEnd(writer);
    }
}

