/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.configuration.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfigurationFactory;

public class NodeConfigurationATOMProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NodeConfiguration> {
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final QName FEED_QNAME = new QName("http://www.w3.org/2005/Atom", "feed");
    private static final QName ENTRY_QNAME = new QName("http://www.w3.org/2005/Atom", "entry");
    private static final QName ID_QNAME = new QName("http://www.w3.org/2005/Atom", "id");
    private static final QName LINK_QNAME = new QName("http://www.w3.org/2005/Atom", "link");
    private static final QName CONTENT_QNAME = new QName("http://www.w3.org/2005/Atom", "content");
    private static final String HREF = "href";
    private NodeConfigurationFactory factory;

    public NodeConfigurationATOMProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = (NodeConfigurationFactory)modelFactories.getFactory(NodeConfigurationFactory.class);
    }

    public QName getArtifactType() {
        return null;
    }

    public Class<NodeConfiguration> getModelType() {
        return NodeConfiguration.class;
    }

    public NodeConfiguration read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        NodeConfiguration config = this.factory.createNodeConfiguration();
        ContributionConfiguration contribution = null;
        boolean id = false;
        QName name = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (ENTRY_QNAME.equals(name)) {
                        contribution = this.factory.createContributionConfiguration();
                        break;
                    }
                    if (ID_QNAME.equals(name)) {
                        id = true;
                        break;
                    }
                    if (LINK_QNAME.equals(name)) {
                        String href = this.getString(reader, HREF);
                        if (contribution == null) break;
                        contribution.setLocation(href);
                        break;
                    }
                    if (CONTENT_QNAME.equals(name) || !FEED_QNAME.equals(name)) break;
                    break;
                }
                case 4: {
                    if (!id || contribution == null) break;
                    contribution.setURI(reader.getText());
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (ENTRY_QNAME.equals(name)) {
                        if (contribution != null) {
                            config.getContributions().add(contribution);
                        }
                        contribution = null;
                        break;
                    }
                    if (ID_QNAME.equals(name)) {
                        id = false;
                        break;
                    }
                    if (!FEED_QNAME.equals(name)) break;
                    return config;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return config;
    }

    public void resolve(NodeConfiguration implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    public void write(NodeConfiguration implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
    }
}

