/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.xml.CompositeDocumentProcessor;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.contribution.service.util.FileHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.implementation.node.ConfiguredNodeImplementation;
import org.apache.tuscany.sca.implementation.node.NodeImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.node.SCAClient;
import org.apache.tuscany.sca.node.SCAContribution;
import org.apache.tuscany.sca.node.SCANode;
import org.apache.tuscany.sca.node.impl.RuntimeBootStrapper;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentContext;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
implements SCANode,
SCAClient {
    private static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    private String configurationName;
    private RuntimeBootStrapper runtime;
    private CompositeActivator compositeActivator;
    private XMLInputFactory inputFactory;
    private ModelFactoryExtensionPoint modelFactories;
    private StAXArtifactProcessorExtensionPoint artifactProcessors;
    private URLArtifactProcessorExtensionPoint documentProcessors;
    private Monitor monitor;
    private List<Contribution> contributions;
    private Composite composite;

    NodeImpl(String configurationURI) {
        this.configurationName = configurationURI;
        logger.log(Level.INFO, "Creating node: " + this.configurationName);
        try {
            this.initRuntime();
            StAXArtifactProcessor configurationProcessor = (StAXArtifactProcessor)this.artifactProcessors.getProcessor(ConfiguredNodeImplementation.class);
            URL configurationURL = new URL(configurationURI);
            InputStream is = configurationURL.openStream();
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(is);
            reader.nextTag();
            ConfiguredNodeImplementation configuration = (ConfiguredNodeImplementation)configurationProcessor.read(reader);
            is.close();
            for (Contribution contribution : configuration.getContributions()) {
                URL contributionURL = new URL(configurationURL, contribution.getLocation());
                contribution.setLocation(contributionURL.toString());
            }
            URL compositeURL = new URL(configurationURL, configuration.getComposite().getURI());
            configuration.getComposite().setURI(compositeURL.toString());
            this.configureNode(configuration);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    NodeImpl() {
        this.configurationName = "default";
        logger.log(Level.INFO, "Creating node: " + this.configurationName);
        try {
            this.initRuntime();
            ConfiguredNodeImplementation config = this.findNodeConfiguration(null, null);
            this.configureNode(config);
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    NodeImpl(ClassLoader classLoader, String compositeURI) {
        this.configurationName = compositeURI;
        logger.log(Level.INFO, "Creating node: " + this.configurationName);
        if (compositeURI != null) {
            URI uri;
            try {
                uri = new URI(null, compositeURI, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Composite URI: " + compositeURI, e);
            }
            if (uri.isAbsolute()) {
                throw new IllegalArgumentException("Composite URI must be a resource name: " + compositeURI);
            }
        }
        try {
            this.initRuntime();
            ConfiguredNodeImplementation config = this.findNodeConfiguration(compositeURI, classLoader);
            this.configureNode(config);
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private ConfiguredNodeImplementation findNodeConfiguration(String compositeURI, ClassLoader classLoader) throws Exception {
        NodeImplementationFactory nodeImplementationFactory = (NodeImplementationFactory)this.modelFactories.getFactory(NodeImplementationFactory.class);
        ConfiguredNodeImplementation config = nodeImplementationFactory.createConfiguredNodeImplementation();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        String contributionArtifactPath = compositeURI;
        URL contributionArtifactURL = null;
        if (compositeURI != null) {
            contributionArtifactURL = NodeImpl.getResource(classLoader, compositeURI);
            if (contributionArtifactURL == null) {
                throw new IllegalArgumentException("Composite not found: " + contributionArtifactPath);
            }
            Composite composite = this.createComposite(compositeURI);
            config.setComposite(composite);
        } else {
            contributionArtifactPath = "META-INF/sca-contribution.xml";
            contributionArtifactURL = NodeImpl.getResource(classLoader, "META-INF/sca-contribution.xml");
            if (contributionArtifactURL == null) {
                contributionArtifactPath = "META-INF/sca-contribution-generated.xml";
                contributionArtifactURL = NodeImpl.getResource(classLoader, "META-INF/sca-contribution-generated.xml");
            }
            if (contributionArtifactURL == null) {
                contributionArtifactPath = "META-INF/sca-deployables/";
                contributionArtifactURL = NodeImpl.getResource(classLoader, "META-INF/sca-deployables/");
            }
            if (contributionArtifactURL == null) {
                throw new IllegalArgumentException("No default contribution can be discovered on the classpath");
            }
        }
        Contribution c = this.getContribution(contributionArtifactURL, contributionArtifactPath);
        config.getContributions().add(c);
        return config;
    }

    private Contribution getContribution(URL contributionArtifactURL, String contributionArtifactPath) {
        URL contributionURL = NodeImpl.getContributionURL(contributionArtifactURL, contributionArtifactPath);
        ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
        SCAContribution contribution = new SCAContribution(contributionURL.toString(), contributionURL.toString());
        Contribution c = NodeImpl.createContribution(contributionFactory, contribution);
        return c;
    }

    public static URL getContributionURL(URL contributionArtifactURL, String contributionArtifactPath) {
        URL contributionURL;
        block13: {
            contributionURL = null;
            try {
                String url = contributionArtifactURL.toExternalForm();
                String protocol = contributionArtifactURL.getProtocol();
                String escapedContributionArtifactPath = new URI(null, contributionArtifactPath, null).toASCIIString();
                if ("file".equals(protocol)) {
                    if (!url.endsWith(escapedContributionArtifactPath)) break block13;
                    final String location = url.substring(0, url.lastIndexOf(escapedContributionArtifactPath));
                    try {
                        contributionURL = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                            @Override
                            public URL run() throws IOException {
                                return FileHelper.toFile((URL)new URL(location)).toURI().toURL();
                            }
                        });
                        break block13;
                    }
                    catch (PrivilegedActionException e) {
                        throw (MalformedURLException)e.getException();
                    }
                }
                if ("jar".equals(protocol)) {
                    String location = url.substring(4, url.lastIndexOf("!/"));
                    contributionURL = FileHelper.toFile((URL)new URL(location)).toURI().toURL();
                } else if ("wsjar".equals(protocol)) {
                    String location = url.substring(6, url.lastIndexOf("!/"));
                    contributionURL = FileHelper.toFile((URL)new URL(location)).toURI().toURL();
                } else if ("zip".equals(protocol)) {
                    String location = "file:" + url.substring(4, url.lastIndexOf("!/"));
                    contributionURL = FileHelper.toFile((URL)new URL(location)).toURI().toURL();
                } else if (protocol != null && (protocol.equals("bundle") || protocol.equals("bundleresource"))) {
                    contributionURL = new URL(contributionArtifactURL.getProtocol(), contributionArtifactURL.getHost(), contributionArtifactURL.getPort(), "/");
                }
            }
            catch (MalformedURLException mfe) {
                throw new IllegalArgumentException(mfe);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException(use);
            }
        }
        return contributionURL;
    }

    private static URL getResource(final ClassLoader classLoader, final String compositeURI) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return classLoader.getResource(compositeURI);
            }
        });
    }

    NodeImpl(String compositeURI, SCAContribution[] contributions) {
        this.configurationName = compositeURI;
        logger.log(Level.INFO, "Creating node: " + this.configurationName);
        try {
            this.initRuntime();
            URI uri = compositeURI == null ? null : URI.create(compositeURI);
            ConfiguredNodeImplementation configuration = null;
            if (contributions == null || contributions.length == 0) {
                if (uri != null && uri.getScheme() != null) {
                    throw new IllegalArgumentException("No SCA contributions are provided");
                }
                configuration = this.findNodeConfiguration(compositeURI, null);
            } else {
                NodeImplementationFactory nodeImplementationFactory = (NodeImplementationFactory)this.modelFactories.getFactory(NodeImplementationFactory.class);
                configuration = nodeImplementationFactory.createConfiguredNodeImplementation();
                Composite composite = compositeURI == null ? null : this.createComposite(compositeURI);
                configuration.setComposite(composite);
                ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
                for (SCAContribution c : contributions) {
                    Contribution contribution = NodeImpl.createContribution(contributionFactory, c);
                    configuration.getContributions().add(contribution);
                }
            }
            this.configureNode(configuration);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private Composite createComposite(String compositeURI) {
        AssemblyFactory assemblyFactory = (AssemblyFactory)this.modelFactories.getFactory(AssemblyFactory.class);
        Composite composite = assemblyFactory.createComposite();
        composite.setURI(compositeURI);
        composite.setUnresolved(true);
        return composite;
    }

    NodeImpl(String compositeURI, String compositeContent, SCAContribution[] contributions) {
        this.configurationName = compositeURI;
        logger.log(Level.INFO, "Creating node: " + this.configurationName);
        try {
            this.initRuntime();
            ConfiguredNodeImplementation configuration = null;
            if (contributions == null || contributions.length == 0) {
                configuration = this.findNodeConfiguration(compositeURI, null);
            } else {
                NodeImplementationFactory nodeImplementationFactory = (NodeImplementationFactory)this.modelFactories.getFactory(NodeImplementationFactory.class);
                configuration = nodeImplementationFactory.createConfiguredNodeImplementation();
                StAXArtifactProcessor compositeProcessor = (StAXArtifactProcessor)this.artifactProcessors.getProcessor(Composite.class);
                logger.log(Level.INFO, "Loading composite: " + compositeURI);
                CompositeDocumentProcessor compositeDocProcessor = (CompositeDocumentProcessor)this.documentProcessors.getProcessor(Composite.class);
                this.composite = compositeDocProcessor.read(URI.create(compositeURI), (InputStream)new ByteArrayInputStream(compositeContent.getBytes("UTF-8")));
                this.analyzeProblems();
                configuration.setComposite(this.composite);
                ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
                for (SCAContribution c : contributions) {
                    Contribution contribution = NodeImpl.createContribution(contributionFactory, c);
                    configuration.getContributions().add(contribution);
                }
            }
            this.configureNode(configuration);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private static Contribution createContribution(ContributionFactory contributionFactory, SCAContribution c) {
        Contribution contribution = contributionFactory.createContribution();
        contribution.setURI(c.getURI());
        contribution.setLocation(c.getLocation());
        contribution.setUnresolved(true);
        return contribution;
    }

    private void initRuntime() throws Exception {
        this.runtime = new RuntimeBootStrapper(Thread.currentThread().getContextClassLoader());
        this.runtime.start();
        ExtensionPointRegistry registry = this.runtime.getExtensionPointRegistry();
        this.modelFactories = (ModelFactoryExtensionPoint)registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.inputFactory = (XMLInputFactory)this.modelFactories.getFactory(XMLInputFactory.class);
        this.artifactProcessors = (StAXArtifactProcessorExtensionPoint)registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.documentProcessors = (URLArtifactProcessorExtensionPoint)registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.compositeActivator = this.runtime.getCompositeActivator();
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
    }

    private static URI createURI(String uri) {
        if (uri.indexOf(32) != -1) {
            uri = uri.replace(" ", "%20");
        }
        return URI.create(uri);
    }

    private void configureNode(ConfiguredNodeImplementation configuration) throws Exception {
        URI uri;
        Map<String, URL> localContributions = NodeImpl.localContributions();
        ContributionService contributionService = this.runtime.getContributionService();
        this.contributions = new ArrayList<Contribution>();
        for (Contribution contribution : configuration.getContributions()) {
            URL localContributionURL;
            URL contributionURL;
            String file;
            int i;
            uri = NodeImpl.createURI(contribution.getLocation());
            if (uri.getScheme() == null) {
                uri = new File(contribution.getLocation()).toURI();
            }
            if ((i = (file = (contributionURL = uri.toURL()).getPath()).lastIndexOf(47)) != -1 && i < file.length() - 1 && (localContributionURL = localContributions.get(file = file.substring(i + 1))) != null) {
                contributionURL = localContributionURL;
            }
            logger.log(Level.INFO, "Loading contribution: " + contributionURL);
            this.contributions.add(contributionService.contribute(contribution.getURI(), contributionURL, false));
            this.analyzeProblems();
        }
        this.composite = configuration.getComposite();
        if (this.composite != null && this.composite.isUnresolved()) {
            ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
            Artifact compositeFile = contributionFactory.createArtifact();
            compositeFile.setUnresolved(true);
            compositeFile.setURI(this.composite.getURI());
            for (Contribution c : this.contributions) {
                ModelResolver resolver = c.getModelResolver();
                Artifact resolved = (Artifact)resolver.resolveModel(Artifact.class, (Object)compositeFile);
                if (resolved == null || resolved.isUnresolved()) continue;
                this.composite = (Composite)resolved.getModel();
                break;
            }
        }
        if (this.composite == null) {
            ArrayList<Composite> deployables = new ArrayList<Composite>();
            for (Contribution c : this.contributions) {
                deployables.addAll(c.getDeployables());
            }
            this.aggregate(deployables);
            configuration.setComposite(this.composite);
        }
        Contribution contribution = null;
        if (this.composite.getName() == null) {
            URL compositeURL;
            uri = NodeImpl.createURI(configuration.getComposite().getURI());
            if (uri.getScheme() == null) {
                contribution = this.contribution(this.contributions, uri.toString());
                if (contribution == null) {
                    throw new IllegalArgumentException("Composite is not found in contributions: " + uri);
                }
                compositeURL = new URL(this.location(contribution, uri.toString()));
            } else {
                compositeURL = uri.toURL();
            }
            URLArtifactProcessor compositeDocProcessor = (URLArtifactProcessor)this.documentProcessors.getProcessor(Composite.class);
            logger.log(Level.INFO, "Loading composite: " + compositeURL);
            this.composite = (Composite)compositeDocProcessor.read(null, uri, compositeURL);
            this.analyzeProblems();
        }
        if (contribution == null && this.contributions.size() != 0) {
            contribution = this.contributions.get(this.contributions.size() - 1);
        }
        if (contribution != null) {
            StAXArtifactProcessor compositeProcessor = (StAXArtifactProcessor)this.artifactProcessors.getProcessor(Composite.class);
            compositeProcessor.resolve((Object)this.composite, contribution.getModelResolver());
            this.analyzeProblems();
        }
        AssemblyFactory assemblyFactory = this.runtime.getAssemblyFactory();
        Composite tempComposite = assemblyFactory.createComposite();
        tempComposite.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "temp"));
        tempComposite.setURI("http://tuscany.apache.org/xmlns/sca/1.0");
        tempComposite.getIncludes().add(this.composite);
        this.compositeActivator.setDomainComposite(tempComposite);
        this.runtime.buildComposite(this.composite);
        this.analyzeProblems();
    }

    private void aggregate(List<Composite> composites) {
        if (composites.size() == 0) {
            throw new IllegalArgumentException("No deployable composite is declared");
        }
        if (composites.size() == 1) {
            this.composite = composites.get(0);
        } else {
            AssemblyFactory assemblyFactory = this.runtime.getAssemblyFactory();
            Composite aggregated = assemblyFactory.createComposite();
            aggregated.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", "aggregated"));
            aggregated.setURI("http://tuscany.apache.org/xmlns/sca/1.0/aggregated");
            aggregated.getIncludes().addAll(composites);
            this.composite = aggregated;
        }
    }

    private String location(Contribution contribution, String uri) {
        if (uri != null && uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
        Artifact compositeFile = contributionFactory.createArtifact();
        compositeFile.setUnresolved(true);
        compositeFile.setURI(uri);
        ModelResolver resolver = contribution.getModelResolver();
        Artifact resolved = (Artifact)resolver.resolveModel(Artifact.class, (Object)compositeFile);
        if (resolved != null && !resolved.isUnresolved()) {
            return resolved.getLocation();
        }
        return null;
    }

    private Contribution contribution(List<Contribution> contributions, String compositeURI) {
        if (compositeURI != null && compositeURI.startsWith("/")) {
            compositeURI = compositeURI.substring(1);
        }
        ContributionFactory contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
        Artifact compositeFile = contributionFactory.createArtifact();
        compositeFile.setUnresolved(true);
        compositeFile.setURI(compositeURI);
        for (Contribution c : contributions) {
            ModelResolver resolver = c.getModelResolver();
            Artifact resolved = (Artifact)resolver.resolveModel(Artifact.class, (Object)compositeFile);
            if (resolved == null || resolved.isUnresolved()) continue;
            return c;
        }
        return null;
    }

    private void analyzeProblems() throws Exception {
        for (Problem problem : this.monitor.getProblems()) {
            if (problem.getSeverity() != Problem.Severity.ERROR || problem.getMessageId().equals("SchemaError")) continue;
            if (problem.getCause() != null) {
                throw problem.getCause();
            }
            throw new ServiceRuntimeException(problem.toString());
        }
    }

    public void start() {
        logger.log(Level.INFO, "Starting node: " + this.configurationName);
        try {
            this.compositeActivator.activate(this.composite);
            this.compositeActivator.start(this.composite);
        }
        catch (ActivationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        logger.log(Level.INFO, "Stopping node: " + this.configurationName);
        try {
            this.compositeActivator.stop(this.composite);
            this.compositeActivator.deactivate(this.composite);
            this.runtime.stop();
        }
        catch (ActivationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        return (R)this.runtime.getProxyFactory().cast(target);
    }

    public <B> B getService(Class<B> businessInterface, String serviceName) {
        ServiceReference<B> serviceReference = this.getServiceReference(businessInterface, serviceName);
        if (serviceReference == null) {
            throw new ServiceRuntimeException("Service not found: " + serviceName);
        }
        return (B)serviceReference.getService();
    }

    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String name) {
        String serviceName;
        String componentName;
        int i = name.indexOf(47);
        if (i != -1) {
            componentName = name.substring(0, i);
            serviceName = name.substring(i + 1);
        } else {
            componentName = name;
            serviceName = null;
        }
        Component component = null;
        for (Component compositeComponent : this.composite.getComponents()) {
            if (!compositeComponent.getName().equals(componentName)) continue;
            component = compositeComponent;
            break;
        }
        if (component == null) {
            throw new ServiceRuntimeException("The service " + name + " has not been contributed to the domain");
        }
        RuntimeComponentContext componentContext = null;
        if (component.getImplementation() instanceof Composite) {
            for (ComponentService componentService : component.getServices()) {
                if (serviceName != null && !serviceName.equals(componentService.getName())) continue;
                CompositeService compositeService = (CompositeService)componentService.getService();
                if (compositeService == null) break;
                if (serviceName != null) {
                    serviceName = "$promoted$" + component.getName() + "$slash$" + serviceName;
                }
                if ((componentContext = ((RuntimeComponent)compositeService.getPromotedComponent()).getComponentContext()) == null) break;
                return componentContext.createSelfReference(businessInterface, compositeService.getPromotedService());
            }
            throw new ServiceRuntimeException("Composite service not found: " + name);
        }
        componentContext = ((RuntimeComponent)component).getComponentContext();
        if (serviceName != null) {
            return componentContext.createSelfReference(businessInterface, serviceName);
        }
        return componentContext.createSelfReference(businessInterface);
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.runtime.getExtensionPointRegistry();
    }

    public Composite getComposite() {
        return this.composite;
    }

    private static Map<String, URL> localContributions() {
        HashMap<String, URL> localContributions = new HashMap<String, URL>();
        NodeImpl.collectJARs(localContributions, Thread.currentThread().getContextClassLoader());
        return localContributions;
    }

    private static void collectJARs(Map<String, URL> urls, ClassLoader cl) {
        URL[] jarURLs;
        if (cl == null) {
            return;
        }
        if (cl instanceof URLClassLoader && (jarURLs = ((URLClassLoader)cl).getURLs()) != null) {
            for (URL jarURL : jarURLs) {
                String file = jarURL.getPath();
                int i = file.lastIndexOf(47);
                if (i == -1 || i >= file.length() - 1) continue;
                file = file.substring(i + 1);
                urls.put(file, jarURL);
            }
        }
        NodeImpl.collectJARs(urls, cl.getParent());
    }

    public CompositeActivator getCompositeActivator() {
        return this.compositeActivator;
    }

    public RuntimeBootStrapper getRuntime() {
        return this.runtime;
    }
}

