/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.WSDLConstants;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInterfaceProcessor
implements StAXArtifactProcessor<WSDLInterfaceContract>,
WSDLConstants {
    private WSDLFactory wsdlFactory;
    private InterfaceContractMapper interfaceContractMapper;
    private static String FRAGMENT_INTERFACE = "wsdl.interface";
    private static String FRAGMENT_PORTTYPE = "wsdl.porttype";

    public WSDLInterfaceProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(InterfaceContractMapper.class);
        this.wsdlFactory = (WSDLFactory)modelFactories.getFactory(WSDLFactory.class);
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    private WSDLInterface createWSDLInterface(String uri, Monitor monitor) throws ContributionReadException {
        WSDLInterface wsdlInterface = null;
        int index = uri.indexOf(35);
        if (index == -1) {
            this.error(monitor, "InvalidWSDLInterfaceAttr", (Object)this.wsdlFactory, uri);
        } else {
            String namespace = uri.substring(0, index);
            String name = uri.substring(index + 1);
            String porttype = null;
            if (name.contains(FRAGMENT_INTERFACE)) {
                porttype = name.substring("wsdl.interface(".length(), name.length() - 1);
            }
            if (name.contains(FRAGMENT_PORTTYPE)) {
                porttype = name.substring("wsdl.porttype(".length(), name.length() - 1);
            }
            if (porttype == null) {
                this.error(monitor, "InvalidWSDLInterfaceAttr", (Object)this.wsdlFactory, uri);
                return null;
            }
            wsdlInterface = this.wsdlFactory.createWSDLInterface();
            wsdlInterface.setUnresolved(true);
            wsdlInterface.setName(new QName(namespace, porttype));
        }
        return wsdlInterface;
    }

    public WSDLInterfaceContract read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String remotable;
        WSDLInterface wsdlCallbackInterface;
        WSDLInterface wsdlInterface;
        WSDLInterfaceContract wsdlInterfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        Monitor monitor = context.getMonitor();
        String location = reader.getAttributeValue("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation");
        wsdlInterfaceContract.setLocation(location);
        String uri = reader.getAttributeValue(null, "interface");
        if (uri != null && (wsdlInterface = this.createWSDLInterface(uri, monitor)) != null) {
            wsdlInterfaceContract.setInterface(wsdlInterface);
        }
        if ((uri = reader.getAttributeValue(null, "callbackInterface")) != null && (wsdlCallbackInterface = this.createWSDLInterface(uri, monitor)) != null) {
            wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
        }
        if ((remotable = reader.getAttributeValue(null, "remotable")) != null && !remotable.equals("true")) {
            Monitor.error((Monitor)monitor, (Object)this, (String)"interface-wsdlxml-validation-messages", (String)"InvalidRemotableValue", (Object[])new Object[]{((WSDLInterface)wsdlInterfaceContract.getInterface()).getName().toString(), remotable});
        }
        while (reader.hasNext()) {
            if (reader.next() == 2 && INTERFACE_WSDL_QNAME.equals(reader.getName())) break;
        }
        return wsdlInterfaceContract;
    }

    public void write(WSDLInterfaceContract wsdlInterfaceContract, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        WSDLInterface wsdlCallbackInterface;
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200903", "interface.wsdl");
        WSDLInterface wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface();
        if (wsdlInterface != null) {
            QName qname = wsdlInterface.getName();
            String uri = String.valueOf(qname.getNamespaceURI()) + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("interface", uri);
        }
        if ((wsdlCallbackInterface = (WSDLInterface)wsdlInterfaceContract.getCallbackInterface()) != null) {
            QName qname = wsdlCallbackInterface.getName();
            String uri = String.valueOf(qname.getNamespaceURI()) + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("callbackInterface", uri);
        }
        if (wsdlInterfaceContract.getLocation() != null) {
            writer.writeAttribute("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation", wsdlInterfaceContract.getLocation());
        }
        writer.writeEndElement();
    }

    private WSDLInterface resolveWSDLInterface(WSDLInterface wsdlInterface, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (wsdlInterface != null && wsdlInterface.isUnresolved()) {
            Monitor monitor = context.getMonitor();
            if ((wsdlInterface = (WSDLInterface)resolver.resolveModel(WSDLInterface.class, (Object)wsdlInterface, context)).isUnresolved()) {
                WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                wsdlDefinition.setUnresolved(true);
                wsdlDefinition.setNamespace(wsdlInterface.getName().getNamespaceURI());
                WSDLDefinition resolved = (WSDLDefinition)resolver.resolveModel(WSDLDefinition.class, (Object)wsdlDefinition, context);
                if (!resolved.isUnresolved()) {
                    wsdlDefinition.setDefinition(resolved.getDefinition());
                    wsdlDefinition.setLocation(resolved.getLocation());
                    wsdlDefinition.setURI(resolved.getURI());
                    wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
                    wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
                    wsdlDefinition.setUnresolved(false);
                    WSDLObject<PortType> portType = wsdlDefinition.getWSDLObject(PortType.class, wsdlInterface.getName());
                    if (portType != null) {
                        try {
                            wsdlDefinition.setDefinition(portType.getDefinition());
                            wsdlInterface = this.wsdlFactory.createWSDLInterface(portType.getElement(), wsdlDefinition, resolver, monitor);
                            wsdlInterface.setWsdlDefinition(wsdlDefinition);
                            resolver.addModel((Object)wsdlInterface, context);
                        }
                        catch (InvalidInterfaceException e) {
                            ContributionResolveException ce = new ContributionResolveException("Invalid interface when resolving " + portType.toString(), (Throwable)e);
                            this.error(monitor, "ContributionResolveException", (Object)this.wsdlFactory, (Exception)ce);
                        }
                    } else {
                        this.warning(monitor, "WsdlInterfaceDoesNotMatch", wsdlDefinition, wsdlInterface.getName());
                    }
                } else {
                    ContributionResolveException ce = new ContributionResolveException("WSDLDefinition unresolved " + wsdlInterface.getName());
                    this.error(monitor, "ContributionResolveException", (Object)this.wsdlFactory, (Exception)ce);
                }
            }
        }
        return wsdlInterface;
    }

    public static WSDLInterface resolveWSDLInterface(WSDLInterface wsdlInterface, ModelResolver resolver, Monitor monitor, WSDLFactory wsdlFactory) {
        ProcessorContext context;
        if (wsdlInterface != null && wsdlInterface.isUnresolved() && (wsdlInterface = (WSDLInterface)resolver.resolveModel(WSDLInterface.class, (Object)wsdlInterface, context = new ProcessorContext(monitor))).isUnresolved()) {
            WSDLDefinition wsdlDefinition = wsdlFactory.createWSDLDefinition();
            wsdlDefinition.setUnresolved(true);
            wsdlDefinition.setNamespace(wsdlInterface.getName().getNamespaceURI());
            WSDLDefinition resolved = (WSDLDefinition)resolver.resolveModel(WSDLDefinition.class, (Object)wsdlDefinition, context);
            if (!resolved.isUnresolved()) {
                wsdlDefinition.setDefinition(resolved.getDefinition());
                wsdlDefinition.setLocation(resolved.getLocation());
                wsdlDefinition.setURI(resolved.getURI());
                wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
                wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
                wsdlDefinition.setUnresolved(false);
                WSDLObject<PortType> portType = wsdlDefinition.getWSDLObject(PortType.class, wsdlInterface.getName());
                if (portType != null) {
                    try {
                        wsdlDefinition.setDefinition(portType.getDefinition());
                        wsdlInterface = wsdlFactory.createWSDLInterface(portType.getElement(), wsdlDefinition, resolver, monitor);
                        wsdlInterface.setWsdlDefinition(wsdlDefinition);
                        resolver.addModel((Object)wsdlInterface, context);
                    }
                    catch (InvalidInterfaceException e) {
                        ContributionResolveException ce = new ContributionResolveException("Invalid interface when resolving " + portType.toString(), (Throwable)e);
                        Monitor.error((Monitor)monitor, (Object)WSDLInterfaceProcessor.class.getName(), (String)"interface-wsdlxml-validation-messages", (String)"ContributionResolveException", (Object[])new Object[]{wsdlFactory.getClass().getName(), ce.getMessage()});
                    }
                } else {
                    Monitor.warning((Monitor)monitor, (Object)WSDLInterfaceProcessor.class.getName(), (String)"interface-wsdlxml-validation-messages", (String)"WsdlInterfaceDoesNotMatch", (Object[])new Object[]{wsdlDefinition.getNamespace(), wsdlInterface.getName().toString()});
                }
            } else {
                ContributionResolveException ce = new ContributionResolveException("WSDLDefinition unresolved " + wsdlInterface.getName());
                Monitor.error((Monitor)monitor, (Object)WSDLInterfaceProcessor.class.getName(), (String)"interface-wsdlxml-validation-messages", (String)"ContributionResolveException", (Object[])new Object[]{wsdlFactory.getClass().getName(), ce.getMessage()});
            }
        }
        return wsdlInterface;
    }

    public void resolve(WSDLInterfaceContract wsdlInterfaceContract, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        context.getMonitor();
        WSDLInterface wsdlInterface = this.resolveWSDLInterface((WSDLInterface)wsdlInterfaceContract.getInterface(), resolver, context);
        wsdlInterfaceContract.setInterface(wsdlInterface);
        WSDLInterface intrinsicWSDLCallbackInterface = wsdlInterface.getCallbackInterface();
        WSDLInterface wsdlCallbackInterface = this.resolveWSDLInterface((WSDLInterface)wsdlInterfaceContract.getCallbackInterface(), resolver, context);
        if (intrinsicWSDLCallbackInterface != null) {
            if (wsdlCallbackInterface != null && !this.interfaceContractMapper.isEqual((Interface)intrinsicWSDLCallbackInterface, (Interface)wsdlCallbackInterface)) {
                Monitor.error((Monitor)context.getMonitor(), (Object)WSDLInterfaceProcessor.class.getName(), (String)"interface-wsdlxml-validation-messages", (String)"IncompatibleCallbacks", (Object[])new Object[]{intrinsicWSDLCallbackInterface.getName().toString(), wsdlCallbackInterface.getName().toString()});
            }
            wsdlInterfaceContract.setCallbackInterface(intrinsicWSDLCallbackInterface);
        } else {
            wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
        }
    }

    public QName getArtifactType() {
        return WSDLConstants.INTERFACE_WSDL_QNAME;
    }

    public Class<WSDLInterfaceContract> getModelType() {
        return WSDLInterfaceContract.class;
    }
}

