/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLOperation;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.InvalidWSDLException;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLOperationImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLOperationIntrospectorImpl {
    private static final Logger logger = Logger.getLogger(WSDLOperationIntrospectorImpl.class.getName());
    private static final QName ANY = new QName("http://www.w3.org/2001/XMLSchema", "any");
    private XSDFactory xsdFactory;
    private ModelResolver resolver;
    private ProcessorContext context;
    private WSDLDefinition wsdlDefinition;
    private javax.wsdl.Operation operation;
    private WSDLOperation operationModel;
    private DataType<List<DataType>> inputType;
    private DataType outputType;
    private List<DataType> faultTypes;
    private String dataBinding;
    private Wrapper wrapper;
    private Boolean wrapperStyle;

    public WSDLOperationIntrospectorImpl(XSDFactory xsdFactory, javax.wsdl.Operation operation, WSDLDefinition wsdlDefinition, String dataBinding, ModelResolver resolver, Monitor monitor) {
        this.xsdFactory = xsdFactory;
        this.operation = operation;
        this.wsdlDefinition = wsdlDefinition;
        this.resolver = resolver;
        this.dataBinding = dataBinding;
        this.wrapper = new Wrapper();
        this.context = new ProcessorContext(monitor);
    }

    public boolean isWrapperStyle() throws InvalidWSDLException {
        if (this.wrapperStyle == null) {
            this.wrapperStyle = !(this.operation.getInput() != null && this.operation.getInput().getMessage() != null && this.operation.getInput().getMessage().getParts().size() != 0 && this.wrapper.getInputChildElements() == null || this.operation.getOutput() != null && this.operation.getOutput().getMessage() != null && this.operation.getOutput().getMessage().getParts().size() != 0 && this.wrapper.getOutputChildElements() == null);
        }
        return this.wrapperStyle;
    }

    public Wrapper getWrapper() throws InvalidWSDLException {
        if (!this.isWrapperStyle()) {
            throw new IllegalStateException("The operation is not wrapper style.");
        }
        return this.wrapper;
    }

    public DataType<List<DataType>> getInputType() throws InvalidWSDLException {
        if (this.inputType == null) {
            Input input = this.operation.getInput();
            Message message = input == null ? null : input.getMessage();
            this.inputType = this.getMessageType(message);
            this.inputType.setDataBinding("idl:input");
        }
        return this.inputType;
    }

    public DataType<XMLType> getOutputType() throws InvalidWSDLException {
        if (this.outputType == null) {
            List outputParts;
            Output output = this.operation.getOutput();
            Message outputMsg = output == null ? null : output.getMessage();
            List list = outputParts = outputMsg == null ? null : outputMsg.getOrderedParts(null);
            if (outputParts != null && outputParts.size() > 0) {
                if (outputParts.size() > 1 && logger.isLoggable(Level.WARNING)) {
                    logger.warning("Multi-part output is not supported, please use BARE parameter style.");
                }
                Part part = (Part)outputParts.get(0);
                this.outputType = new WSDLPart(part, Object.class).getDataType();
            }
        }
        return this.outputType;
    }

    public List<DataType> getFaultTypes() throws InvalidWSDLException {
        if (this.faultTypes == null) {
            Collection faults = this.operation.getFaults().values();
            this.faultTypes = new ArrayList<DataType>();
            for (Object f : faults) {
                Fault fault = (Fault)f;
                Message faultMsg = fault.getMessage();
                List faultParts = faultMsg.getOrderedParts(null);
                if (faultParts.size() != 1) {
                    throw new InvalidWSDLException("The fault message MUST have a single part");
                }
                Part part = (Part)faultParts.get(0);
                WSDLPart wsdlPart = new WSDLPart(part, Object.class);
                this.faultTypes.add((DataType)new DataTypeImpl(FaultException.class, wsdlPart.getDataType()));
            }
        }
        return this.faultTypes;
    }

    private DataType<List<DataType>> getMessageType(Message message) throws InvalidWSDLException {
        ArrayList<DataType<XMLType>> partTypes = new ArrayList<DataType<XMLType>>();
        if (message != null) {
            List parts = message.getOrderedParts(null);
            for (Object p : parts) {
                WSDLPart part = new WSDLPart((Part)p, Object.class);
                DataType<XMLType> partType = part.getDataType();
                partTypes.add(partType);
            }
        }
        return new DataTypeImpl(this.dataBinding, Object[].class, partTypes);
    }

    public Operation getOperation() throws InvalidWSDLException {
        if (this.operationModel == null) {
            boolean oneway = this.operation.getOutput() == null;
            this.operationModel = new WSDLOperationImpl();
            this.operationModel.setWsdlOperation(this.operation);
            this.operationModel.setName(this.operation.getName());
            this.operationModel.setFaultTypes(this.getFaultTypes());
            this.operationModel.setNonBlocking(oneway);
            this.operationModel.setConversationSequence(ConversationSequence.CONVERSATION_NONE);
            this.operationModel.setInputType(this.getInputType());
            this.operationModel.setOutputType(this.getOutputType());
            this.operationModel.setWrapperStyle(this.isWrapperStyle());
            if (this.isWrapperStyle()) {
                WrapperInfo wrapperInfo = this.getWrapper().getWrapperInfo();
                this.operationModel.setWrapper(wrapperInfo);
            }
        }
        return this.operationModel;
    }

    private XmlSchemaElement getElement(QName elementName) {
        XmlSchemaElement element = this.wsdlDefinition.getXmlSchemaElement(elementName);
        if (element == null) {
            XSDefinition definition = this.xsdFactory.createXSDefinition();
            definition.setUnresolved(true);
            definition.setNamespace(elementName.getNamespaceURI());
            definition = (XSDefinition)this.resolver.resolveModel(XSDefinition.class, (Object)definition, this.context);
            if (definition.getSchema() != null) {
                element = definition.getSchema().getElementByName(elementName);
            }
        }
        return element;
    }

    private XmlSchemaType getType(QName typeName) {
        XmlSchemaType type = this.wsdlDefinition.getXmlSchemaType(typeName);
        if (type == null) {
            XSDefinition definition = this.xsdFactory.createXSDefinition();
            definition.setUnresolved(true);
            definition.setNamespace(typeName.getNamespaceURI());
            definition = (XSDefinition)this.resolver.resolveModel(XSDefinition.class, (Object)definition, this.context);
            if (definition.getSchema() != null) {
                type = definition.getSchema().getTypeByName(typeName);
            }
        }
        return type;
    }

    private static ElementInfo getElementInfo(XmlSchemaElement element) {
        if (element == null) {
            return null;
        }
        ElementInfo elementInfo = new ElementInfo(element.getQName(), WSDLOperationIntrospectorImpl.getTypeInfo(element.getSchemaType()));
        elementInfo.setMany(element.getMaxOccurs() > 1L);
        elementInfo.setNillable(element.isNillable());
        return elementInfo;
    }

    private static TypeInfo getTypeInfo(XmlSchemaType type) {
        if (type == null) {
            return null;
        }
        XmlSchemaType baseType = (XmlSchemaType)type.getBaseSchemaType();
        QName name = type.getQName();
        boolean simple = type instanceof XmlSchemaSimpleType;
        if (baseType == null) {
            return new TypeInfo(name, simple, null);
        }
        return new TypeInfo(name, simple, WSDLOperationIntrospectorImpl.getTypeInfo(baseType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WSDLPart {
        private Part part;
        private XmlSchemaElement element;
        private DataType dataType;

        public WSDLPart(Part part, Class javaType) throws InvalidWSDLException {
            this.part = part;
            QName elementName = part.getElementName();
            if (elementName != null) {
                this.element = WSDLOperationIntrospectorImpl.this.getElement(elementName);
                if (this.element == null) {
                    throw new InvalidWSDLException("Element cannot be resolved: " + elementName.toString());
                }
            } else {
                this.element = new XmlSchemaElement();
                this.element.setName(part.getName());
                this.element.setQName(new QName(null, part.getName()));
                QName typeName = part.getTypeName();
                if (typeName != null) {
                    XmlSchemaType type = WSDLOperationIntrospectorImpl.this.getType(typeName);
                    if (type == null) {
                        throw new InvalidWSDLException("Type cannot be resolved: " + typeName.toString());
                    }
                    this.element.setSchemaType(type);
                    this.element.setSchemaTypeName(type.getQName());
                }
            }
            XMLType xmlType = new XMLType(WSDLOperationIntrospectorImpl.getElementInfo(this.element));
            xmlType.setNillable(this.element.isNillable());
            xmlType.setMany(this.element.getMaxOccurs() > 1L);
            this.dataType = new DataTypeImpl(WSDLOperationIntrospectorImpl.this.dataBinding, javaType, (Object)xmlType);
        }

        public XmlSchemaElement getElement() {
            return this.element;
        }

        public Part getPart() {
            return this.part;
        }

        public DataType<XMLType> getDataType() {
            return this.dataType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Wrapper {
        private XmlSchemaElement inputWrapperElement;
        private XmlSchemaElement outputWrapperElement;
        private List<XmlSchemaElement> inputElements;
        private List<XmlSchemaElement> outputElements;
        private transient WrapperInfo wrapperInfo;

        private List<XmlSchemaElement> getChildElements(XmlSchemaElement element) throws InvalidWSDLException {
            if (element == null) {
                return null;
            }
            element.isNillable();
            XmlSchemaType type = element.getSchemaType();
            if (type == null) {
                String qName = element.getQName().toString();
                throw new InvalidWSDLException("The XML schema element does not have a type: " + qName);
            }
            if (!(type instanceof XmlSchemaComplexType)) {
                return null;
            }
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
            if (complexType.getAttributes().getCount() != 0 || complexType.getAnyAttribute() != null) {
                return null;
            }
            XmlSchemaParticle particle = complexType.getParticle();
            if (particle == null) {
                return Collections.emptyList();
            }
            if (!(particle instanceof XmlSchemaSequence)) {
                return null;
            }
            XmlSchemaSequence sequence = (XmlSchemaSequence)complexType.getParticle();
            XmlSchemaObjectCollection items = sequence.getItems();
            ArrayList<XmlSchemaElement> childElements = new ArrayList<XmlSchemaElement>();
            int i = 0;
            while (i < items.getCount()) {
                XmlSchemaObject schemaObject = items.getItem(i);
                if (!(schemaObject instanceof XmlSchemaElement)) {
                    return null;
                }
                XmlSchemaElement childElement = (XmlSchemaElement)schemaObject;
                if (childElement.getName() == null || childElement.getRefName() != null) {
                    XmlSchemaElement ref = WSDLOperationIntrospectorImpl.this.getElement(childElement.getRefName());
                    if (ref == null) {
                        throw new InvalidWSDLException("XML schema element ref cannot be resolved: " + childElement);
                    }
                    childElement = ref;
                }
                if (ANY.equals(childElement.getQName())) {
                    return null;
                }
                childElement.getMaxOccurs();
                childElements.add(childElement);
                ++i;
            }
            return childElements;
        }

        public List<XmlSchemaElement> getInputChildElements() throws InvalidWSDLException {
            if (this.inputElements != null) {
                return this.inputElements;
            }
            Input input = WSDLOperationIntrospectorImpl.this.operation.getInput();
            if (input != null) {
                Message inputMsg = input.getMessage();
                Collection parts = inputMsg.getParts().values();
                if (parts.size() != 1) {
                    return null;
                }
                Part part = (Part)parts.iterator().next();
                QName elementName = part.getElementName();
                if (elementName == null) {
                    return null;
                }
                if (!WSDLOperationIntrospectorImpl.this.operation.getName().equals(elementName.getLocalPart())) {
                    return null;
                }
                this.inputWrapperElement = WSDLOperationIntrospectorImpl.this.getElement(elementName);
                if (this.inputWrapperElement == null) {
                    throw new InvalidWSDLException("The element is not declared in a XML schema: " + elementName.toString());
                }
                this.inputWrapperElement.isNillable();
                this.inputElements = this.getChildElements(this.inputWrapperElement);
                return this.inputElements;
            }
            return null;
        }

        public List<XmlSchemaElement> getOutputChildElements() throws InvalidWSDLException {
            if (this.outputElements != null) {
                return this.outputElements;
            }
            Output output = WSDLOperationIntrospectorImpl.this.operation.getOutput();
            if (output != null) {
                Message outputMsg = output.getMessage();
                Collection parts = outputMsg.getParts().values();
                if (parts.size() != 1) {
                    return null;
                }
                Part part = (Part)parts.iterator().next();
                QName elementName = part.getElementName();
                if (elementName == null) {
                    throw new InvalidWSDLException("The element is not declared in the XML schema: " + part.getName());
                }
                this.outputWrapperElement = WSDLOperationIntrospectorImpl.this.getElement(elementName);
                if (this.outputWrapperElement == null) {
                    return null;
                }
                this.outputWrapperElement.isNillable();
                this.outputElements = this.getChildElements(this.outputWrapperElement);
                return this.outputElements;
            }
            return null;
        }

        public XmlSchemaElement getInputWrapperElement() {
            return this.inputWrapperElement;
        }

        public XmlSchemaElement getOutputWrapperElement() {
            return this.outputWrapperElement;
        }

        public WrapperInfo getWrapperInfo() throws InvalidWSDLException {
            if (this.wrapperInfo == null) {
                ElementInfo in = WSDLOperationIntrospectorImpl.getElementInfo(this.getInputWrapperElement());
                ElementInfo out = WSDLOperationIntrospectorImpl.getElementInfo(this.getOutputWrapperElement());
                ArrayList<ElementInfo> inChildren = new ArrayList<ElementInfo>();
                if (in != null) {
                    for (XmlSchemaElement e : this.getInputChildElements()) {
                        inChildren.add(WSDLOperationIntrospectorImpl.getElementInfo(e));
                    }
                }
                ArrayList<ElementInfo> outChildren = new ArrayList<ElementInfo>();
                if (out != null) {
                    for (XmlSchemaElement e : this.getOutputChildElements()) {
                        outChildren.add(WSDLOperationIntrospectorImpl.getElementInfo(e));
                    }
                }
                this.wrapperInfo = new WrapperInfo(WSDLOperationIntrospectorImpl.this.dataBinding, in, out, inChildren, outChildren);
            }
            return this.wrapperInfo;
        }
    }
}

