/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.InvalidWSDLException;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLOperationIntrospectorImpl;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.WSDLInterfaceProcessor;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.xsd.XSDFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInterfaceIntrospectorImpl {
    private static final QName POLICY_REQUIRES = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "requires");
    private static final QName POLICY_CONVERSATIONAL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "conversational");
    public static final QName POLICY_END_CONVERSATION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "endsConversation");
    private static final QName CALLBACK_ATTRIBUTE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "callback");
    private WSDLFactory wsdlFactory;
    private XSDFactory xsdFactory;
    private PolicyFactory policyFactory;

    public WSDLInterfaceIntrospectorImpl(FactoryExtensionPoint modelFactories, WSDLFactory wsdlFactory) {
        this.xsdFactory = (XSDFactory)modelFactories.getFactory(XSDFactory.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.wsdlFactory = wsdlFactory;
    }

    private List<Operation> introspectOperations(PortType portType, WSDLDefinition wsdlDefinition, ModelResolver resolver, Monitor monitor) throws InvalidWSDLException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Object o : portType.getOperations()) {
            javax.wsdl.Operation wsdlOp = (javax.wsdl.Operation)o;
            Operation operation = WSDLInterfaceIntrospectorImpl.getOperation(wsdlOp, wsdlDefinition, resolver, this.xsdFactory, monitor);
            if (this.isEndConversation(wsdlOp)) {
                operation.setConversationSequence(ConversationSequence.CONVERSATION_END);
            }
            operations.add(operation);
        }
        return operations;
    }

    public void introspectPortType(WSDLInterface wsdlInterface, PortType portType, WSDLDefinition wsdlDefinition, ModelResolver resolver, Monitor monitor) throws InvalidWSDLException {
        this.processIntents(wsdlInterface, portType);
        WSDLInterface callback = this.processCallbackAttribute(portType, resolver, monitor);
        wsdlInterface.setPortType(portType);
        wsdlInterface.setCallbackInterface(callback);
        wsdlInterface.getOperations().addAll(this.introspectOperations(portType, wsdlDefinition, resolver, monitor));
        wsdlInterface.setConversational(this.isConversational(portType));
    }

    public static Operation getOperation(javax.wsdl.Operation wsdlOp, WSDLDefinition wsdlDefinition, ModelResolver resolver, XSDFactory xsdFactory, Monitor monitor) throws InvalidWSDLException {
        WSDLOperationIntrospectorImpl op = new WSDLOperationIntrospectorImpl(xsdFactory, wsdlOp, wsdlDefinition, null, resolver, monitor);
        return op.getOperation();
    }

    private WSDLInterface processCallbackAttribute(PortType portType, ModelResolver resolver, Monitor monitor) {
        Object o = portType.getExtensionAttribute(CALLBACK_ATTRIBUTE);
        if (o != null && o instanceof QName) {
            WSDLInterface wsdlInterface = this.wsdlFactory.createWSDLInterface();
            wsdlInterface.setUnresolved(true);
            wsdlInterface.setName((QName)o);
            wsdlInterface = WSDLInterfaceProcessor.resolveWSDLInterface(wsdlInterface, resolver, monitor, this.wsdlFactory);
            return wsdlInterface;
        }
        return null;
    }

    private void processIntents(WSDLInterface wsdlInterface, PortType portType) {
        Object o;
        try {
            o = portType.getExtensionAttribute(POLICY_REQUIRES);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            o = null;
        }
        if (o != null && o instanceof Vector) {
            Vector policyAttributes = (Vector)o;
            Enumeration policyItents = policyAttributes.elements();
            while (policyItents.hasMoreElements()) {
                QName intentName = (QName)policyItents.nextElement();
                if (intentName.equals(POLICY_CONVERSATIONAL)) continue;
                Intent intent = this.policyFactory.createIntent();
                intent.setName(intentName);
                wsdlInterface.getRequiredIntents().add(intent);
            }
        }
    }

    private boolean isConversational(PortType portType) {
        Vector policyAttributes;
        Object o;
        boolean conversational = false;
        try {
            o = portType.getExtensionAttribute(POLICY_REQUIRES);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            o = null;
        }
        if (o != null && o instanceof Vector && (policyAttributes = (Vector)o).contains(POLICY_CONVERSATIONAL)) {
            return true;
        }
        return conversational;
    }

    private boolean isEndConversation(javax.wsdl.Operation operation) {
        Object o;
        boolean endConversation = false;
        try {
            o = operation.getExtensionAttribute(POLICY_END_CONVERSATION);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            o = null;
        }
        if (o != null && o instanceof String) {
            endConversation = Boolean.valueOf((String)o);
        }
        return endConversation;
    }
}

