/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.impl;

import javax.wsdl.PortType;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLDefinitionImpl;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLInterfaceImpl;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLInterfaceIntrospectorImpl;
import org.apache.tuscany.sca.monitor.Monitor;

public abstract class WSDLFactoryImpl
implements WSDLFactory {
    private WSDLInterfaceIntrospectorImpl introspector;

    public WSDLFactoryImpl(ExtensionPointRegistry registry) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.introspector = new WSDLInterfaceIntrospectorImpl(modelFactories, this);
    }

    public WSDLInterface createWSDLInterface() {
        return new WSDLInterfaceImpl();
    }

    public WSDLInterface createWSDLInterface(PortType portType, WSDLDefinition wsdlDefinition, ModelResolver resolver, Monitor monitor) throws InvalidInterfaceException {
        WSDLInterface wsdlInterface = this.createWSDLInterface();
        this.introspector.introspectPortType(wsdlInterface, portType, wsdlDefinition, resolver, monitor);
        return wsdlInterface;
    }

    public void createWSDLInterface(WSDLInterface wsdlInterface, PortType portType, WSDLDefinition wsdlDefinition, ModelResolver resolver, Monitor monitor) throws InvalidInterfaceException {
        this.introspector.introspectPortType(wsdlInterface, portType, wsdlDefinition, resolver, monitor);
    }

    public WSDLDefinition createWSDLDefinition() {
        return new WSDLDefinitionImpl();
    }

    public WSDLInterfaceContract createWSDLInterfaceContract() {
        return new WSDLInterfaceContractImpl();
    }

    public WSDLInterfaceIntrospectorImpl getWSDLInterfaceIntrospector() {
        return this.introspector;
    }
}

