/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.impl;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLObjectImpl;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDefinitionImpl
implements WSDLDefinition {
    private Definition definition;
    private String namespace;
    private URI location;
    private URI uri;
    private List<WSDLDefinition> imported = new ArrayList<WSDLDefinition>();
    private List<XSDefinition> schemas = new ArrayList<XSDefinition>();
    private boolean unresolved;
    private Binding binding;

    protected WSDLDefinitionImpl() {
    }

    @Override
    public Definition getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public String getNamespace() {
        if (this.isUnresolved()) {
            return this.namespace;
        }
        if (this.definition != null) {
            return this.definition.getTargetNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.namespace = namespace;
    }

    @Override
    public List<XSDefinition> getXmlSchemas() {
        return this.schemas;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI url) {
        this.location = url;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public List<WSDLDefinition> getImportedDefinitions() {
        return this.imported;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WSDLDefinitionImpl)) {
            return false;
        }
        WSDLDefinitionImpl other = (WSDLDefinitionImpl)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    @Override
    public XmlSchemaElement getXmlSchemaElement(QName name) {
        XmlSchemaCollection schemaCollection = null;
        for (XSDefinition xsd : this.schemas) {
            XmlSchemaElement element;
            if (schemaCollection == null && xsd.getSchemaCollection() != null) {
                schemaCollection = xsd.getSchemaCollection();
            }
            if ((element = xsd.getXmlSchemaElement(name)) == null) continue;
            return element;
        }
        if (schemaCollection != null) {
            return schemaCollection.getElementByQName(name);
        }
        return null;
    }

    @Override
    public XmlSchemaType getXmlSchemaType(QName name) {
        XmlSchemaCollection schemaCollection = null;
        for (XSDefinition xsd : this.schemas) {
            XmlSchemaType type;
            if (xsd.getSchemaCollection() != null) {
                schemaCollection = xsd.getSchemaCollection();
            }
            if ((type = xsd.getXmlSchemaType(name)) == null) continue;
            return type;
        }
        if (schemaCollection != null) {
            return schemaCollection.getTypeByQName(name);
        }
        return null;
    }

    private static <T extends WSDLElement> WSDLObject<T> getWSDLObject(Definition definition, Class<T> type, QName name) {
        if (definition == null) {
            return null;
        }
        Map map = null;
        if (type == PortType.class) {
            map = definition.getPortTypes();
        } else if (type == Service.class) {
            map = definition.getServices();
        } else if (type == Binding.class) {
            map = definition.getBindings();
        } else if (type == Message.class) {
            map = definition.getMessages();
        } else {
            throw new IllegalArgumentException("Invalid type: " + type.getName());
        }
        if (map.containsKey(name)) {
            return new WSDLObjectImpl<Serializable>(definition, (Serializable)map.get(name));
        }
        for (Object imports : definition.getImports().values()) {
            List importList = (List)imports;
            for (Import i : importList) {
                definition = i.getDefinition();
                WSDLObject<T> element = WSDLDefinitionImpl.getWSDLObject(definition, type, name);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public <T extends WSDLElement> WSDLObject<T> getWSDLObject(Class<T> type, QName name) {
        return WSDLDefinitionImpl.getWSDLObject(this.definition, type, name);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }
}

