/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedClassLoader
extends SecureClassLoader {
    private Map<String, GeneratedClass> generatedClasses = new HashMap<String, GeneratedClass>();

    public GeneratedClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        GeneratedClass cls = this.generatedClasses.get(className);
        if (cls != null) {
            return cls.getGeneratedClass();
        }
        return super.findClass(className);
    }

    public synchronized Class<?> getGeneratedClass(String className, byte[] byteCode) {
        GeneratedClass cls = this.generatedClasses.get(className);
        if (cls == null) {
            cls = new GeneratedClass(className, byteCode);
            this.generatedClasses.put(className, cls);
        }
        return cls.getGeneratedClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GeneratedClass {
        private String className;
        private byte[] byteCode;
        private Class<?> cls;

        public GeneratedClass(String className, byte[] byteCode) {
            this.className = className;
            this.byteCode = byteCode;
        }

        public synchronized Class<?> getGeneratedClass() {
            if (this.cls == null) {
                this.cls = GeneratedClassLoader.this.defineClass(this.className, this.byteCode, 0, this.byteCode.length);
            }
            return this.cls;
        }
    }
}

