/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Qualifier;
import org.oasisopen.sca.annotation.Requires;

public class PolicyJavaInterfaceVisitor
implements JavaInterfaceVisitor {
    private PolicyFactory policyFactory;

    public PolicyJavaInterfaceVisitor(ExtensionPointRegistry registry) {
        this.policyFactory = (PolicyFactory)((FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class)).getFactory(PolicyFactory.class);
    }

    private QName getQName(String intentName) {
        int i;
        QName qname = intentName.startsWith("{") ? ((i = intentName.indexOf(125)) != -1 ? new QName(intentName.substring(1, i), intentName.substring(i + 1)) : new QName("", intentName)) : new QName("", intentName);
        return qname;
    }

    private void readIntentsAndPolicySets(Class<?> clazz, PolicySubject subject) {
        String[] policySetNames;
        String[] intentNames;
        Requires intentAnnotation = clazz.getAnnotation(Requires.class);
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                subject.getRequiredIntents().add(intent);
            }
        }
        this.readSpecificIntents(clazz.getAnnotations(), subject.getRequiredIntents());
        PolicySets policySetAnnotation = clazz.getAnnotation(PolicySets.class);
        if (policySetAnnotation != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                subject.getPolicySets().add(policySet);
            }
        }
        if (clazz.isAnnotationPresent(SOAPBinding.class)) {
            Intent intent = this.policyFactory.createIntent();
            intent.setName(Constants.SOAP_INTENT);
            subject.getRequiredIntents().add(intent);
        }
    }

    private void readIntents(Requires intentAnnotation, List<Intent> requiredIntents) {
        String[] intentNames;
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
    }

    private void readPolicySets(PolicySets policySetAnnotation, List<PolicySet> policySets) {
        String[] policySetNames;
        if (policySetAnnotation != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    public void readWebServicesAnnotations(Method m, Class<?> clazz, List<Intent> requiredIntents) {
        WebResult webResultAnnotation = m.getAnnotation(WebResult.class);
        if (webResultAnnotation != null && webResultAnnotation.header()) {
            Intent intent = this.policyFactory.createIntent();
            intent.setName(Constants.SOAP_INTENT);
            requiredIntents.add(intent);
            return;
        }
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                WebParam webParam;
                if (!(parameterAnnotations[i][j] instanceof WebParam) || !(webParam = (WebParam)parameterAnnotations[i][j]).header()) continue;
                Intent intent = this.policyFactory.createIntent();
                intent.setName(Constants.SOAP_INTENT);
                requiredIntents.add(intent);
                return;
            }
        }
    }

    @Override
    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (javaInterface.getJavaClass() != null) {
            this.readIntentsAndPolicySets(javaInterface.getJavaClass(), (PolicySubject)javaInterface);
            List operations = javaInterface.getOperations();
            for (Operation op : operations) {
                JavaOperation operation = (JavaOperation)op;
                Method method = operation.getJavaMethod();
                this.readIntents(method.getAnnotation(Requires.class), op.getRequiredIntents());
                this.readSpecificIntents(method.getAnnotations(), op.getRequiredIntents());
                this.readPolicySets(method.getAnnotation(PolicySets.class), op.getPolicySets());
                this.readWebServicesAnnotations(method, javaInterface.getJavaClass(), javaInterface.getRequiredIntents());
                this.inherit(javaInterface, op);
            }
        }
    }

    private void inherit(JavaInterface javaInterface, Operation op) {
        ArrayList interfaceIntents = new ArrayList(javaInterface.getRequiredIntents());
        for (Intent intent : javaInterface.getRequiredIntents()) {
            for (Intent operationIntent : op.getRequiredIntents()) {
                if (!intent.getExcludedIntents().contains(operationIntent) && !operationIntent.getExcludedIntents().contains(intent)) continue;
                interfaceIntents.remove(intent);
            }
        }
        op.getRequiredIntents().addAll(interfaceIntents);
        op.getPolicySets().addAll(javaInterface.getPolicySets());
    }

    private void readSpecificIntents(Annotation[] annotations, List<Intent> requiredIntents) {
        for (Annotation a : annotations) {
            org.oasisopen.sca.annotation.Intent intentAnnotation = a.annotationType().getAnnotation(org.oasisopen.sca.annotation.Intent.class);
            if (intentAnnotation == null) continue;
            QName qname = null;
            String value = intentAnnotation.value();
            qname = !value.equals("") ? this.getQName(value) : new QName(intentAnnotation.targetNamespace(), intentAnnotation.localPart());
            HashSet<String> qualifiers = new HashSet<String>();
            for (Method m : a.annotationType().getMethods()) {
                Qualifier qualifier = m.getAnnotation(Qualifier.class);
                if (qualifier == null || m.getReturnType() != String[].class) continue;
                try {
                    qualifiers.addAll(Arrays.asList((String[])m.invoke((Object)a, new Object[0])));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            qualifiers.remove("");
            if (qualifiers.isEmpty()) {
                Intent intent = this.policyFactory.createIntent();
                intent.setUnresolved(true);
                intent.setName(qname);
                requiredIntents.add(intent);
                continue;
            }
            for (String q : qualifiers) {
                Intent intent = this.policyFactory.createIntent();
                intent.setUnresolved(true);
                qname = new QName(qname.getNamespaceURI(), qname.getLocalPart() + "." + q);
                intent.setName(qname);
                requiredIntents.add(intent);
            }
        }
    }
}

