/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;

public final class JavaInterfaceUtil {
    private JavaInterfaceUtil() {
    }

    public static Method findMethod(Class<?> implClass, Operation operation) throws NoSuchMethodException {
        String name = operation.getName();
        if (operation instanceof JavaOperation) {
            if (((JavaOperation)operation).isAsyncServer()) {
                return JavaInterfaceUtil.findAsyncServerMethod(implClass, (JavaOperation)operation);
            }
            name = ((JavaOperation)operation).getJavaMethod().getName();
        }
        Interface interface1 = operation.getInterface();
        int numParams = ((List)operation.getInputType().getLogical()).size();
        List parmModes = operation.getParameterModes();
        int numOutOnlyHolders = 0;
        for (ParameterMode mode : parmModes) {
            if (!mode.equals((Object)ParameterMode.OUT)) continue;
            ++numOutOnlyHolders;
        }
        numParams += numOutOnlyHolders;
        if (interface1 != null && interface1.isRemotable()) {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (Method m : implClass.getMethods()) {
                if (m.getName().equals(name) && m.getParameterTypes().length == numParams) {
                    matchingMethods.add(m);
                    continue;
                }
                if (!m.getName().equals(name + "Async") || m.getParameterTypes().length != numParams + 1) continue;
                matchingMethods.add(m);
            }
            if (matchingMethods.size() == 1) {
                return (Method)matchingMethods.get(0);
            }
            if (matchingMethods.size() > 1) {
                Class<?>[] paramTypes = JavaInterfaceUtil.getPhysicalTypes(operation);
                return implClass.getMethod(name, paramTypes);
            }
            throw new NoSuchMethodException("No matching method for operation " + operation.getName() + " is found on " + implClass);
        }
        Class<?>[] paramTypes = JavaInterfaceUtil.getPhysicalTypes(operation);
        return implClass.getMethod(name, paramTypes);
    }

    public static Method findAsyncServerMethod(Class<?> implClass, JavaOperation operation) throws NoSuchMethodException {
        if (operation.getJavaMethod() != null) {
            return operation.getJavaMethod();
        }
        String name = operation.getJavaMethod().getName();
        List actualOps = (List)operation.getInterface().getAttributes().get("ASYNC-SERVER-OPERATIONS");
        Operation matchingOp = null;
        for (Operation op : actualOps) {
            if (!op.getName().equals(name)) continue;
            matchingOp = op;
            break;
        }
        if (matchingOp == null) {
            throw new NoSuchMethodException("No matching async method for operation " + operation.getName());
        }
        int numParams = ((List)matchingOp.getInputType().getLogical()).size();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method m : implClass.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != numParams) continue;
            matchingMethods.add(m);
        }
        if (matchingMethods.size() == 1) {
            return (Method)matchingMethods.get(0);
        }
        if (matchingMethods.size() > 1) {
            Class<?>[] paramTypes = JavaInterfaceUtil.getPhysicalTypes(matchingOp);
            return implClass.getMethod(name, paramTypes);
        }
        throw new NoSuchMethodException("No matching method for operation " + operation.getName() + " is found on " + implClass);
    }

    private static Class<?>[] getPhysicalTypes(Operation operation) {
        DataType inputType = operation.getInputType();
        if (inputType == null) {
            return new Class[0];
        }
        List types = (List)inputType.getLogical();
        Class[] javaTypes = new Class[types.size()];
        for (int i = 0; i < javaTypes.length; ++i) {
            DataType type = (DataType)types.get(i);
            javaTypes[i] = JavaInterfaceUtil.getClassOfDataType(type);
        }
        return javaTypes;
    }

    public static Operation findOperation(Method method, Collection<Operation> operations) {
        for (Operation operation : operations) {
            if (!JavaInterfaceUtil.match(operation, method)) continue;
            return operation;
        }
        return null;
    }

    private static boolean match(Operation operation, Method method) {
        Class<?>[] params = method.getParameterTypes();
        DataType inputType = operation.getInputType();
        List types = (List)inputType.getLogical();
        boolean found = true;
        if (types.size() == params.length && method.getName().equals(operation.getName())) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> clazz = params[i];
                if (clazz.equals(((DataType)((List)operation.getInputType().getLogical()).get(i)).getPhysical())) continue;
                found = false;
            }
        } else {
            found = false;
        }
        return found;
    }

    private static String getPackageName(Class<?> cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    public static String getNamespace(Class<?> cls) {
        String packageName = JavaInterfaceUtil.getPackageName(cls);
        if ("".equals(packageName)) {
            return "";
        }
        StringBuffer ns = new StringBuffer("http://");
        String[] names = packageName.split("\\.");
        for (int i = names.length - 1; i >= 0; --i) {
            ns.append(names[i]);
            if (i == 0) continue;
            ns.append('.');
        }
        ns.append('/');
        return ns.toString();
    }

    private static Class<?> getClassOfDataType(DataType<?> dataType) {
        Type generic = dataType.getGenericType();
        boolean isGeneric = generic != null && generic != dataType.getPhysical() && (generic instanceof TypeVariable || generic instanceof ParameterizedType);
        Class<?> javaType = null;
        if (isGeneric) {
            javaType = JavaInterfaceUtil.getClassOfSimpleGeneric(generic);
        } else {
            Class physical = dataType.getPhysical();
            javaType = JavaInterfaceUtil.getClassOfPhysical(physical);
        }
        if (javaType == null) {
            throw new UnsupportedOperationException();
        }
        return javaType;
    }

    private static Class<?> getClassOfSimpleGeneric(Type generic) {
        Class javaType = null;
        if (generic instanceof TypeVariable) {
            javaType = Object.class;
        } else if (generic instanceof ParameterizedType) {
            javaType = (Class)((ParameterizedType)generic).getRawType();
        }
        return javaType;
    }

    private static Class<?> getClassOfPhysical(Type physical) {
        Class javaType = null;
        if (physical instanceof Class) {
            javaType = (Class)physical;
        }
        return javaType;
    }
}

