/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceIntrospectorImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaOperationImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.oasisopen.sca.ServiceRuntimeException;

public abstract class JavaInterfaceFactoryImpl
implements JavaInterfaceFactory {
    private List<JavaInterfaceVisitor> visitors = new ArrayList<JavaInterfaceVisitor>();
    private JavaInterfaceIntrospectorImpl introspector;
    private Map<Class<?>, JavaInterface> normalCache = Collections.synchronizedMap(new WeakHashMap());
    private Map<Class<?>, JavaInterface> forceRemotableCache = Collections.synchronizedMap(new WeakHashMap());

    public JavaInterfaceFactoryImpl() {
        this.introspector = new JavaInterfaceIntrospectorImpl(this);
    }

    @Override
    public JavaInterface createJavaInterface() {
        return new JavaInterfaceImpl();
    }

    @Override
    public JavaInterface createJavaInterface(Class<?> interfaceClass) throws InvalidInterfaceException {
        return this.createJavaInterface(interfaceClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaInterface createJavaInterface(Class<?> interfaceClass, boolean forceRemotable) throws InvalidInterfaceException {
        Class<?> clazz = interfaceClass;
        synchronized (clazz) {
            Map<Class<?>, JavaInterface> cache = forceRemotable ? this.forceRemotableCache : this.normalCache;
            JavaInterface javaInterface = cache.get(interfaceClass);
            if (javaInterface == null) {
                javaInterface = this.createJavaInterface();
                if (forceRemotable) {
                    javaInterface.setRemotable(true);
                }
                this.introspector.introspectInterface(javaInterface, interfaceClass);
                javaInterface.setUnresolved(false);
                cache.put(interfaceClass, javaInterface);
            }
            return javaInterface;
        }
    }

    @Override
    public void createJavaInterface(JavaInterface javaInterface, Class<?> interfaceClass) throws InvalidInterfaceException {
        this.introspector.introspectInterface(javaInterface, interfaceClass);
    }

    @Override
    public JavaInterfaceContract createJavaInterfaceContract() {
        return new JavaInterfaceContractImpl();
    }

    @Override
    public void addInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.add(extension);
    }

    @Override
    public void removeInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.remove(extension);
    }

    @Override
    public List<JavaInterfaceVisitor> getInterfaceVisitors() {
        return this.visitors;
    }

    @Override
    public JavaOperation createJavaOperation(Method method) {
        JavaOperationImpl op = new JavaOperationImpl();
        op.setJavaMethod(method);
        op.setName(method.getName());
        return op;
    }

    @Override
    public void removeInterfacesForContribution(ClassLoader contributionClassloader) {
        this.removeInterfacesFromCache(contributionClassloader, this.normalCache);
        this.removeInterfacesFromCache(contributionClassloader, this.forceRemotableCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInterfacesFromCache(ClassLoader contributionClassloader, Map<Class<?>, JavaInterface> cache) {
        try {
            Map<Class<?>, JavaInterface> map = cache;
            synchronized (map) {
                Set<Class<?>> clsSet = cache.keySet();
                Iterator<Class<?>> i = clsSet.iterator();
                while (i.hasNext()) {
                    Class<?> cls = i.next();
                    if (cls.getClassLoader() != contributionClassloader) continue;
                    i.remove();
                }
            }
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Map<Class<?>, JavaInterface> getNormalCache() {
        return this.normalCache;
    }

    public Map<Class<?>, JavaInterface> getForceRemotableCache() {
        return this.forceRemotableCache;
    }
}

