/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.util;

import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaXMLMapper {
    public static final String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final Map<Class, QName> JAVA2XML = new HashMap<Class, QName>();
    private static final Map<String, Class> XML2JAVA = new HashMap<String, Class>();

    static {
        JAVA2XML.put(Boolean.TYPE, JavaXMLMapper.getTypeName("boolean"));
        JAVA2XML.put(Byte.TYPE, JavaXMLMapper.getTypeName("byte"));
        JAVA2XML.put(Short.TYPE, JavaXMLMapper.getTypeName("short"));
        JAVA2XML.put(Integer.TYPE, JavaXMLMapper.getTypeName("int"));
        JAVA2XML.put(Long.TYPE, JavaXMLMapper.getTypeName("long"));
        JAVA2XML.put(Float.TYPE, JavaXMLMapper.getTypeName("float"));
        JAVA2XML.put(Double.TYPE, JavaXMLMapper.getTypeName("double"));
        JAVA2XML.put(Boolean.class, JavaXMLMapper.getTypeName("boolean"));
        JAVA2XML.put(Byte.class, JavaXMLMapper.getTypeName("byte"));
        JAVA2XML.put(Short.class, JavaXMLMapper.getTypeName("short"));
        JAVA2XML.put(Integer.class, JavaXMLMapper.getTypeName("int"));
        JAVA2XML.put(Long.class, JavaXMLMapper.getTypeName("long"));
        JAVA2XML.put(Float.class, JavaXMLMapper.getTypeName("float"));
        JAVA2XML.put(Double.class, JavaXMLMapper.getTypeName("double"));
        JAVA2XML.put(String.class, JavaXMLMapper.getTypeName("string"));
        JAVA2XML.put(BigInteger.class, JavaXMLMapper.getTypeName("integer"));
        JAVA2XML.put(BigDecimal.class, JavaXMLMapper.getTypeName("decimal"));
        JAVA2XML.put(Calendar.class, JavaXMLMapper.getTypeName("dateTime"));
        JAVA2XML.put(Date.class, JavaXMLMapper.getTypeName("dateTime"));
        JAVA2XML.put(QName.class, JavaXMLMapper.getTypeName("QName"));
        JAVA2XML.put(URI.class, JavaXMLMapper.getTypeName("string"));
        JAVA2XML.put(XMLGregorianCalendar.class, JavaXMLMapper.getTypeName("anySimpleType"));
        JAVA2XML.put(Duration.class, JavaXMLMapper.getTypeName("duration"));
        JAVA2XML.put(Object.class, JavaXMLMapper.getTypeName("anyType"));
        JAVA2XML.put(Image.class, JavaXMLMapper.getTypeName("base64Binary"));
        JAVA2XML.put(byte[].class, JavaXMLMapper.getTypeName("base64Binary"));
        JAVA2XML.put(Source.class, JavaXMLMapper.getTypeName("base64Binary"));
        JAVA2XML.put(UUID.class, JavaXMLMapper.getTypeName("string"));
        XML2JAVA.put("string", String.class);
        XML2JAVA.put("integer", BigInteger.class);
        XML2JAVA.put("int", Integer.TYPE);
        XML2JAVA.put("long", Long.TYPE);
        XML2JAVA.put("short", Short.TYPE);
        XML2JAVA.put("decimal", BigDecimal.class);
        XML2JAVA.put("float", Float.TYPE);
        XML2JAVA.put("double", Double.TYPE);
        XML2JAVA.put("boolean", Boolean.TYPE);
        XML2JAVA.put("byte", Byte.TYPE);
        XML2JAVA.put("QName", QName.class);
        XML2JAVA.put("dateTime", XMLGregorianCalendar.class);
        XML2JAVA.put("base64Binary", byte[].class);
        XML2JAVA.put("hexBinary", byte[].class);
        XML2JAVA.put("unsignedInt", Long.TYPE);
        XML2JAVA.put("unsignedShort", Integer.TYPE);
        XML2JAVA.put("unsignedByte", Short.TYPE);
        XML2JAVA.put("time", XMLGregorianCalendar.class);
        XML2JAVA.put("date", XMLGregorianCalendar.class);
        XML2JAVA.put("gDay", XMLGregorianCalendar.class);
        XML2JAVA.put("gMonth", XMLGregorianCalendar.class);
        XML2JAVA.put("gYear", XMLGregorianCalendar.class);
        XML2JAVA.put("gYearMonth", XMLGregorianCalendar.class);
        XML2JAVA.put("gMonthDay", XMLGregorianCalendar.class);
        XML2JAVA.put("anySimpleType", Object.class);
        XML2JAVA.put("duration", Duration.class);
        XML2JAVA.put("NOTATION", QName.class);
    }

    private JavaXMLMapper() {
    }

    public static Class getJavaType(QName xmlType) {
        if (URI_2001_SCHEMA_XSD.equals(xmlType.getNamespaceURI())) {
            return XML2JAVA.get(xmlType.getLocalPart());
        }
        return null;
    }

    private static QName getTypeName(String name) {
        return new QName(URI_2001_SCHEMA_XSD, name);
    }

    public static QName getXMLType(Class javaType) {
        return JAVA2XML.get(javaType);
    }

    private static String getPackageName(Class<?> cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    public static String getNamespace(Class<?> cls) {
        String packageName = JavaXMLMapper.getPackageName(cls);
        if ("".equals(packageName)) {
            return "";
        }
        StringBuffer ns = new StringBuffer("http://");
        String[] names = packageName.split("\\.");
        int i = names.length - 1;
        while (i >= 0) {
            ns.append(names[i]);
            if (i != 0) {
                ns.append('.');
            }
            --i;
        }
        ns.append('/');
        return ns.toString();
    }
}

