/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationImpl
implements Operation {
    private String name;
    private boolean unresolved;
    private DataType outputType;
    private DataType<List<DataType>> inputType;
    private List<DataType> faultTypes;
    private Interface interfaze;
    private ConversationSequence conversationSequence = ConversationSequence.CONVERSATION_NONE;
    private boolean nonBlocking;
    private boolean wrapperStyle;
    private WrapperInfo wrapper;
    private boolean dynamic;
    private Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
    private Map<QName, List<DataType<XMLType>>> faultBeans;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private ExtensionType type;

    public OperationImpl() {
        this.inputType = new DataTypeImpl("idl:input", Object[].class, new ArrayList());
        this.faultTypes = new ArrayList<DataType>();
        this.faultBeans = new HashMap<QName, List<DataType<XMLType>>>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public List<DataType> getFaultTypes() {
        return this.faultTypes;
    }

    @Override
    public void setFaultTypes(List<DataType> faultTypes) {
        this.faultTypes = faultTypes;
    }

    @Override
    public DataType<List<DataType>> getInputType() {
        return this.inputType;
    }

    @Override
    public void setInputType(DataType<List<DataType>> inputType) {
        this.inputType = inputType;
    }

    @Override
    public DataType getOutputType() {
        return this.outputType;
    }

    @Override
    public void setOutputType(DataType outputType) {
        this.outputType = outputType;
    }

    @Override
    public Interface getInterface() {
        return this.interfaze;
    }

    @Override
    public void setInterface(Interface interfaze) {
        this.interfaze = interfaze;
    }

    @Override
    public ConversationSequence getConversationSequence() {
        return this.conversationSequence;
    }

    @Override
    public void setConversationSequence(ConversationSequence conversationSequence) {
        this.conversationSequence = conversationSequence;
    }

    @Override
    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.conversationSequence == null ? 0 : this.conversationSequence.hashCode());
        result = 31 * result + (this.inputType == null ? 0 : this.inputType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nonBlocking ? 1231 : 1237);
        result = 31 * result + (this.outputType == null ? 0 : this.outputType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationImpl other = (OperationImpl)obj;
        if (this.conversationSequence == null ? other.conversationSequence != null : !this.conversationSequence.equals((Object)other.conversationSequence)) {
            return false;
        }
        if (this.inputType == null ? other.inputType != null : !this.inputType.equals(other.inputType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nonBlocking != other.nonBlocking) {
            return false;
        }
        return !(this.outputType == null ? other.outputType != null : !this.outputType.equals(other.outputType));
    }

    @Override
    public WrapperInfo getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(WrapperInfo wrapperInfo) {
        this.wrapper = wrapperInfo;
    }

    @Override
    public boolean isWrapperStyle() {
        return this.wrapperStyle;
    }

    @Override
    public void setWrapperStyle(boolean wrapperStyle) {
        this.wrapperStyle = wrapperStyle;
    }

    @Override
    public String getDataBinding() {
        return this.wrapper != null ? this.wrapper.getDataBinding() : null;
    }

    @Override
    public void setDataBinding(String dataBinding) {
        if (this.wrapper != null) {
            this.wrapper.setDataBinding(dataBinding);
        }
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void setDynamic(boolean b) {
        this.dynamic = b;
    }

    @Override
    public Map<QName, List<DataType<XMLType>>> getFaultBeans() {
        return this.faultBeans;
    }

    @Override
    public void setFaultBeans(Map<QName, List<DataType<XMLType>>> faultBeans) {
        this.faultBeans = faultBeans;
    }

    @Override
    public OperationImpl clone() throws CloneNotSupportedException {
        OperationImpl copy = (OperationImpl)super.clone();
        ArrayList<DataType> clonedFaultTypes = new ArrayList<DataType>(this.faultTypes.size());
        for (DataType t : this.faultTypes) {
            clonedFaultTypes.add((DataType)t.clone());
        }
        copy.faultTypes = clonedFaultTypes;
        ArrayList<DataType> clonedLogicalTypes = new ArrayList<DataType>();
        for (DataType t : this.inputType.getLogical()) {
            DataType type = (DataType)t.clone();
            clonedLogicalTypes.add(type);
        }
        DataTypeImpl clonedInputType = new DataTypeImpl(this.inputType.getPhysical(), clonedLogicalTypes);
        clonedInputType.setDataBinding(this.inputType.getDataBinding());
        copy.inputType = clonedInputType;
        if (this.outputType != null) {
            copy.outputType = (DataType)this.outputType.clone();
        }
        copy.attributes = new ConcurrentHashMap<Object, Object>();
        copy.attributes.putAll(this.attributes);
        return copy;
    }

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    public ExtensionType getType() {
        return this.type;
    }

    public void setType(ExtensionType type) {
        this.type = type;
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

