/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceContractMapperImpl
implements InterfaceContractMapper {
    @Override
    public boolean isCompatible(DataType source, DataType target, boolean remotable) {
        if (source == target) {
            return true;
        }
        if (!remotable) {
            if (source == null || target == null) {
                return false;
            }
            return target.getPhysical().isAssignableFrom(source.getPhysical());
        }
        return true;
    }

    @Override
    public boolean isCompatible(Operation source, Operation target, boolean remotable) {
        if (source == target) {
            return true;
        }
        if (source.isDynamic() || target.isDynamic()) {
            return true;
        }
        if (!source.getName().equals(target.getName())) {
            return false;
        }
        if (source.getInterface().isRemotable() != target.getInterface().isRemotable()) {
            return false;
        }
        DataType sourceOutputType = source.getOutputType();
        DataType targetOutputType = target.getOutputType();
        if (!this.isCompatible(targetOutputType, sourceOutputType, remotable)) {
            return false;
        }
        boolean checkSourceWrapper = true;
        List<DataType> sourceInputType = source.getInputType().getLogical();
        if (source.isWrapperStyle() && source.getWrapper() != null) {
            sourceInputType = source.getWrapper().getUnwrappedInputType().getLogical();
            checkSourceWrapper = false;
        }
        boolean checkTargetWrapper = true;
        List<DataType> targetInputType = target.getInputType().getLogical();
        if (target.isWrapperStyle() && target.getWrapper() != null) {
            targetInputType = target.getWrapper().getUnwrappedInputType().getLogical();
            checkTargetWrapper = false;
        }
        if (checkSourceWrapper != checkTargetWrapper) {
            return true;
        }
        if (sourceInputType.size() != targetInputType.size()) {
            return false;
        }
        int size = sourceInputType.size();
        int i = 0;
        while (i < size) {
            if (!this.isCompatible(sourceInputType.get(i), targetInputType.get(i), remotable)) {
                return false;
            }
            ++i;
        }
        for (DataType targetFaultType : target.getFaultTypes()) {
            boolean found = true;
            for (DataType sourceFaultType : source.getFaultTypes()) {
                found = false;
                if (!this.isCompatible(targetFaultType, sourceFaultType, remotable)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private Operation getOperation(List<Operation> operations, String name) {
        for (Operation op : operations) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    @Override
    public boolean checkCompatibility(InterfaceContract source, InterfaceContract target, boolean ignoreCallback, boolean silent) throws IncompatibleInterfaceContractException {
        Operation targetOperation;
        if (source == target) {
            return true;
        }
        if (source.getInterface().isDynamic() || target.getInterface().isDynamic()) {
            return true;
        }
        if (source.getInterface().isRemotable() != target.getInterface().isRemotable()) {
            if (!silent) {
                throw new IncompatibleInterfaceContractException("Remotable settings do not match", source, target);
            }
            return false;
        }
        if (source.getInterface().isConversational() != target.getInterface().isConversational()) {
            if (!silent) {
                throw new IncompatibleInterfaceContractException("Interaction scopes do not match", source, target);
            }
            return false;
        }
        for (Operation operation : source.getInterface().getOperations()) {
            targetOperation = this.map(target.getInterface(), operation);
            if (targetOperation == null) {
                if (!silent) {
                    throw new IncompatibleInterfaceContractException("Operation not found on target", source, target);
                }
                return false;
            }
            if (source.getInterface().isRemotable() || this.isCompatible(operation, targetOperation, false)) continue;
            if (!silent) {
                throw new IncompatibleInterfaceContractException("Target operations are not compatible", source, target);
            }
            return false;
        }
        if (ignoreCallback) {
            return true;
        }
        if (source.getCallbackInterface() == null && target.getCallbackInterface() == null) {
            return true;
        }
        if (source.getCallbackInterface() == null || target.getCallbackInterface() == null) {
            if (!silent) {
                throw new IncompatibleInterfaceContractException("Callback interface doesn't match", source, target);
            }
            return false;
        }
        for (Operation operation : source.getCallbackInterface().getOperations()) {
            targetOperation = this.getOperation(target.getCallbackInterface().getOperations(), operation.getName());
            if (targetOperation == null) {
                if (!silent) {
                    throw new IncompatibleInterfaceContractException("Callback operation not found on target", source, target, null, targetOperation);
                }
                return false;
            }
            if (source.getCallbackInterface().isRemotable() || operation.equals(targetOperation)) continue;
            if (!silent) {
                throw new IncompatibleInterfaceContractException("Target callback operation is not compatible", source, target, operation, targetOperation);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatible(Interface source, Interface target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.isDynamic() || target.isDynamic()) {
            return true;
        }
        if (source.isRemotable() != target.isRemotable()) {
            return false;
        }
        if (source.isConversational() != target.isConversational()) {
            return false;
        }
        for (Operation operation : source.getOperations()) {
            Operation targetOperation = this.getOperation(target.getOperations(), operation.getName());
            if (targetOperation == null) {
                return false;
            }
            if (this.isCompatible(operation, targetOperation, source.isRemotable())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatible(InterfaceContract source, InterfaceContract target) {
        try {
            return this.checkCompatibility(source, target, false, false);
        }
        catch (IncompatibleInterfaceContractException incompatibleInterfaceContractException) {
            return false;
        }
    }

    @Override
    public Operation map(Interface target, Operation source) {
        if (target == null || target.isDynamic()) {
            return source;
        }
        if (target.isRemotable()) {
            for (Operation op : target.getOperations()) {
                if (!op.getName().equals(source.getName())) continue;
                return op;
            }
            return null;
        }
        for (Operation op : target.getOperations()) {
            if (!this.isCompatible(source, op, target.isRemotable())) continue;
            return op;
        }
        return null;
    }
}

