/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.interfacedef.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeImpl<L>
implements DataType<L> {
    private String dataBinding;
    private Class<?> physical;
    private Type genericType;
    private L logical;
    private Map<Class<?>, Object> metaDataMap;

    public DataTypeImpl(Class<?> physical, L logical) {
        this(null, physical, physical, logical);
    }

    public DataTypeImpl(String dataBinding, Class<?> physical, L logical) {
        this(dataBinding, physical, physical, logical);
    }

    public DataTypeImpl(String dataBinding, Class<?> physical, Type genericType, L logical) {
        this.dataBinding = dataBinding;
        this.physical = physical;
        this.genericType = genericType;
        this.logical = logical;
    }

    @Override
    public Class<?> getPhysical() {
        return this.physical;
    }

    @Override
    public void setPhysical(Class<?> physical) {
        this.physical = physical;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public L getLogical() {
        return this.logical;
    }

    @Override
    public void setLogical(L logical) {
        this.logical = logical;
    }

    @Override
    public String getDataBinding() {
        return this.dataBinding;
    }

    @Override
    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.physical).append(" ").append(this.dataBinding).append(" ").append(this.logical);
        return sb.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataTypeImpl copy = (DataTypeImpl)super.clone();
        return copy;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataBinding == null ? 0 : this.dataBinding.hashCode());
        result = 31 * result + (this.genericType == null ? 0 : this.genericType.hashCode());
        result = 31 * result + (this.logical == null ? 0 : this.logical.hashCode());
        result = 31 * result + (this.physical == null ? 0 : this.physical.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeImpl other = (DataTypeImpl)obj;
        if (this.dataBinding == null ? other.dataBinding != null : !this.dataBinding.equals(other.dataBinding)) {
            return false;
        }
        if (this.genericType == null ? other.genericType != null : !this.genericType.equals(other.genericType)) {
            return false;
        }
        if (this.logical == null ? other.logical != null : !this.logical.equals(other.logical)) {
            return false;
        }
        return !(this.physical == null ? other.physical != null : !this.physical.equals(other.physical));
    }

    @Override
    public <T> T getMetaData(Class<T> type) {
        return this.metaDataMap == null ? null : (T)type.cast(this.metaDataMap.get(type));
    }

    @Override
    public <T> void setMetaData(Class<T> type, T metaData) {
        if (this.metaDataMap == null) {
            this.metaDataMap = new ConcurrentHashMap();
        }
        this.metaDataMap.put(type, metaData);
    }
}

