/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationImpl
implements Operation {
    private String name;
    private boolean unresolved;
    private DataType outputType;
    private DataType<List<DataType>> inputType;
    private List<DataType> faultTypes;
    private Interface interfaze;
    private ConversationSequence conversationSequence = ConversationSequence.CONVERSATION_NONE;
    private List<ParameterMode> parameterModes = new ArrayList<ParameterMode>();
    private boolean nonBlocking;
    private boolean inputWrapperStyle;
    private boolean outputWrapperStyle;
    private WrapperInfo inputWrapper;
    private WrapperInfo outputWrapper;
    private boolean dynamic;
    private Map<QName, List<DataType<XMLType>>> faultBeans;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private IntentAttachPointType type;

    public OperationImpl() {
        this.inputType = new DataTypeImpl("idl:input", Object[].class, new ArrayList());
        this.faultTypes = new ArrayList<DataType>();
        this.faultBeans = new HashMap<QName, List<DataType<XMLType>>>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public List<DataType> getFaultTypes() {
        return this.faultTypes;
    }

    @Override
    public void setFaultTypes(List<DataType> faultTypes) {
        this.faultTypes = faultTypes;
    }

    @Override
    public DataType<List<DataType>> getInputType() {
        return this.inputType;
    }

    @Override
    public void setInputType(DataType<List<DataType>> inputType) {
        this.inputType = inputType;
    }

    @Override
    public DataType getOutputType() {
        return this.outputType;
    }

    @Override
    public void setOutputType(DataType outputType) {
        this.outputType = outputType;
    }

    @Override
    public Interface getInterface() {
        return this.interfaze;
    }

    @Override
    public void setInterface(Interface interfaze) {
        this.interfaze = interfaze;
    }

    @Override
    public ConversationSequence getConversationSequence() {
        return this.conversationSequence;
    }

    @Override
    public void setConversationSequence(ConversationSequence conversationSequence) {
        this.conversationSequence = conversationSequence;
    }

    @Override
    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    @Override
    public WrapperInfo getInputWrapper() {
        return this.inputWrapper;
    }

    @Override
    public void setInputWrapper(WrapperInfo inputWrapper) {
        this.inputWrapper = inputWrapper;
    }

    @Override
    public WrapperInfo getOutputWrapper() {
        return this.outputWrapper;
    }

    @Override
    public void setOutputWrapper(WrapperInfo outputWrapper) {
        this.outputWrapper = outputWrapper;
    }

    @Override
    public boolean isInputWrapperStyle() {
        return this.inputWrapperStyle;
    }

    @Override
    public void setInputWrapperStyle(boolean wrapperStyle) {
        this.inputWrapperStyle = wrapperStyle;
    }

    @Override
    public boolean isOutputWrapperStyle() {
        return this.outputWrapperStyle;
    }

    @Override
    public void setOutputWrapperStyle(boolean wrapperStyle) {
        this.outputWrapperStyle = wrapperStyle;
    }

    @Override
    public String getDataBinding() {
        return this.inputWrapper != null ? this.inputWrapper.getDataBinding() : null;
    }

    @Override
    public void setDataBinding(String dataBinding) {
        if (this.inputWrapper != null) {
            this.inputWrapper.setDataBinding(dataBinding);
        }
        if (this.outputWrapper != null) {
            this.outputWrapper.setDataBinding(dataBinding);
        }
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void setDynamic(boolean b) {
        this.dynamic = b;
    }

    @Override
    public Map<QName, List<DataType<XMLType>>> getFaultBeans() {
        return this.faultBeans;
    }

    @Override
    public void setFaultBeans(Map<QName, List<DataType<XMLType>>> faultBeans) {
        this.faultBeans = faultBeans;
    }

    @Override
    public OperationImpl clone() throws CloneNotSupportedException {
        OperationImpl copy = (OperationImpl)super.clone();
        ArrayList<DataType> clonedFaultTypes = new ArrayList<DataType>(this.faultTypes.size());
        for (DataType t : this.faultTypes) {
            clonedFaultTypes.add((DataType)t.clone());
        }
        copy.faultTypes = clonedFaultTypes;
        ArrayList<DataType> clonedLogicalTypes = new ArrayList<DataType>();
        for (DataType t : this.inputType.getLogical()) {
            DataType type = (DataType)t.clone();
            clonedLogicalTypes.add(type);
        }
        DataTypeImpl clonedInputType = new DataTypeImpl(this.inputType.getPhysical(), clonedLogicalTypes);
        clonedInputType.setDataBinding(this.inputType.getDataBinding());
        copy.inputType = clonedInputType;
        if (this.outputType != null) {
            copy.outputType = (DataType)this.outputType.clone();
        }
        return copy;
    }

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    public IntentAttachPointType getType() {
        return this.type;
    }

    public void setType(IntentAttachPointType type) {
        this.type = type;
    }

    @Override
    public List<ParameterMode> getParameterModes() {
        return this.parameterModes;
    }
}

