/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.runtime.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.ComponentName;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class ContextHelper {
    public static final String COMPONENT_ATTR = "org.apache.tuscany.sca.implementation.web.RuntimeComponent";

    public static ComponentContext getComponentContext(ServletContext sc) {
        RuntimeComponent rc = (RuntimeComponent)sc.getAttribute(COMPONENT_ATTR);
        return rc.getComponentContext();
    }

    public static <T> T getReference(String name, Class<T> type, ServletContext sc) {
        ServiceReference sr = ContextHelper.getComponentContext(sc).getServiceReference(type, name);
        if (sr == null) {
            throw new ServiceRuntimeException("Reference '" + name + "' undefined");
        }
        return (T)sr.getService();
    }

    public static Object getProperty(String name, ServletContext sc) {
        RuntimeComponent rc = (RuntimeComponent)sc.getAttribute(COMPONENT_ATTR);
        for (ComponentProperty p : rc.getProperties()) {
            if (!name.equals(p.getName())) continue;
            return p.getValue();
        }
        return null;
    }

    public static void inject(Object instance, ServletContext sc) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            String name;
            if (field.isAnnotationPresent(Reference.class)) {
                Reference ref = field.getAnnotation(Reference.class);
                name = ref.name() != null && !ref.name().equals("") ? ref.name() : field.getName();
                value = ContextHelper.getReference(name, field.getType(), sc);
                ContextHelper.setField(instance, field, value);
                continue;
            }
            if (field.isAnnotationPresent(Property.class)) {
                Property prop = field.getAnnotation(Property.class);
                name = prop.name() != null && !prop.name().equals("") ? prop.name() : field.getName();
                value = ContextHelper.getProperty(name, sc);
                ContextHelper.setField(instance, field, value);
                continue;
            }
            if (field.isAnnotationPresent(ComponentName.class)) {
                RuntimeComponent rc = (RuntimeComponent)sc.getAttribute(COMPONENT_ATTR);
                ContextHelper.setField(instance, field, rc.getName());
                continue;
            }
            if (!field.isAnnotationPresent(Context.class)) continue;
            ContextHelper.setField(instance, field, ContextHelper.getComponentContext(sc));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object value;
            String name;
            if (!((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1) continue;
            String targetName = ((Method)accessibleObject).getName().substring(3);
            Class<?> type = ((Method)accessibleObject).getParameterTypes()[0];
            if (accessibleObject.isAnnotationPresent(Reference.class)) {
                Reference ref = ((Method)accessibleObject).getAnnotation(Reference.class);
                name = ref.name() != null && !ref.name().equals("") ? ref.name() : targetName;
                value = ContextHelper.getReference(name, type, sc);
                ContextHelper.setMethod(instance, (Method)accessibleObject, value);
                continue;
            }
            if (accessibleObject.isAnnotationPresent(Property.class)) {
                Property prop = ((Method)accessibleObject).getAnnotation(Property.class);
                name = prop.name() != null && !prop.name().equals("") ? prop.name() : targetName;
                value = ContextHelper.getProperty(name, sc);
                ContextHelper.setMethod(instance, (Method)accessibleObject, value);
                continue;
            }
            if (accessibleObject.isAnnotationPresent(ComponentName.class)) {
                RuntimeComponent rc = (RuntimeComponent)sc.getAttribute(COMPONENT_ATTR);
                ContextHelper.setMethod(instance, (Method)accessibleObject, rc.getName());
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(Context.class)) continue;
            ContextHelper.setMethod(instance, (Method)accessibleObject, ContextHelper.getComponentContext(sc));
        }
    }

    private static void setMethod(Object instance, Method method, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (method.isAccessible()) {
            method.invoke(instance, value);
        } else {
            method.setAccessible(true);
            method.invoke(instance, value);
            method.setAccessible(false);
        }
    }

    private static void setField(Object instance, Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (field.isAccessible()) {
            field.set(instance, value);
        } else {
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(false);
        }
    }
}

