/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.runtime.jsp;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.TuscanyServiceReference;

public class ReferenceTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String type;
    protected Integer scope = 1;

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        Class<?> typeClass;
        ServletContext servletContext = this.pageContext.getServletContext();
        RuntimeComponent component = (RuntimeComponent)servletContext.getAttribute("org.apache.tuscany.sca.implementation.web.RuntimeComponent");
        if (component == null) {
            throw new JspException("No Web component found. Is there an <implementation.web> missing?");
        }
        try {
            typeClass = Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new JspException("Reference '" + this.name + "' type class not found: " + this.type);
        }
        try {
            this.setInterfaceContract(component, typeClass);
        }
        catch (InvalidInterfaceException e) {
            throw new JspException("Exception creating interface", (Throwable)e);
        }
        TuscanyServiceReference sr = component.getComponentContext().getServiceReference(typeClass, this.name);
        if (sr == null) {
            throw new JspException("Reference '" + this.name + "' undefined");
        }
        this.pageContext.setAttribute(this.name, sr.getService(), this.scope.intValue());
        return 6;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getScope() {
        return this.scope;
    }

    public void setScope(Integer scope) {
        this.scope = scope;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void setInterfaceContract(RuntimeComponent component, Class<?> typeClass) throws InvalidInterfaceException {
        ComponentReference ref = component.getReference(this.name);
        if (ref.getInterfaceContract() == null) {
            ExtensionPointRegistry epr = component.getComponentContext().getExtensionPointRegistry();
            FactoryExtensionPoint fep = (FactoryExtensionPoint)epr.getExtensionPoint(FactoryExtensionPoint.class);
            JavaInterfaceFactory jif = (JavaInterfaceFactory)fep.getFactory(JavaInterfaceFactory.class);
            JavaInterface javaIface = jif.createJavaInterface(typeClass);
            JavaInterfaceContract interfaceContract = jif.createJavaInterfaceContract();
            interfaceContract.setInterface((Interface)javaIface);
            ref.setInterfaceContract((InterfaceContract)interfaceContract);
        }
    }
}

