/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.runtime;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.implementation.web.WebImplementation;
import org.apache.tuscany.sca.implementation.web.runtime.ClientExtensionPoint;
import org.apache.tuscany.sca.implementation.web.runtime.ComponentContextProxy;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class WebImplementationProviderFactory
implements ImplementationProviderFactory<WebImplementation> {
    private ServletHost servletHost;
    private ClientExtensionPoint jsClient;

    public WebImplementationProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)extensionPoints);
        this.jsClient = (ClientExtensionPoint)extensionPoints.getExtensionPoint(ClientExtensionPoint.class);
    }

    public ImplementationProvider createImplementationProvider(RuntimeComponent component, WebImplementation implementation) {
        this.servletHost.setAttribute("org.apache.tuscany.sca.implementation.web.RuntimeComponent", (Object)component);
        this.servletHost.setAttribute("org.oasisopen.sca.ComponentContext", (Object)new ComponentContextProxy(component));
        ImplementationProvider impl = this.jsClient != null && implementation.getJSClient() ? this.jsClient.createImplementationProvider(component, implementation) : new ImplementationProvider(){

            public Invoker createInvoker(RuntimeComponentService arg0, Operation arg1) {
                throw new UnsupportedOperationException("Components using implementation.web have no services");
            }

            public void start() {
            }

            public void stop() {
            }

            public boolean supportsOneWayInvocation() {
                return false;
            }
        };
        return impl;
    }

    public Class<WebImplementation> getModelType() {
        return WebImplementation.class;
    }
}

